#ifndef Point_First
#define Point_First

#include "Types.h"

overload Scale();
overload Min();
overload Max();

class Point {
public:
	short x;
	short y;

public:
	Point()
	    { x= y= 0; }
	
	Point(short xy)
	    { x= y= xy; }
	
	Point(short xx, short yy)
	    { x= xx; y= yy; }

	Point(float sx, float sy)
	    { x= (short) sx; y= (short) sy; }

	short &operator[](bool b)
	    { if (b) return y; else return x; }

	friend Point operator+ (Point p1, Point p2)
	    { return Point(p1.x + p2.x, p1.y + p2.y); }

	friend Point operator- (Point p)
	    { return Point(-p.x, -p.y); }

	friend Point operator- (Point p1, Point p2)
	    { return Point(p1.x - p2.x, p1.y - p2.y); }

	friend Point operator* (Point p1, Point p2)
	    { return Point(p1.x * p2.x, p1.y * p2.y); }

	friend Point operator/ (Point p1, Point p2)
	    { return Point(p1.x / p2.x, p1.y / p2.y); }
	    
	friend Point Scale(Point p, Point num, Point denom)
	    { return Point((p.x*num.x)/denom.x, (p.y*num.y)/denom.y); }
	    
	friend Point Scale(Point p, float sx, float sy)
	    { return Point(p.x*sx, p.y*sy); }
	    
	Point operator+= (Point p)
	    { x+= p.x; y+= p.y; return *this; }

	Point operator-= (Point p)
	    { x-= p.x; y-= p.y; return *this; }

	Point operator*= (Point p)
	    { x*= p.x; y*= p.y; return *this; }

	Point operator/= (Point p)
	    { x/= p.x; y/= p.y; return *this; }

	friend bool operator== (Point p1, Point p2)
	    { return p1.x == p2.x && p1.y == p2.y; }

	friend bool operator!= (Point p1, Point p2)
	    { return p1.x != p2.x || p1.y != p2.y; }

	friend bool operator> (Point p1, Point p2)
	    { return p1.x > p2.x && p1.y > p2.y; }

	friend bool operator< (Point p1, Point p2)
	    { return p1.x < p2.x && p1.y < p2.y; }

	friend bool operator>= (Point p1, Point p2)
	    { return p1.x >= p2.x && p1.y >= p2.y; }

	friend bool operator<= (Point p1, Point p2)
	    { return p1.x <= p2.x && p1.y <= p2.y; }

	friend Point Abs (Point);

	friend Point Sign (Point);

	friend Point Min (Point, Point);

	friend Point Max (Point, Point);
	
	friend float Phi (Point);
	
	friend float Length (Point);

	friend void Swap (Point &p1, Point &p2)
	    { Point tmp; tmp = p1; p1 = p2; p2 = tmp; }   

	friend ostream& operator<< (ostream& s, Point p);
	    
	friend istream& operator>> (istream& s, Point& p);
	
	char *AsString();
};

extern const Point gPoint_1, gPoint0, gPoint1, gPoint2, gPoint3, gPoint4, gPoint8,
		   gPoint10, gPoint16;

#endif Point
