//$Inspector,InspectorItem,InspectorView, ShowMembers$
//$ObjectItem, FindReferences, RefreshHandler$ 

#include "Inspector.h"
#include "Application.h"
#include "Document.h"
#include "Window.h"
#include "View.h"
#include "Scroller.h"
#include "Clipper.h"
#include "Expander.h"
#include "Menu.h"
#include "Command.h"
#include "CmdNo.h"
#include "String.h"
#include "Error.h"
#include "CollectionView.h"
#include "ObjArray.h"
#include "Alert.h"
#include "WindowSystem.h"
#include "ProgEnv.h"
#include "ObjList.h"
#include "OrdCollection.h"
#include "ObjectTable.h"
#include "ClassItem.h"
#include "InspectorItem.h"

extern bool ValidAddress(void*);

const int cMaxItems = 100,
	  cMaxStack = 100,
	  cMaxObjects= 1500;   

const int cUPDATE   = 1,
	  cABORT    = 2,
	  cEXIT     = 3,
	  c_EXIT    = 4,
	  cEDITDECL = 5,
	  cEDITIMPL = 6,
	  cAPPL     = 7,
	  cABSTRVIEW= 8;

const int cSHOWALL     = cAPPL+1,
	  cUPDATELIST  = cAPPL+2,
	  cREFERENCES  = cAPPL+3,
	  cEMPTYCLASSES= cAPPL+4;

//---- id's of collectionviews        

const int cObjects      = 1,    
	  cClasses      = 2,
	  cReferences   = 3;

static class InspectorView *dbgView, *dbgView1, *dbgView2;
static int supercnt= 0, itemno, stackix= 0;

static Ref rstack[cMaxStack];

//---- InspectorView ---------------------------------------------------------------

MetaImpl(InspectorView, (I_O(menu), I_O(inspector)));

InspectorView::InspectorView(Inspector *insp) : (0, new ObjArray(cMaxItems), 0)
{
    menu= new Menu("inspector");
    inspector= insp;
    for (int i= 0; i < cMaxItems; i++)
	GetCollection()->Add(new InspectorItem());
    accessor= new ShowMembers;
}

InspectorView::~InspectorView()
{
    SafeDelete(accessor);
    SafeDelete(menu);
}

void InspectorView::SetInspected(Ref &newinsp)
{
    if (inspected == newinsp)
	return;
    if (inspected.IsObject())
	ObjPtr(inspected)->RemoveDependent(this);
    inspected= newinsp;
    if (inspected.IsObject())
	ObjPtr(inspected)->AddDependent(this);
    UpdateViews();
}

void InspectorView::Push(Ref &r)
{
    if (stackix < cMaxStack) {
	rstack[stackix++]= r;
	SetInspected(r);
    }
}

void InspectorView::Pop()
{
    if (stackix >= 2) {
	stackix--;
	SetInspected(rstack[stackix-1]);
    }
}

void InspectorView::Init(Object *op)
{
    stackix= 0;
    if (op)
	Push(Ref(op));
    else
	SetInspected(Ref());
}

void InspectorView::Draw(Rectangle r)
{
    if (inspected.addr)
	CollectionView::Draw(r);
    else
	GrPaintRect(r, ePatGrey25);
}

void InspectorView::SetExtent(Point newExtent)
{
    newExtent= Point(1000,1000);
    CollectionView::SetExtent(newExtent);
}

void InspectorView::ChiefDied (Object *op)
{
    if (inspected.addr == op)
	SetInspected(Ref());
}  

void InspectorView::DoUpdate (ObjPtr op, void *)
{
    if ((op == inspected.addr) && (op != 0))
	UpdateViews();
}

void InspectorView::DoSelect(Rectangle r)
{
    Ref ref;
    int i, type;

    InspectorItem *di= At(r.origin.y);
    if (di == 0)
	return;

    type= di->GetType();
    if (type == cUP) {  // go up
	dbgView2->SetInspected(Ref());
	inspector->Reset();
	if (this == dbgView1)
	    dbgView1->Pop();
    } else if (type == cCLASS || type > 0) {    // try to go go down
	ref= di->Deref(inspected);

	if (ref.addr == 0 || ref == inspected)
	    return;

	for (i= 0; i < stackix; i++)
	    if (rstack[i] == ref)
		break;

	if (i >= stackix) {    // not found
	    if (this == dbgView2)
		dbgView1->Push(inspected);
	    dbgView2->SetInspected(ref);
	} else {                // found
	    stackix= i+1;
	    dbgView1->SetInspected(rstack[stackix-1]);
	    dbgView2->SetInspected(Ref());
	}
	inspector->Reset();
    }
}

void InspectorView::SetInfo(char *name, int t, short o, int len)
{
    InspectorItem *di= At(itemno);
    if (di) {
	di->SetInfo(name, t, o, len);
	itemno++;
    }
}

void InspectorView::UpdateViews()
{
    register InspectorItem *di;
    int i;

    itemno= 0;

    if (inspected.addr && inspected.addr == gApplication)
	gApplication->UpdateGlobals();

    if (inspected.addr) {
	if (this == dbgView2 || stackix > 1)
	    SetInfo("<---", cUP);

	if (inspected.IsObject()) {
	    dbgView= this;
	    supercnt= 0;
	    ObjPtr(inspected)->IsA()->EnumerateMembers(accessor);
	} else if ((inspected.type & T_VEC) || (inspected.type & T_ARR)
						|| (inspected.type & T_STR2)) {
	    int size, i, off, l, tt= inspected.type;
	    char buf[10];

	    size= sizeof(void*);
	    if (inspected.type & T_STR2) {
		void **lp= (void**) inspected.addr;
		for (i= 0; lp[i]; i++)
		    ;
		inspected.len= i;
	    }
	    l= inspected.len;

	    tt&= ~(T_VEC+T_ARR+T_STR2);

	    for (i= 0, off= 0; i < cMaxItems && i < l; i++, off+= size)
		SetInfo(form("[%d]", i), tt, off);
	}
	for (i= 0; i<itemno; i++) {
	    di= At(i);
	    if (di)
		di->InitItem(inspected);
	}
    }

    for (i= itemno; i<cMaxItems; i++)
	SetInfo();

    SetSelection(gRect0);
    Modified();
}

void InspectorView::DoCreateMenu(Menu *menu)
{
    menu->AppendItems("update",  cUPDATE,
		      "edit definition",    cEDITDECL,
		      "edit implementation",cEDITIMPL,
		      "inspect application",cAPPL,
		      "references",         cREFERENCES,
		      "abstract view",      cABSTRVIEW,
		       "-",
		      "exit",               cEXIT,
		      "_exit",              c_EXIT,
		      "abort (with core)",  cABORT,
		      0);
}

void InspectorView::DoSetupMenu(Menu *menu)
{
    menu->EnableItems(cABORT, cEXIT, c_EXIT, cAPPL, 0);
    if (inspected)
	menu->EnableItems(cUPDATE, cEDITDECL, cEDITIMPL, 0);
    if (inspected.IsObject()) {
	char *viewname= gProgEnv->HasAbstractView(ObjPtr(inspected));
	if (viewname) {
	    menu->ReplaceItem(cABSTRVIEW, viewname);
	    menu->EnableItem(cABSTRVIEW);
	}
	menu->EnableItem(cREFERENCES);
    }
}

Command *InspectorView::DoMenuCommand(int cmd)
{
    switch (cmd) {
    case cUPDATE: 
	UpdateViews();
	break;
	
    case cAPPL:
	gApplication->Inspect();
	break;
	
    case cABORT:
	abort();
	
    case cEXIT:
	Exit(1);
	
    case c_EXIT:
	Exit(1, FALSE);
	
    case cEDITDECL:
    case cEDITIMPL:
	if (inspected.IsObject())
	    ObjPtr(inspected)->EditSource(cmd == cEDITDECL);
	break;
	
    case cREFERENCES:
	if (inspected.IsObject())
	    inspector->References(ObjPtr(inspected));
	break;
	
    case cABSTRVIEW:
	if (inspected.IsObject())
	    gProgEnv->ShowAbstractView(ObjPtr(inspected));
	break;

    default:
	break;
    }
    return gNoChanges;
}

bool InspectorView::PrintOnWhenDependent(Object *)
{
    return FALSE;
}

//---- timeout handler to refresh inspector views -----------------------------

class RefreshHandler : public SysEvtHandler {
    Window *inspectorWindow;
public:
    RefreshHandler(Window *w) : (0)
	{ inspectorWindow= w; }
    bool HasInterest()
	{ return inspectorWindow->IsOpen(); }
    void Notify(SysEventCodes, int) 
	{ inspectorWindow->UpdateEvent(); }
    
};

//---- Inspector ----------------------------------------------------------------

MetaImpl(Inspector, (I_O(win), I_O(classes), I_B(hideEmptyClasses), I_O(objects), 
		     I_O(ClassItems), I_O(ObjectItems),
		     I_O(references), I_O(ReferenceItems), 
		     I_O(refTitle), I_O(objTitle)));

Inspector::Inspector(WindowFlags f)
{
    Menu *menu;
    findReferences= new FindReferences(this); 
    hideEmptyClasses= FALSE;
    
    classes= new CollectionView(this, 0, 0);
    menu= new Menu("", FALSE, 0, 1, FALSE);
    menu->AppendItems ("update", cUPDATELIST,
		       "hide empty classes", cEMPTYCLASSES, 0);
    classes->SetId(cClasses);
    classes->SetMenu(menu);
    UpdateList();
    
    objects= new CollectionView(this, 0, 0);
    objTitle= new TextItem("", new Font(gFixedFont->Fid(), gFixedFont->Size(), eFaceItalic), Point(2,1));
    ResetObjects();
    menu= new Menu("", FALSE, 0, 1, FALSE);
    menu->AppendItems ("all instances", cSHOWALL, 0);
    objects->SetId(cObjects);   
    objects->SetMenu(menu);
    
    references= new CollectionView(this, 0, 0, 0);
    refTitle= new TextItem("", new Font(gFixedFont->Fid(), 
				gFixedFont->Size(), eFaceItalic), Point(2,1));
    ResetReferences();
    references->SetId(cReferences);   
    
    dbgView= dbgView1= new InspectorView(this);
    dbgView2= new InspectorView(this);
    
    Layout(f);
    gSystem->AddTimeoutHandler(refresh= new RefreshHandler(win));
}

Inspector::~Inspector()
{
    gProgEnv->Closed(this);
    SafeDelete(dbgView1);
    SafeDelete(dbgView2);
    SafeDelete(findReferences);
    SafeDelete(classes);
    SafeDelete(objects);
    SafeDelete(references);
    SafeDelete(refTitle);
    SafeDelete(objTitle);
    SafeDelete(win);
}

void Inspector::Init(Object *op)
{
    win->OpenAt(Point(100,200));
    dbgView1->Init(op);
    dbgView2->Init(0);
}

void Inspector::Layout(WindowFlags f)
{
    VObject *scr= new Scroller(classes, Point(-1, 100));
    scr->SetFlag(eVObjHFixed);
    VObject *v= new Expander(eHor, gPoint2,
	    scr,
	    new Expander(eVert, gPoint2,
		new Clipper(objTitle, Point(0,-1)), 
		new Scroller(objects),
	    0),
	    new Expander(eVert, gPoint2, 
		new Clipper(refTitle, Point(0,-1)), 
		new Scroller(references),
	    0),
	0);
    v->SetFlag(eVObjVFixed);
    win= new Window(0, Point(900, 500), f+eWinCanClose,
	new Expander(eVert, gPoint2,
	    v,
	    new Expander(eHor, gPoint2,
		new Scroller(dbgView1),
		new Scroller(dbgView2),
	    0),
	0),
	"Inspector"
    );
}

void Inspector::UpdateList()
{
    Iter next(ClassIterator());
    int i= 0;
    Class *clp;
    
    ClassItems= new OrdCollection(200); 
    ObjectTableUpdateInstCount();
    while (clp= (Class*) next()) {
	if (!(hideEmptyClasses && clp->GetInstanceCount() == 0))
	    ClassItems->Add(new ClassItem(i++,clp,
		form("%s (%d)", clp->Name(), clp->GetInstanceCount())));
    }
    classes->SetCollection(ClassItems, TRUE);
    classes->Update();    
}

void Inspector::LoadObjectsOfClass(Class *cl, bool members)
{    
    ObjectItems= new ObjList;
    Object *op;
    
    gObjectTable->Start(cl, members);
    for (int i= 0; op= (*gObjectTable)(); i++) {
	ObjectItems->Add(new ObjectItem(i, op));
	if (i == cMaxObjects) {
	    VObject *vop= new TextItem("...", new Font(gFixedFont->Fid(), 
					    gFixedFont->Size(), eFaceItalic));
	    vop->Disable();
	    ObjectItems->Add(vop);
	    break;
	}
    }
    gObjectTable->End();
    if (i != 1)
	objTitle->SetFString(TRUE, "%d instances", i);
    else
	objTitle->SetFString(TRUE, "1 instance");
    objTitle->ForceRedraw();
    objects->SetCollection(ObjectItems, TRUE);
    objects->Update();    
}

void Inspector::Control(int id, int p, void *v)
{
    ObjectItem *oi;
    Rectangle r;

    switch (id) {
    case cObjects:
	r= objects->GetSelection();
	if (r.IsEmpty())
	    return;
	oi= (ObjectItem*) ObjectItems->At(r.origin.y);
	
	if (oi == 0 || !oi->IsKindOf(ObjectItem))
	    return;
	DoInspect(oi->GetObject());
	references->SetNoSelection();
	break;
    
    case cClasses:
	r= classes->GetSelection();
	if (r.IsEmpty())
	    return;
	ClassItem *ci= (ClassItem*) ClassItems->At(r.origin.y);
	if (ci == 0)
	    return; 
	LoadObjectsOfClass(ci->GetClass(), TRUE);
	references->SetNoSelection();
	break;
    
    case cReferences:
	r= references->GetSelection();
	if (r.IsEmpty())
	    return;
	oi= (ObjectItem*) ReferenceItems->At(r.origin.y);
	
	if (oi == 0 || !oi->IsKindOf(ObjectItem))
	    return;
	DoInspect(oi->GetObject());
    }    
    EvtHandler::Control(id, p, v);    
}

void Inspector::DoInspect(Object *op)
{
    if (!ObjectTablePtrIsValid(op))
	NoteAlert.Show("instance 0x%x disappeard", op);
    else if (strcmp(op->ClassName(), "InspectorItem") == 0) // hack
	NoteAlert.Show("would crash the inspector");    
    else
	op->Inspect(); 
}

void Inspector::ResetReferences()
{
    ReferenceItems= new OrdCollection(10);
    refTitle->SetString("References", TRUE);
    references->SetCollection(ReferenceItems, TRUE);
}

void Inspector::ResetObjects()
{
    objTitle->SetString("Number of instances", TRUE);
    ObjectItems= new ObjList(); 
    objects->SetCollection(ObjectItems, TRUE);
}

void Inspector::Reset()
{
    objects->SetNoSelection();
}

void Inspector::References(Object *op)
{
    ReferenceItems= new OrdCollection(10);
    refTitle->SetString(form("References to 0x%x (%s)", (int)op, op->ClassName()), TRUE);
    referencesTo= op;
    
    gObjectTable->Start();    
    while (currentOp= (*gObjectTable)()) {
	if (currentOp->IsA())
	    currentOp->IsA()->EnumerateMembers(findReferences); 
    } 
    gObjectTable->End();
    VObject *vop= new TextItem("---------", new Font(gFixedFont->Fid(), 
					    gFixedFont->Size(), eFaceItalic));
    vop->Disable();
    ReferenceItems->Add(vop);
    references->SetCollection(ReferenceItems, TRUE);
}

void Inspector::Member(int m, char *name, int offset, int s)
{
    extern bool ValidAddress(void*);
    Object **ov;
    
    switch (m) {
    case 1:
	Object *o= *(Object**)((unsigned long) currentOp + (unsigned long) offset);
	if (o == referencesTo && !currentOp->IsKindOf(ObjectItem))
	    ReferenceItems->Add(new ObjectItem(
			    form("%s.%s", currentOp->ClassName(), name), currentOp));
	break;
	
    case 2:        
	int *lp= (int*) ((unsigned long) currentOp + (unsigned long) s);
	if (!ValidAddress(lp))
	    return;
	s= *lp;
	// no break;
	
    case 3:
	ov= *(Object***)((unsigned long) currentOp + (unsigned long) offset);
	if (ov) {
	    for (int i= 0; i < s; i++) {
		if (ov[i] == referencesTo)
		    ReferenceItems->Add(new ObjectItem(
			form("%s.%s[%d]", currentOp->ClassName(), name, i), currentOp));
	    }    
	}
	break;
    }        
}

Command *Inspector::DoMenuCommand(int cmd)
{   
    switch (cmd) {
   
    case cSHOWALL:
	 ShowAllInstances();
	 return gNoChanges;
    
    case cUPDATELIST:
	 ResetObjects();
	 UpdateList();
	 return gNoChanges;
    
    case cEMPTYCLASSES:
	 hideEmptyClasses= !hideEmptyClasses;
	 ResetObjects();
	 UpdateList();
	 return gNoChanges;
	 
    }
    return EvtHandler::DoMenuCommand(cmd); 
}

void Inspector::ShowAllInstances()
{
    Rectangle r= classes->GetSelection();        
    ClassItem *ci= (ClassItem*) ClassItems->At(r.origin.y);
    if (ci != 0)
	LoadObjectsOfClass(ci->GetClass(), FALSE);
}
   
void Inspector::DoSetupMenu(Menu *menu)
{
    EvtHandler::DoSetupMenu(menu);
    Rectangle r, r1;
    char *current;
    
    r= classes->GetSelection();
    if (r.extent.y != 0)
	menu->EnableItem(cSHOWALL);

    if (hideEmptyClasses)
	current= "show empty classes";
    else
	current= "hide empty classes";
	
    menu->ReplaceItem(cEMPTYCLASSES, current);

    menu->EnableItems(cUPDATELIST, cEMPTYCLASSES, 0);
}

//---- ShowMembers --------------------------------------------------

void ShowMembers::Member(char *n, short of, int t)
{
    dbgView->SetInfo(n, t, of);
}

void ShowMembers::VectorMember(char *n, short of, short lenof, int t)
{
    dbgView->SetInfo(n, t, of, lenof);
}

void ShowMembers::ClassName(char *n)
{
    dbgView->SetInfo(n, supercnt == 0 ? cCLASS : cSUPER);
    supercnt++;
}

void ShowMembers::ConstVectorMember(char *n, short of, short size, int t)
{
    dbgView->SetInfo(n, t, of, size);
}

//---- ObjectItem -----------------------------------------------------

MetaImpl(ObjectItem, (I_O(op)));

ObjectItem::ObjectItem(int id, Object *o) : (id, 0, gFixedFont, Point(2,1))
{
    char buf[200];
    buf[0]= '\0';
    op= o;
    op->InspectorId(buf, sizeof(buf));
    if (strlen(buf))
	SetFString(FALSE, "0x%x <%s>", int(op), buf);
    else
	SetFString(FALSE, "0x%x", int(op));
}

ObjectItem::ObjectItem(int id, char *msg, Object *o) : (id, 0, gFixedFont, Point(2,1))
{
    op= o;
    SetString(msg);
}

ObjectItem::ObjectItem(char *iv, Object *o) : (cIdNone, 0, gFixedFont, Point(4,0))
{
    op= o;
    SetFString(FALSE, "%s 0x%x", iv, int(op));    
}

//---- FindReferences --------------------------------------------------------------

FindReferences::FindReferences(Inspector *b)
{ 
    ib= b; 
}

void FindReferences::Member(char *name, short offset, int type)
{
    if ((type > 0) && (type == (T_OBJECT+T_PTR)))
	ib->Member(1, name, offset);
}

void FindReferences::VectorMember(char *name, short offset, short offsetTolen, int type)
{
    if ((type > 0) && (type == (T_OBJECT+T_PTR+T_VEC))) 
	ib->Member(2, name, offset, offsetTolen);
}

void FindReferences::ConstVectorMember(char *name, short offset, short len, int type)
{
    if ((type > 0) && (type == (T_OBJECT+T_PTR+T_ARR)))
	ib->Member(3, name, offset, len);
}
