#ifndef EtProgEnv_First
#define EtProgEnv_First

#include "ProgEnv.h"

//---- EtProgEnv ------------------------------------------------------------
// entry points for the ET++ programming environment

class EtProgEnv : public ProgEnv {
    class BrowserDoc *browserDoc;
    class Window *hierarchy, *flatInheritance, *vobjTree, *collTable;
    class ClassTreeView *classTreeView;
    class FihView *fihView;
    class VObjTreeView *vobjTreeView;
    class CollTableView *colltableView;
    class Inspector *inspector;
public:
    
    EtProgEnv();
    ~EtProgEnv();
    
    //---- source code browser
    void EditSourceOf(class Class *cp, bool def);
    void EditSource(class Class *cp);
    void ShowInHierarchy(class Class *cp);
    void ShowInheritancePath(class Class *cp);
    
    void Closed(Object *);
    
    //---- inspector
    void InspectObject(class Object *op, bool block= FALSE);
    bool PartOfVObjectTree(Object *);
    char *HasAbstractView(Object *op);
    void ShowAbstractView(Object *op);
    void ShowCollTable(class Collection *col);
    void ShowVObjectTree(class VObject *vop);
};

extern ProgEnv *NewEtProgEnv();

#endif EtProgEnv_First
