#ifndef NeWSWindowPort_First
#define NeWSWindowPort_First

#include "../WindowPort.h"

class NeWSWindowPort: public WindowPort {
public:
    int psid, bcnt;
    FontPtr lbfont, lfont;
    byte bbuf[200];
    
public:

    NeWSWindowPort(InpHandlerFun, void*, void*, bool, bool);

    //---- window management
    void DevShow(WindowPort *father, Rectangle);
    void DevHide();
    void DevDestroy2();
    void DevSetRect(Rectangle*);
    void DevTop(bool);

    //---- clipping
    void DevClip(Rectangle, Point);
    void DevResetClip();
    
    //---- graphic
    void DevStrokeLine2(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point);
    void DevStrokeRect2(GrPattern, GrMode, int, Rectangle*);
    void DevFillRect(GrPattern, GrMode, Rectangle*);
    void DevStrokeRRect2(GrPattern, GrMode, int, Rectangle*, Point);
    void DevFillRRect2(GrPattern, GrMode, Rectangle*, Point);
    void DevStrokeOval2(GrPattern, GrMode, int, Rectangle*);
    void DevFillOval2(GrPattern, GrMode, Rectangle*);
    void DevStrokeWedge2(GrPattern, GrMode, int, GrLineCap, Rectangle*, int, int);
    void DevFillWedge2(GrPattern, GrMode, Rectangle*, int, int);
    void DevStrokePolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap);
    void DevFillPolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType);
    void DevShowBitmap(GrPattern, GrMode, Rectangle*, struct Bitmap*);
    bool DevShowChar(FontPtr fdp, Point pos, byte c, bool isnew, Point);
    void DevShowTextBatch(GrPattern, GrMode, Rectangle*, Point);

    //---- scrolling
    void DevScrollRect(Rectangle, Point);
	
    //---- input
    void DevFullscreen(bool);
    void DevGetEvent(Token *t, int timeout, bool);    
    void DevGrab(bool);
	
    //---- cursor
    void DevSetCursor(GrCursor);
    
    //---- mouse
    void DevSetMousePos(Point);
    void DevMoveMousePos(Point);
    
    //---- misc
    void DevBell(long);
    void DevGiveHint(int, int, void*);
};

#endif NeWSWindowPort_First
