//$FileDialog,PathSeparator,PathMenu$
#include "FileDialog.h"
#include "DialogItems.h"
#include "ScrollBar.h"
#include "CheapText.h"
#include "Alert.h"
#include "System.h"
#include "Window.h"
#include "CollectionView.h"
#include "OrdCollection.h"
#include "Application.h"
#include "Document.h"
#include "Scroller.h"
#include "Menu.h"

const int cIdName       =   cIdFirstUser + 0,
	  cIdList       =   cIdFirstUser + 1,
	  cIdUpdate     =   cIdFirstUser + 2,
	  cIdPath       =   cIdFirstUser + 3;
	  
const int cPathBuf      =   200,
	  cItemMinWidth =   250;

//---- PathSeparator -----------------------------------------------------------------

class PathSeparator : public TextItem {
public:
    MetaDef(PathSeparator);
    PathSeparator() : ("/", gSysFont, gPoint0)
	{ Disable(); }
    void Draw(Rectangle r);
};

MetaImpl0(PathSeparator);

void PathSeparator::Draw(Rectangle)
{
    if (text && *text) {
	Point p= contentRect.origin+border;
	p.y+= font->Ascender();
	GrShowString(font, ePatBlack, eRopCopy, p, text);
    }
}

//---- Path -----------------------------------------------------------------

Path::Path()
{
    path= 0;
    Reset();
}

Path::~Path()
{
    SafeDelete(path);
}

const char *Path::GetPath()
{
    return path;
}

void Path::Reset()
{
    strreplace(&path, gSystem->WorkingDirectory());
    p= path;
}

void Path::Start()
{
    p= path;
}

char *Path::operator()()
{  
    char buf[300];
     
    if (*p == 0) {
	p= path;
	return 0;
    }
    p++;
    char *c= buf;
    while (*p && *p != '/')
	*c++= *p++;
    *c= '\0';
    return strsave(buf);
}

int Path::Components()
{
    char *cp= path+1;
    int n= 1;
    if (*cp == 0)
	return n;
    while (*cp) 
	if (*cp++ == '/')
	    n++;
    return n+1;
}

char *Path::At(int at)
{
    char buf[1000];
    
    int i= 0;
    char *c= path+1, res= 0;
    
    for (; *c && i < at; c++)
	if (*c == '/')
	    i++;
    strncpy(buf, path, c - path);
    buf[c - path]= '\0';
    return strsave(buf);
}

char *Path::Last()
{
    char *p= rindex(path, '/');
    if (p == path && strlen(path) == 1)
	return strsave("/");
    return strsave(p+1);
}

//---- class PathMenu ---------------------------------------------------------

class PathMenu : public Menu {
public:
    MetaDef(PathMenu);
    PathMenu() : ("", FALSE, 1, 0, FALSE)
	{ SetFlag(eMenuNoScroll); }
    Point InitialPos();
};

MetaImpl0(PathMenu);

Point PathMenu::InitialPos()
{
    SetNoSelection(); // hack
    return ItemRect(0, 0).Center()+Point(0,1);
}

//---- FileDialog --------------------------------------------------------------

MetaImpl(FileDialog, (I_O(scroller), I_O(eti), I_O(title), I_CS(pathname),
				    I_I(flags), I_O(collview), I_O(mylist)));

FileDialog::FileDialog() : ("File Dialog", eBWinBlock)
{
    title= new TextItem("File Dialog");
    doc= 0;
    mylist= 0;
    doctype= 0;
    initDir= 0;
    pathname= new char[cPathBuf];
}

FileDialog::~FileDialog()
{
    SafeDelete(pathname);
    SafeDelete(doctype);
    SafeDelete(initDir);
}

int FileDialog::ShowInWindow(FileDialogFlags f, Clipper *fp, EvtHandler *eh)
{
    flags= f;
    doc= eh;
    char *p;
    if (f == eFDRead)
	p= "Open File Named:";
    else if (f == eFDWrite)
	p= "Save in File Named:";
    else
	p= "Import File Named:"; 
    title->SetString(p);
    // check whether working directory is still correct
    strreplace(&initDir, gSystem->WorkingDirectory());
    if (mylist && strcmp(initDir, path.GetPath()) != 0) {
	UpdateList();
	UpdateDir();
	UpdatePath();
	eti->SetString("");
    }
    return Dialog::ShowOnWindow(fp);
}

void FileDialog::UpdateList()
{
    Directory *dir= gSystem->MakeDirectory(".");
    char *name;
    int i;
    
    mylist= new OrdCollection;
    
    for (i= 0; name= (*dir)(); i++)
	if (strcmp(name, "."))
	    mylist->Add(new TextItem(i, name, gSysFont, Point(4,0)));
    
    mylist->Sort();

    if (collview == 0) {
	collview= new CollectionView(this, mylist, eCVDontStuckToBorder);
	collview->SetMinExtent(Point(cItemMinWidth, 0));
	collview->SetId(cIdList);
	collview->SetContainer(this);
    } else
	collview->SetCollection(mylist);
    SafeDelete(dir);
}

VObject *FileDialog::Hook(FileDialogFlags)
{
    return 0;
}

int FileDialog::GetSaveOption()
{
    return 0;
}

VObject *FileDialog::DoCreateDialog()
{
    pathMenu= new PathMenu();
    char *cp= path.Last();
    
    VObject *directory= 
	new Cluster(cIdNone, eVObjVBase, 5,
	    pathItem= new PopupItem(cIdPath, "Directory", pathMenu),
	    dir= new TextItem (cp),
	    0
	);
    SafeDelete(cp);

    UpdateList();
    
    scroller= new Scroller(collview, Point(cItemMinWidth, 16*8), cIdList);
    eti= new EditTextItem(cIdName, "", 300);
    
    VObject *update=
	new Cluster(cIdNone, eVObjHLeft, 20,
	    new ActionButton(cIdUpdate, "Update"),
	    Hook(eFDRead),
	    0
	);
	
    VObject *actions=
	new Cluster (cIdNone, eVObjVBase, 10, 
	    new ActionButton(cIdOk, "Ok", TRUE),
	    new ActionButton (cIdCancel, "Cancel"),
	    0
	);
    
    VObject *name=
	new Cluster(cIdNone, eVObjHLeft, 2,
	    title,
	    new BorderItem(eti),
	    0
	);

    UpdatePath();
    UpdateDir();

    // overall layout
    return
	new BorderItem(
	    new Cluster(cIdNone, eVObjHLeft, 20,
		new Cluster(cIdNone, eVObjHLeft, 10,
		    directory,
		    new Cluster(cIdNone, eVObjVTop, 20,
			scroller,
			update,
			0
		    ),
		    0
		),
		name,
		actions,
		0
	    ),
	    20, 0
	);
}

void FileDialog::DoSetup()
{
    bool e= eti->GetTextSize() > 0;
    EnableItem(cIdOk, e);
    pathItem->Enable(path.Components() > 1, TRUE);
}

Command *FileDialog::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    if (t.IsKey() || t.IsCursorKey()) {
	Command *cmd= scroller->Input(lp, t, vf);
	if (cmd)
	    return cmd;
    }
    return Dialog::DispatchEvents(lp, t, vf);
}

void FileDialog::Control(int id, int p, void *v)
{
    VObject *gop;
    Rectangle rr;
    char *cp;
    
    switch (id) {
    
    case cIdUpdate:
	UpdateList();
	return;
    
    case cIdList:
	switch (p) {
	case cPartCollSelect:
	    gop= (VObject*) collview->GetCollection()->At( (int) v );
	    char *fname= gop->AsString();
	    if (fname && strlen(fname) > 0) {
		eti->SetString(gop->AsString());
		eti->SetSelection();
		DoSetup();
	    }
	    break;
	case cPartCollDoubleSelect:
	    if (OpenOrChangeDir()) 
		Dialog::Control(cIdOk, cPartAction, v);
	    break;
	}
	return;
	
    case cIdName:
	if (p == cPartChangedText && v == eti)
	    DoSetup();
	break;
	
    case cIdOk:
	if (OpenOrChangeDir())
	    break;
	else return;
	
    case cIdCancel:
	gSystem->ChangeDirectory(initDir); 
	break;
    
    case cIdPath:
	rr= pathMenu->GetSelection();
	if (rr.extent != Point(0)) {
	    gop= pathMenu->GetItem(rr.origin.x, rr.origin.y);
	    cp= path.At(gop->GetId());
	    eti->SetString(cp);
	    eti->SetSelection();
	    SafeDelete(cp);
	    OpenOrChangeDir();
	}
	return;

    default:
	break;
    }
    Dialog::Control(id, p, v);
}

bool FileDialog::OpenOrChangeDir()
{
    Text *t;
    
    t= eti->GetText();
    t->CopyInStr(pathname, cPathBuf, 0, t->Size());

    if (gSystem->ExpandPathName(pathname, cPathBuf-1)) {
	NoteAlert.Show("%s (%s)", gSystem->GetErrorStr(), pathname);
	return FALSE;
    }
    SafeDelete(doctype);
    doctype= gSystem->GetFileType(pathname);
    if (ChangeDirectory())
	return FALSE;
    if (flags == eFDWrite) {
	if (NotWritable(pathname))
	    return FALSE;
    } else {
	if (NotReadable(pathname))
	    return FALSE;
	if (WrongType()) {
	    NoteAlert.Show("file @B%s@P has wrong type (%s)", pathname,
							  doctype->Type());
	    return FALSE;
	}
    }
    return TRUE;
}

bool FileDialog::NotReadable(char *name)
{
    if (gSystem->AccessPathName(name, 4)) {
	NoteAlert.Show("Can't open document @B%s@P for reading\n%s", name,
							gSystem->GetErrorStr());
	return TRUE;
    }
    return FALSE;
}

bool FileDialog::NotWritable(char *name)
{
    if (gSystem->AccessPathName(name, 0))
	return FALSE;
    if (CautionAlert.Show("file @B%s@P exists\noverwrite ?", name) != cIdYes)
	return TRUE;
    if (gSystem->AccessPathName(name, 2)) {
	NoteAlert.Show("Document @B%s@P is not writable\n%s", name,
							gSystem->GetErrorStr());
	return TRUE;
    }
    return FALSE;
}

bool FileDialog::WrongType()
{
    if (doc) {
	if (doc->IsKindOf(Document)) {
	    if (flags == eFDImport)
		return ! ((Document*)doc)->CanImportDocument(doctype);
	    if (((Document*)doc)->CanLoadDocument(doctype))
		return FALSE;
	}
	return ! gApplication->CanOpenDocument(doctype);
    }
    return TRUE;
}

bool FileDialog::ChangeDirectory()
{
    if (strcmp(doctype->Type(), cDocTypeDirectory) == 0) {
	if (!gSystem->ChangeDirectory(pathname)) 
	    NoteAlert.Show("Cannot change directory to @B%s@P", pathname);
	else {    
	    path.Reset();
	    UpdateDir();
	    UpdatePath();
	    UpdateList();
	    eti->SetString("");
	} 
	return TRUE;
    }
    return FALSE;
}

void FileDialog::UpdateDir()
{
    char *c= path.Last();
    dir->SetString(c, TRUE);
    SafeDelete(c);
    UpdateEvent(); // ??
}

void FileDialog::UpdatePath()
{
    Collection *col= new OrdCollection;
    char *c;
    
    int n= path.Components();
    col->Add(new TextItem(0, "/", new Font(gSysFont->Fid(),
					   gSysFont->Size(),
					   gSysFont->Face() | eFaceBold),
				  gPoint0));
    for (int i= 0; i < n-2; i++) {
	c= path();
	col->Add(new TextItem(i+1, c, gSysFont, gPoint0));
	col->Add(new PathSeparator());
	SafeDelete(c);
    }
    pathItem->Enable(path.Components() > 1, TRUE);
    pathMenu->SetCollection(col);
}
