#ifndef Document_First
#define Document_First

#include "EvtHandler.h"
#include "FileType.h"

enum FileDialogType {
    eFDTypeRead,
    eFDTypeWrite,
    eFDTypeImport
};

class Document : public EvtHandler {
    class Application *application;
    int changeCount, uniqueId;
    char *docName, *docType, *loadDir;
    Command *lastCmd;
    class Menu *menu;
    class ObjList *windows;
    bool isUntitled, isOpen, isConverted;
    class Icon *icon;

protected:
    class Window *window;

public:
    MetaDef(Document);

    Document(char *documentType= cDocTypeUndef);
    ~Document();

    //---- dialogs
    virtual class FileDialog *MakeFileDialog(FileDialogType); 

    //---- document attributes
    int UniqueId()
	{ return uniqueId; }
    char *GetDocumentType()
	{ return docType; }
    bool IsUntitled()
	{ return isUntitled; }
    char *GetName()
	{ return docName; }
    virtual void SetName(char *);

    //---- misc 
    bool Modified()
	{ return changeCount > 0; }
    virtual void DoMakeViews();
    virtual bool CanLoadDocument(class FileType *type);
    virtual bool CanImportDocument(class FileType *type);
	// when called with type= 0, returns whether any documents can be imported
    void Control(int id, int part, void *vp);
	
    void SetApplication(class Application *);
    EvtHandler *GetNextHandler();

    void InspectorId(char *buf, int bufSize);

    //---- windows
    virtual void AddWindow(class BlankWin*);
    virtual void OpenWindows();
    class Window *GetWindow()
	{ return window; }
    virtual class Window *DoMakeWindows();

    //---- icons
    virtual void Toggle();
    virtual Icon *DoMakeIcon(char *name);

    //---- menues
    void DoCreateMenu(class Menu *);
    void DoSetupMenu(class Menu *);
    Command *DoMenuCommand(int);
    void PerformCommand(Command*);
    class Menu *GetMenu();

    //---- generic menu commands
    virtual bool Open();
    virtual bool Close();
    virtual void Revert();
    virtual bool Save();
    virtual bool SaveAs();
    virtual Command *Import();
    virtual void Undo();

    //---- input/output
    virtual void Load(char *name, bool unique, class FileType *doctype);
    virtual void Store(char *name, int option);

    virtual void DoRead(istream &, FileType *);
    virtual class Command *DoImport(istream &, FileType *);
    virtual void DoWrite(ostream &, int option);
};

#endif Document_First

