//$NumItem,FloatItem,EditTextItem,RestrTextItem,Button,ButtonCommand$
//$ActionButton,OnOffItem,ImageButton,RadioButton,ToggleButton$
//$CycleItem,LabeledButton,EnumItem,OneOfCluster,ManyOfCluster$
//$BackgroundItem,PopupItem,LineItem$

#include "DialogItems.h"

#include "String.h"
#include "TextView.h"
#include "Dialog.h"
#include "CheapText.h"
#include "Alert.h"
#include "Menu.h"
#include "WindowSystem.h"
#include "RestrTextView.h"
#include "RegularExp.h"
#include "OrdCollection.h"
#include "BlankWin.h"
#include "Expander.h"

//---- EditTextItem ------------------------------------------------------------

MetaImpl(EditTextItem, (I_I(oldTextSize), I_B(freeView)));

EditTextItem::EditTextItem(int id, char* it, int w, int l) : (0, gPoint0, id)
{
    Init(new TextView((View*)0, gFitRect, new CheapText(it), eLeft), w, l, it);
    freeView= TRUE;
}

EditTextItem::EditTextItem(int id, TextView *t, int w, int l) : (0, gPoint0, id)
{
    Init(t, w, l, 0);
    freeView= FALSE;
}

EditTextItem::~EditTextItem()
{
    if (freeView) {
	Text *t= Tv()->GetText();
	SafeDelete(t);
	SafeDelete(vop);
    }    
}

void EditTextItem::Init(TextView *tv, int w, int l, char *it)
{
    Metric m= tv->GetMinSize();
    Point me;

    vop= tv;
    Tv()->AddDependent(this);
    Tv()->SetStopChars(l > 1 ? "\r" : "\r\n");
    Tv()->SetFlag(eTextNoFind);
    me.x= w ? w : ((it) ? m.Extent().x : 100);
    me.y= l*TextViewLineHeight(Tv()->GetText()->GetFont(), Tv()->GetSpacing());
    SetMinExtent(me+2*gBorder);
    SetNoSelection();    
    oldTextSize= GetTextSize(); 
}

int EditTextItem::Base()
{
    return vop->Base();
}

Metric EditTextItem::GetMinSize()
{
    return Metric(Clipper::GetMinSize().extent, Base());
}

void EditTextItem::StartInputFocus(bool start)
{
    if (!start) {
	SetNoSelection();
	if (!Validate()) {
	    UpdateEvent();
	    Token t= gToken;
	    t.Flags|= eFlgButDown;
	    GetWindow()->PushBackEvent(t);
	};
    }
}

bool EditTextItem::Validate()
{
    return TRUE;
}

void EditTextItem::SetView(View *vp)
{
    Clipper::SetView(vp);
    Tv()->SetNextHandler(vp);
    if (vp && vp->IsKindOf(DialogView))
	((DialogView*)vp)->AddTextItem(this);
}

Text *EditTextItem::SetText(Text *t)
{
    oldTextSize= GetTextSize();
    return Tv()->SetText(t);
}

void EditTextItem::SetString(byte *str, int len)
{
    Tv()->SetString(str, len);
    oldTextSize= GetTextSize();
    Tv()->RevealAlign(Rectangle(1,1));
    Changed();
}

Command *EditTextItem::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    if (t.Code == eEvtLeftButton && !(t.Flags & eFlgButDown))
	Control(GetId(), cPartActiveText, this);
    return Clipper::DispatchEvents(lp, t, vf);
}

void EditTextItem::DoUpdate(Object*, void* what)
{
    if ((int) what == eText && /* GetView() */ GetNextHandler()) {
	// notify only on >0 to 0 transition and vice versa
	int newTextSize= GetTextSize();
	if ((oldTextSize == 0 && newTextSize > 0) ||
					(oldTextSize > 0 && newTextSize == 0))
	    Control(GetId(), cPartChangedText, this);
	oldTextSize= newTextSize;
    }
}

void EditTextItem::DownControl(int id, int part, void *val)
{
    if (part == cPartValidate) {
	if (val) 
	    *(bool*)val= ! Validate();
    } else
	Clipper::DownControl(id, part, val);
}

//---- Button ------------------------------------------------------------------

MetaImpl0(Button);

Button::Button(int id, VObject *gop) : (id, gop, 0)
{
}

Command *Button::DoLeftButtonDownCommand(Point, Token, int)
{
    return new ButtonCommand(this, contentRect);
}

void Button::Flush(int msec)
{
    if (Enabled()) {
	Focus();
	Highlight(On);
	GraphicDelay(msec);
	Highlight(Off);
	ItemSelected();
    }
}

void Button::ItemSelected()
{
    Control(GetId(), cPartToggle, (void*) 1);
}

//---- ButtonCommand -----------------------------------------------------------

ButtonCommand::ButtonCommand(Button* bf, Rectangle r, bool b)
{
    item= bf;
    inside= TRUE;
    lastinside= FALSE;
    rect= r;
    SetFlag(eCmdIdleEvents, b);
}

void ButtonCommand::TrackFeedback(Point, Point, bool)
{
    if (inside != lastinside) {
	item->Highlight(inside ? On : Off);
	lastinside= inside;
    }
}

Command *ButtonCommand::TrackMouse(TrackPhase atp, Point, Point, Point np)
{
    inside= rect.ContainsPoint(np);
    switch(atp) {
    case eTrackPress:
	if (TestFlag(eCmdIdleEvents))
	    item->ItemSelected();
	break;        
    case eTrackIdle:
	if (lastinside && TestFlag(eCmdIdleEvents))
	    item->ItemSelected();
	break;
    case eTrackExit:
    case eTrackRelease:
	if (lastinside) {
	    item->Highlight(Off);
	    if (! TestFlag(eCmdIdleEvents))
		item->ItemSelected();
	}
	return gNoChanges;
    case eTrackMove:
	break;
    }
    return this;
}

//---- PopupItem ---------------------------------------------------------------

MetaImpl(PopupItem, I_O(menu));

PopupItem::PopupItem(int id, VObject *g, Menu *m) : (id, g)
{
    menu= m;
}

PopupItem::PopupItem(int id, char *t, Menu *m) : (id, new TextItem(t))
{
    menu= m;
}

PopupItem::~PopupItem()
{
    // SafeDelete(menu);
}

Metric PopupItem::GetMinSize()
{
    Metric m= Button::GetMinSize();
    m.extent+= gPoint4;
    m.base+= 1;
    return m;
}

void PopupItem::SetOrigin(Point at)
{
    VObject::SetOrigin(at);
    at.y++;
    at.x+= (Width()-2 - At(0)->Width())/2;
    At(0)->SetOrigin(at);
}

void PopupItem::SetExtent(Point e)
{
    VObject::SetExtent(e);
    At(0)->CalcExtent();
}

int PopupItem::Base()
{
    return At(0)->Base()+1;
}

void PopupItem::Highlight(HighlightState hst)
{
    Rectangle r(contentRect.origin+gPoint1, contentRect.extent-gPoint4);
    if (menu) {
	if (hst == On)
	    Control(GetId(), menu->Show(r.Center(), this), 0);
    } else
	GrInvertRect(r);
}

void PopupItem::DrawBackground(Rectangle)
{
    Rectangle rr= contentRect;
    rr.extent-= gPoint2;
    GrPaintRect(rr+gPoint2, ePatBlack);
    GrEraseRect(rr);
    GrSetPenNormal();
    if (!Enabled())
	GrSetPattern(ePatGrey50);
    GrStrokeRect(rr);
}

ostream& PopupItem::PrintOn(ostream &s)
{
    Button::PrintOn(s);
    return s << menu SP;
}

istream& PopupItem::ReadFrom(istream &s)
{
    Button::ReadFrom(s);
    return s >> menu;
}

//---- ImageButton -------------------------------------------------------------

MetaImpl(ImageButton, I_B(idleEvents));

ImageButton::ImageButton(int id, Bitmap *b1, Bitmap *b2, bool idle) : (id)
{
    bm1= b1;
    bm2= b2;
    idleEvents= idle;
}

ImageButton::~ImageButton()
{
}

Metric ImageButton::GetMinSize()
{
    return Metric(Max(bm1->Size(), bm2->Size()));
}

void ImageButton::Draw(Rectangle)
{
    GrPaintBitMap(contentRect, bm1, Enabled() ? ePatBlack : ePatGrey50);
}

void ImageButton::Highlight(HighlightState)
{
    GrInvertBitMap(contentRect, bm2);
}

Command *ImageButton::DoLeftButtonDownCommand(Point , Token, int)
{
    return new ButtonCommand(this, contentRect, idleEvents);
}

ostream& ImageButton::PrintOn(ostream &s)
{
    Button::PrintOn(s);
    return s << idleEvents SP << bm1 SP << bm2 SP;
}

istream& ImageButton::ReadFrom(istream &s)
{
    Button::ReadFrom(s);
    return s >> Bool(idleEvents) >> bm1 >> bm2;
}

//---- ActionButton ------------------------------------------------------------

MetaImpl0(ActionButton);

ActionButton::ActionButton(int id, VObject *g, bool dflt) : (id, g)
{
    SetFlag(eActionDefaultButton, dflt);
}

ActionButton::ActionButton(int id, char *t, bool dflt) : (id, new TextItem(t))
{
    SetFlag(eActionDefaultButton, dflt);
}

Metric ActionButton::GetMinSize()
{
    Metric m= Button::GetMinSize().Expand(Point(CalcBorder()));
    m.extent.x= max(m.extent.x, (m.extent.y*3)/2);
    return m;
}

void ActionButton::SetOrigin(Point at)
{
    VObject *inner= At(0);

    VObject::SetOrigin(at);
    at.y+= CalcBorder();
    at.x+= (Width() - inner->Width())/2;
    inner->SetOrigin(at);
}

void ActionButton::SetExtent(Point e)
{
    VObject::SetExtent(e);
    At(0)->CalcExtent();
}

int ActionButton::Base()
{
    return At(0)->Base()+CalcBorder();
}

void ActionButton::Highlight(HighlightState)
{
    GrInvertRoundRect(contentRect.Inset(CalcBorder()-gPoint2), 14);
}

void ActionButton::DrawBackground(Rectangle)
{
    GrSetPenNormal();
    if (! Enabled())
	GrSetPenPattern(ePatGrey50);
    GrStrokeRoundRect(contentRect.Inset(CalcBorder()-gPoint2), 14);

    if (TestFlag(eActionDefaultButton)) {
	GrSetPenSize(2);
	GrStrokeRoundRect(contentRect, 18);
    }
}

void ActionButton::Control(int id, int part, void *val)
{
    if (part == cPartToggle)
	part= cPartAction;
    Button::Control(id, part, val);
}

void ActionButton::SetView(View *vp)
{
    Button::SetView(vp);
    if (TestFlag(eActionDefaultButton) && vp->IsKindOf(DialogView))
	((DialogView*)vp)->SetDefaultButton(this);
}

//---- OnOffItem ---------------------------------------------------------------

AbstractMetaImpl(OnOffItem, I_B(state));

OnOffItem::OnOffItem(int id, Bitmap *b1, Bitmap *b2, Bitmap *b3, bool s) : (id)
{
    on= b1;
    off= b2;
    highlight= b3;
    state= s;
}

OnOffItem::~OnOffItem()
{
}

void OnOffItem::ItemSelected()
{
    DownControl(GetId(), cPartSetState, (void*) !state);
    Control(GetId(), cPartToggle, (void*) state);
    Changed();
}

Metric OnOffItem::GetMinSize()
{
    return Metric(gPoint16, 14);
}

int OnOffItem::Base()
{
    return (contentRect.extent.y/8)*7;
}

void OnOffItem::Draw(Rectangle)
{
    GrPaintBitMap(contentRect, state ? on : off, Enabled() ? ePatBlack : ePatGrey50);
}

void OnOffItem::Highlight(HighlightState)
{
    GrInvertBitMap(contentRect, highlight);
}

void OnOffItem::SetState(bool s, bool redraw)
{
    if (s != state) {
	state= s;
	Changed();
	if (redraw)
	    ForceRedraw();
    }
}

void OnOffItem::DownControl(int, int part, void *val)
{   
    switch (part) {
    case cPartSetState:
	SetState((bool) val);
	break;
    case cPartIncr:
	SetState(TRUE);
	break;
    case cPartDecr:
	SetState(FALSE);
	break;
    }
}

ostream& OnOffItem::PrintOn(ostream &s)
{
    Button::PrintOn(s);
    return s << state SP << on SP << off SP << highlight SP;
}

istream& OnOffItem::ReadFrom(istream &s)
{
    Button::ReadFrom(s);
    return s >> Bool(state) >> on >> off >> highlight;
}

//---- RadioButton -------------------------------------------------------------

static short RadioButtonOnBits[]= {
#   include "images/RadioButtonOn.image"
};

static short RadioButtonOffBits[]= {
#   include "images/RadioButtonOff.image"
};

static short RadioButtonFeedbackBits[]= {
#   include "images/RadioButtonFeedback.image"
};

static StaticBitmap RadioButtonOn(16, RadioButtonOnBits),
		    RadioButtonOff(16, RadioButtonOffBits),
		    RadioButtonFeedback(16, RadioButtonFeedbackBits);

MetaImpl0(RadioButton);

RadioButton::RadioButton(int id, bool state)
	: (id, &RadioButtonOn, &RadioButtonOff, &RadioButtonFeedback, state)
{
}

void RadioButton::InitNew()
{
    on= &RadioButtonOn;
    off= &RadioButtonOff;
    highlight= &RadioButtonFeedback;
}

ostream& RadioButton::PrintOn(ostream &s)
{
    Button::PrintOn(s);
    return s SP << state SP;
}

istream& RadioButton::ReadFrom(istream &s)
{
    Button::ReadFrom(s);
    return s >> Bool(state);
}

//---- ToggleButton ------------------------------------------------------------

static short CheckMarkOnBits[]= {
#   include "images/CheckmarkOn.image"
};

static short CheckMarkOffBits[]= {
#   include "images/CheckmarkOff.image"
};

static short CheckMarkFeedbackBits[]= {
#   include "images/CheckmarkInv.image"
};

static StaticBitmap CheckMarkOn(16, CheckMarkOnBits),
		    CheckMarkOff(16, CheckMarkOffBits),
		    CheckMarkFeedback(16, CheckMarkFeedbackBits);

MetaImpl0(ToggleButton);

ToggleButton::ToggleButton(int id, bool state)
		: (id, &CheckMarkOn, &CheckMarkOff, &CheckMarkFeedback, state)
{
}

void ToggleButton::InitNew()
{
    on= &CheckMarkOn;
    off= &CheckMarkOff;
    highlight= &CheckMarkFeedback;
}

ostream& ToggleButton::PrintOn(ostream &s)
{
    Button::PrintOn(s);
    return s << state SP;
}

istream& ToggleButton::ReadFrom(istream &s)
{
    Button::ReadFrom(s);
    return s >> Bool(state);
}

//---- NumItem -----------------------------------------------------------------

MetaImpl(NumItem, (I_I(minVal), I_I(maxVal), I_I(currVal), I_I(inc)));

NumItem::NumItem(int id, int val, int min, int max, int ndig, int increment) : 
	(id, new RestrTextView((View*)0, &gRexInt, gFitRect, new CheapText), 
						gSysFont->Width('0')*ndig)
{
    minVal= min;
    maxVal= max;
    inc= increment;
    SetValue(val, FALSE);
}

void NumItem::Incr()
{
    int newVal, oldVal= GetValue();

    if (oldVal+inc > maxVal)
	newVal= minVal;
    else
	newVal= oldVal+inc;
    SetValue(newVal);
}

void NumItem::Decr()
{
    int newVal, oldVal= GetValue();

    if (oldVal-inc < minVal)
	newVal= maxVal;
    else
	newVal= oldVal-inc;
    SetValue(newVal);
}

void NumItem::DownControl(int id, int part, void *val)
{
    switch (part) {
    case cPartIncr:
	Incr();
	break;
    case cPartDecr:
	Decr();
	break;
    default:
	EditTextItem::DownControl(id, part, val);
	return;
    }
}

int NumItem::GetValue()
{
    return GetText()->AsInt();
}

void NumItem::SetValue(int newVal, bool redraw)
{
    newVal= range(minVal, maxVal, newVal);
    if (newVal != GetValue()) {
	SetString(form("%d", newVal));
	if (redraw)
	    ForceRedraw();
    }
}

void NumItem::GetRange(int &min, int &max)
{
    min= minVal;
    max= maxVal;
}

void NumItem::SetRange(int min, int max)
{
    minVal= min;
    maxVal= max;
    SetValue(GetValue());
}

bool NumItem::Validate()
{
    int oldVal= GetValue();
    
    if (oldVal < minVal || oldVal > maxVal) {
	NoteAlert.Show("\"%d\" not in range %d-%d", oldVal, minVal, maxVal);
	SetValue(oldVal);
	return FALSE;
    }
    return TRUE;
}

ostream& NumItem::PrintOn(ostream &s)
{
    EditTextItem::PrintOn(s);
    return s << minVal SP << maxVal SP << currVal SP << inc SP;
}

istream& NumItem::ReadFrom(istream &s)
{
    EditTextItem::ReadFrom(s);
    return s >> minVal >> maxVal >> currVal >> inc;
}

//---- FloatItem ---------------------------------------------------------------

MetaImpl(FloatItem, (I_F(minVal), I_F(maxVal), I_F(currVal), I_F(inc)));

FloatItem::FloatItem(int id, float val, float min, float max, int nd, float i) : 
	(id, new RestrTextView((View*)0, &gRexDouble, gFitRect, new CheapText),
						       gSysFont->Width('0')*nd)
{
    minVal= min;
    maxVal= max;
    inc= i;
    SetValue(val, FALSE);
}

void FloatItem::Incr()
{
    float newVal, oldVal= GetValue();

    if (oldVal+inc > maxVal)
	newVal= minVal;
    else
	newVal= oldVal+inc;
    SetValue(newVal);
}

void FloatItem::Decr()
{
    float newVal, oldVal= GetValue();

    if (oldVal-inc < minVal)
	newVal= maxVal;
    else
	newVal= oldVal-inc;
    SetValue(newVal);
}

void FloatItem::DownControl(int id, int part, void *val)
{
    switch (part) {
    case cPartIncr:
	Incr();
	break;
    case cPartDecr:
	Decr();
	break;
    default:
	EditTextItem::DownControl(id, part, val);
	return;
    }
}

float FloatItem::GetValue()
{
    return GetText()->AsFloat();
}

void FloatItem::SetValue(float newVal, bool redraw)
{
    newVal= range(minVal, maxVal, newVal);
    if (newVal != GetValue()) {
	SetString(form("%g", newVal));
	if (redraw)
	    ForceRedraw();
    }
}

bool FloatItem::Validate()
{
    float oldVal= GetValue();
    
    if (oldVal < minVal || oldVal > maxVal) {
	NoteAlert.Show("\"%g\" not in range %g-%g", oldVal, minVal, maxVal);
	SetValue(oldVal);
	return FALSE;
    }
    return TRUE;
}

void FloatItem::GetRange(float &min, float &max)
{
    min= minVal;
    max= maxVal;
}

void FloatItem::SetRange(float min, float max)
{
    minVal= min;
    maxVal= max;
    SetValue(GetValue());
}

ostream& FloatItem::PrintOn(ostream &s)
{
    EditTextItem::PrintOn(s);
    return s << minVal SP << maxVal SP << currVal SP << inc SP;
}

istream& FloatItem::ReadFrom(istream &s)
{
    EditTextItem::ReadFrom(s);
    return s >> minVal >> maxVal >> currVal >> inc;
}

//---- RestrTextItem -----------------------------------------------------------

MetaImpl0(RestrTextItem);

RestrTextItem::RestrTextItem(int id, RegularExp *rex, char* initText, int width, int lines):
	(id, new RestrTextView(
			(View*)0, rex, gFitRect, new CheapText(initText)),
	 width,lines)
{
}

//---- CycleItem ---------------------------------------------------------------

MetaImpl(CycleItem, (I_S(current), I_I(align), I_B(mode)));

CycleItem::CycleItem(int id, VObjAlign a, Collection *cp) : (id, cp)
{
    Init(a);
}

CycleItem::CycleItem(int id, VObjAlign a, VObject*, ...) : (id, (Collection*)0)
{
    va_list ap;
    va_start(ap, a);
    SetItems(ap);
    Init(a);
    va_end(ap);
}

CycleItem::CycleItem(int id, VObjAlign a, va_list ap) : (id, ap)
{
    Init(a);
}

void CycleItem::Init(VObjAlign a)
{
    current= 0;
    align= a;
    mode= FALSE;
}

Metric CycleItem::GetMinSize()
{
    Metric m;

    if (mode)
	m= At(current)->GetMinSize();
    else {
	Iter next(list);
	VObject *dip;
	int w= 0, b1= 0, b= 0;

	while (dip= (VObject*) next()) {
	    m= dip->GetMinSize();
	    w= max(w, m.extent.x);
	    b= max(b, m.base);
	    b1= max(b1, m.extent.y-m.base);
	}
	m.extent.x= w;
	m.extent.y= b+b1;
	m.base= b;
    }
    return m;
}

void CycleItem::SetOrigin(Point at)
{
    VObject::SetOrigin(at);
    if (mode)
	At(current)->SetOrigin(at);
    else {
	Metric m(contentRect.extent);
	list->ForEach(VObject,Align)(at, m, align);
    }
}

void CycleItem::Draw(Rectangle r)
{
    At(current)->Draw(r);
}

Command *CycleItem::DispatchEvents(Point lp, Token t, Clipper *vf)
{
    return At(current)->DispatchEvents(lp, t, vf);
}

void CycleItem::DownControl(int, int part, void*)
{
    int old= current;

    switch (part) {
    case cPartIncr:
	if (++current >= Size())
	    current= 0;
	break;
    case cPartDecr:
	if (--current < 0)
	    current= Size()-1;
	break;
    }
    if (old != current) {
	if (mode)
	    Control(GetId(), cPartLayoutChanged, 0);
	else
	    ForceRedraw();
    }
}

ostream& CycleItem::PrintOn(ostream &s)
{
    CompositeVObject::PrintOn(s);
    return s << current SP << align SP << mode SP;
}

istream& CycleItem::ReadFrom(istream &s)
{
    CompositeVObject::ReadFrom(s);
    return s >> current >> Enum(align) >> Bool(mode);
}

//---- LabeledButton -----------------------------------------------------------

MetaImpl0(LabeledButton);

LabeledButton::LabeledButton(int id, OnOffItem *b, VObject *g, Point gap,
					VObjAlign a) : (id, a, gap, b, g, 0)
{
}

LabeledButton::LabeledButton(int id, char *t, bool w)
			  : (id,
			     eVObjVBase,
			     gPoint10,
			     w ? (VObject*) new RadioButton
			       : (VObject*) new ToggleButton,
			     new TextItem(t),
			     0)
{
}

Command *LabeledButton::DoLeftButtonDownCommand(Point, Token, int)
{
    if (At(0)->Enabled())
	return new ButtonCommand((Button*)At(0), contentRect);
    return gNoChanges;
}

void LabeledButton::Control(int, int part, void *val)
{
    Cluster::Control(GetId(), part, val);
}

//---- EnumItem ----------------------------------------------------------------

static short SliderUpBits[]= {
#   include "images/SliderButtonUp.image"
};

static short SliderDownBits[]= {
#   include "images/SliderButtonDown.image"
};

static short SliderUpInvBits[]= {
#   include "images/SliderButtonUpInv.image"
};

static short SliderDownInvBits[]= {
#   include "images/SliderButtonDownInv.image"
};

static StaticBitmap SliderUp(Point(13,10), SliderUpBits),
		    SliderDown(Point(13,10), SliderDownBits),
		    SliderUpInv(Point(13,10), SliderUpInvBits),
		    SliderDownInv(Point(13,10), SliderDownInvBits);

MetaImpl0(EnumItem);

EnumItem::EnumItem(int id, VObjAlign a, VObject *ci, Point gap)
	: (id, a, gap, ci,
	    new Expander(eVert, gPoint0, 
		new ImageButton(cIdUp, &SliderUp, &SliderUpInv, TRUE),
		new ImageButton(cIdDown, &SliderDown, &SliderDownInv, TRUE),
		0
	    ),
	/*
	    new Cluster(cIdNone, eVObjHCenter, 0,
		new ImageButton(cIdUp, &SliderUp, &SliderUpInv, TRUE),
		new ImageButton(cIdDown, &SliderDown, &SliderDownInv, TRUE),
		0),
		*/
		
	    0)
{
}

void EnumItem::Control(int id, int part, void *val)
{
    switch (id) {
    case cIdDown:
	At(0)->DownControl(0, cPartDecr, 0);
	UpdateEvent();
	break;
    case cIdUp:
	At(0)->DownControl(0, cPartIncr, 0);
	UpdateEvent();
	break;
    default:
	Cluster::Control(id, part, val);
	break;
    }
}

//---- OneOfCluster ------------------------------------------------------------

MetaImpl0(OneOfCluster);

OneOfCluster::OneOfCluster(int id, VObjAlign a, Point g, Collection *cp)
							    : (id, a, g, cp)
{
    Init(0);
}

OneOfCluster::OneOfCluster(int id, VObjAlign a, Point g, VObject*, ...)
						: (id, a, g, (Collection*)0)
{
    va_list ap;
    va_start(ap, g);
    SetItems(ap);
    Init(0);
    va_end(ap);
}

OneOfCluster::OneOfCluster(int id, VObjAlign a, Point g, char*, ...)
						: (id, a, g, (Collection*)0)
{
    char *t;
    va_list ap;
    va_start(ap, g);
    list= new OrdCollection;
    for (int i= 0; t= va_arg(ap, char*); i++)
	list->Add(new LabeledButton(id+i, t));
    Init(0);
    va_end(ap);
}

void OneOfCluster::Init(int n)
{
    if (n >= 0 && n < Size())
	Set(At(n)->GetId()); 
}

void OneOfCluster::Set(int id)
{
    if (Size() <= 0)
	return;
    Iter next(list);
    VObject *dip;

    // ForceRedraw();
    while (dip= (VObject*) next()) {
	int did= dip->GetId();
	dip->DownControl(did, cPartSetState, (void*) (did == id));
    }
}

void OneOfCluster::Control(int id, int part, void *v)
{
    if (part == cPartToggle) {
	Set(id);
	Cluster::Control(GetId(), id, v);
    }
}

//---- ManyOfCluster -----------------------------------------------------------

MetaImpl0(ManyOfCluster);

ManyOfCluster::ManyOfCluster(int id, VObjAlign a, Point g, Collection *cp)
						: (id, a, g, cp)
{
}

ManyOfCluster::ManyOfCluster(int id, VObjAlign a, Point g, VObject*, ...)
						: (id, a, g, (Collection*)0)
{
    va_list ap;
    va_start(ap, g);
    SetItems(ap);
    va_end(ap);
}

ManyOfCluster::ManyOfCluster(int id, VObjAlign a, Point g, char*, ...)
					       : (id, a, g, (Collection*)0)
{
    char *t;
    va_list ap;
    va_start(ap, g);
    list= new OrdCollection;
    for (int i= 0; t= va_arg(ap, char*); i++)
	list->Add(new LabeledButton(id+i, t, FALSE));
    va_end(ap);
}

void ManyOfCluster::Control(int id, int, void *v)
{
    Cluster::Control(GetId(), id, v);
}

//---- BackgroundItem ----------------------------------------------------------

MetaImpl(BackgroundItem, I_I(pattern));

BackgroundItem::BackgroundItem(GrPattern p, VObject *ip) : (cIdNone, ip, 0)
{
    pattern= p;
}

void BackgroundItem::DrawBackground(Rectangle r)
{
    GrPaintRect(r, pattern);
}

ostream& BackgroundItem::PrintOn(ostream &s)
{
    CompositeVObject::PrintOn(s);
    return s << pattern SP;
}

istream& BackgroundItem::ReadFrom(istream &s)
{
    CompositeVObject::ReadFrom(s);
    return s >> Enum(pattern);
}

//---- LineItem ----------------------------------------------------------------

MetaImpl0(LineItem);

LineItem::LineItem(bool d, int lw, int ml, int id) : (id)
{
    dir= d;
    lineWidth= lw;
    minLength= ml;
}

Metric LineItem::GetMinSize()
{
    if (dir)
	return Metric(minLength, lineWidth);
    return Metric(lineWidth, minLength);
}

void LineItem::Draw(Rectangle)
{
    GrPaintRect(contentRect, Enabled() ? ePatBlack : ePatGrey50);
}
