#ifndef ClipBoard_First
#define ClipBoard_First

#include "Object.h"

//---- clipboard types ---------------------------------------------------------

extern char *cClipUndef,        // "UNDEF"
	    *cClipPict,         // "PICT"
	    *cClipAscii,        // ascii
	    *cClipPostScript,   // PostScript
	    *cClipEt;           // ET++

class ClipBoard : public Root {
public:
    char *type;
    class View *view;   
    class membuf *mb;
    bool owner;

public:
    ClipBoard();
    ~ClipBoard();
    
    void SelectionToClipboard(class View*);
    class Command *PasteClipboard(class View*);
    void NotOwner();
    char *GetBuf(int *size);
    bool CanPaste(class View*);

    virtual membuf *MakeBuf();
    virtual void ScratchChanged();
};

extern ClipBoard *gClipBoard;

#endif ClipBoard_First


