//$ClipBoard$
#include "ClipBoard.h"
#include "View.h"
#include "membuf.h"

char *cClipUndef        = "UNDEF",
     *cClipPict         = "PICT",
     *cClipAscii        = "ASCII",
     *cClipPostScript   = "POSTSCRIPT",
     *cClipEt           = "ET++";

ClipBoard::ClipBoard()
{
    type= cClipEt;
    view= 0;
}

ClipBoard::~ClipBoard()
{
    SafeDelete(mb);
}

bool ClipBoard::CanPaste(class View *v)
{
    if (v == 0)
	return FALSE;
    view= v;
    // return view->CanPaste(type);
    return TRUE;
}

void ClipBoard::SelectionToClipboard(class View *v)
{
    extern bool gInPrintOn;
    
    if (v == 0)
	return;
    view= v;
    
    if (mb)
	delete mb;
    mb= new membuf;
    
    ostream os(mb);
    
    ClassReset();
    gInPrintOn= TRUE;
    view->SelectionToClipboard(cClipEt, os);
    os.flush();
    gInPrintOn= FALSE;
    ClassReset();
    owner= TRUE;
    
    ScratchChanged();
}

Command *ClipBoard::PasteClipboard(class View *v)
{   
    Command *cmd= gNoChanges;
    if (v) {
	if (! owner) {
	    // get clipboard from server
	    mb= MakeBuf();
	    owner= TRUE;
	}
	if (mb) {
	    istream is(mb);
	    ClassReset();
	    cmd= v->PasteData(type, is);
	    mb->Reset();
	    ClassReset();
	}
    }
    return cmd;
}

membuf *ClipBoard::MakeBuf()
{
    cerr << "no clipboard server\n";
    return 0;
}

void ClipBoard::NotOwner()
{
    owner= FALSE;
    SafeDelete(mb);
}

char *ClipBoard::GetBuf(int *size)
{
    if (mb) {
	*size= mb->size();
	return mb->Buf();
    }
    *size= 0;
    return 0;
}

static bool first= TRUE;

void ClipBoard::ScratchChanged()
{
    if (first) {
	cerr << "no clipboard server\n";
	first= FALSE;
    }
}
