#ifndef Class_First
#define Class_First

#include "Object.h"

extern class Class *classptr;
extern class ObjArray *classTable;

enum ClassFlags {
    eClassAbstract  =   BIT(eObjLast + 1),
    eClassLast      =   eObjLast + 1
};

#define MetaDef(name) \
name(class Class*);\
Class *IsA();\
friend Class *_NAME2_(name,ClassType)()\
    { return ((name*)0)->name::IsA(); } \
friend char *_NAME2_(name,DeclFileName)(char *p= __FILE__) \
    { return p; } \
friend char *_NAME2_(name,DeclCompDir)(char *p= __COMPILEDIR__) \
    { return p; } \
friend int _NAME2_(name,DeclFileLine)(int i= __LINE__) \
    { return i; } \
void Members() 

typedef int (Object::*OObjMemberFunc)(char*);

class Class: public Object {
    Class *super;
    char *className;
    int myId, size;
    class ObjArray *instanceTable;
    Object *proto;
    char *declFileName;
    int declFileLine;
    char *implFileName;
    int implFileLine;
    char *declCompDir;
    char *implCompDir;
    class OrdCollection* subclasses;
    int instanceCount;
private:
    void Reset();

public:
    MetaDef(Class);
    Class(char *name, int sz, Object *pro, char *in, char *dn, int il, 
			    int dl, char *icd, char *dcd, bool abstract= FALSE);
    ~Class();

    Class *Super()
	{ return super; }
    void SetSuper()
	{ super= classptr; classptr= this; }
    void AddSubclass(Class*);
    class Iterator *SubclassIterator();
    char *Name()
	{ return className; }
    int Size()
	{ return size; }
    Object *Proto()
	{ return proto; }
    Object *New();
    bool isKindOf(Class*);
    bool IsAbstract()
	{ return TestFlag(eClassAbstract); }
    void SavePtr(ostream&, Object*);
    void InvalidatePtr(Object*);
    int MakeIndex(ObjPtr p, bool *bp= 0);
    Object *LoadPtr(istream&);

    friend ostream& ClassSavePtr(ostream&, Object*);
    friend istream& ClassLoadPtr(istream&, Object*&);
    friend void ClassInvalidatePtr(Object*);
    friend void ClassPrintHierarchie();
    friend int ClassReset();
    friend Class *ClassFind(char *name);
    friend class Iterator *ClassIterator(bool sorted= TRUE);
    friend void ClassSetupSubclasses();
    friend void ClassSetDynLoadHook(Object *op, OObjMemberFunc of);
    friend void ClassInstanceStatistics();
    
    //---- comparing
    int Hash();
    bool IsEqual(Object*);
    int Compare(Object*);

    //---- converting
    char* AsString();

    void EnumerateMembers(class AccessMembers *accessor= 0);

    //---- source access
    const char *GetDeclFileName()
	{ return declFileName; }
    const char *GetImplFileName()
	{ return implFileName; }   
    int GetImplFileLine()
	{ return implFileLine; }
    int GetDeclFileLine()
	{ return declFileLine; }
    const char *GetDeclDir()
	{ return declCompDir; }
    const char *GetImplDir()
	{ return implCompDir; }

    //---- input/output
    ostream& DisplayOn(ostream &s);
    
    //---- misc
    void InspectorId(char *buf, int bufSize);

    //---- statistics
    void AddInstance();
    int  GetInstanceCount();
    void ResetInstanceCount();
};

//---- member access ---------------------------------------------------------

void D_A(char*, short, int);
void D_B(char*, short, short, int);
void D_C(char*);
void D_D(char*, short, short, int);

class AccessMembers {
public:
    virtual void ClassName(char *name);
    virtual void Member(char *name, short offset, int type);
    virtual void VectorMember(char *name, short offset, short offsetTolen, int type);
    virtual void ConstVectorMember(char *name, short offset, short len, int type);
};

//---- metaclass macros ----------------------------------------------------

#define _MetaImpl0(name,abstract) \
static Class _NAME2_(name,ClassMetaImpl0)("name", sizeof(name), \
new name((Class*)0), __FILE__,_NAME2_(name,DeclFileName)(), __LINE__, \
_NAME2_(name,DeclFileLine)(), __COMPILEDIR__, _NAME2_(name,DeclCompDir)(), abstract); \
name::name(class Class *cl):(cl)\
    { _NAME2_(name,ClassMetaImpl0).SetSuper(); }\
Class *name::IsA()\
    { return &_NAME2_(name,ClassMetaImpl0); }

#define MetaImpl0(name) \
_MetaImpl0(name,FALSE) \
void name::Members() { } 

#define MetaImpl(name,list) \
_MetaImpl0(name,FALSE) \
void name::Members() { list; }

#define AbstractMetaImpl0(name) \
_MetaImpl0(name,TRUE) \
void name::Members() { }

#define AbstractMetaImpl(name,list) \
_MetaImpl0(name,TRUE) \
void name::Members() { list; }

//---- type specifiers for metaclass macros ----------------------------------

extern int gDebug;

typedef unsigned long ulo;

#define T_CHAR      1
#define T_SHORT     2
#define T_INT       3
#define T_FLOAT     4
#define T_DOUBLE    5
#define T_OBJECT    6
#define T_BOOL      7
#define T_POINT     8
#define T_RECT      9
#define T_BITS     10
#define T_FONT     11

#define T_PTR       16
#define T_VEC       32
#define T_ARR       64
#define T_STR       128
#define T_STR2      256

#define _offset(in) ((short)((ulo)&in - (ulo)this))

#define I_SIMPLE(in,type) D_A("in", _offset(in), type)
#define I_VVECTOR(in,len,type) D_B("in", _offset(in), _offset(len), type+T_VEC)
#define I_CVECTOR(in,len,type) D_D("in", _offset(in), len, type+T_ARR)


#define I_C(in)         I_SIMPLE(in, T_CHAR)
#define I_S(in)         I_SIMPLE(in, T_SHORT)
#define I_I(in)         I_SIMPLE(in, T_INT)
#define I_F(in)         I_SIMPLE(in, T_FLOAT)
#define I_D(in)         I_SIMPLE(in, T_DOUBLE)
#define I_O(in)         I_SIMPLE(in, T_OBJECT+T_PTR)
#define I_B(in)         I_SIMPLE(in, T_BOOL)
#define I_P(in)         I_SIMPLE(in, T_POINT)
#define I_R(in)         I_SIMPLE(in, T_RECT)
#define I_X(in)         I_SIMPLE(in, T_BITS)
#define I_FT(in)        I_SIMPLE(in, T_FONT+T_PTR)
#define I_CS(in)        I_SIMPLE(in, T_CHAR+T_STR)
#define I_CSS(in)       I_SIMPLE(in, T_CHAR+T_STR+T_STR2)


#define I_CV(in,len)    I_VVECTOR(in, len, T_CHAR)
#define I_SV(in,len)    I_VVECTOR(in, len, T_SHORT)
#define I_IV(in,len)    I_VVECTOR(in, len, T_INT)
#define I_FV(in,len)    I_VVECTOR(in, len, T_FLOAT)
#define I_DV(in,len)    I_VVECTOR(in, len, T_DOUBLE)
#define I_OV(in,len)    I_VVECTOR(in, len, T_OBJECT+T_PTR)
#define I_BV(in,len)    I_VVECTOR(in, len, T_BOOL)
#define I_PV(in,len)    I_VVECTOR(in, len, T_POINT)
#define I_RV(in,len)    I_VVECTOR(in, len, T_RECT)
#define I_XV(in,len)    I_VVECTOR(in, len, T_BITS)
#define I_CSV(in,len)   I_VVECTOR(in, len, T_CHAR+T_STR)


#define I_CA(in,len)    I_CVECTOR(in, len, T_CHAR)
#define I_SA(in,len)    I_CVECTOR(in, len, T_SHORT)
#define I_IA(in,len)    I_CVECTOR(in, len, T_INT)
#define I_FA(in,len)    I_CVECTOR(in, len, T_FLOAT)
#define I_DA(in,len)    I_CVECTOR(in, len, T_DOUBLE)
#define I_OA(in,len)    I_CVECTOR(in, len, T_OBJECT+T_PTR)
#define I_BA(in,len)    I_CVECTOR(in, len, T_BOOL)
#define I_PA(in,len)    I_CVECTOR(in, len, T_POINT)
#define I_RA(in,len)    I_CVECTOR(in, len, T_RECT)
#define I_XA(in,len)    I_CVECTOR(in, len, T_BITS)
#define I_CSA(in,len)   I_CVECTOR(in, len, T_CHAR+T_STR)

#endif Class_First
