//$ByteArray$
#include "ByteArray.h"
#include "String.h"

char *cAtPutName= "AtPut";

MetaImpl(ByteArray, (I_CV(cont,cap), I_I(cap)));

ByteArray::ByteArray(byte *aStr, int l)                
{
    if (aStr && (l != 0)) {
	if (l < 0)
	    l= strlen(aStr)+1;
	cap= l;
	cont= NewBytes(l);
	bcopy(aStr, cont, l);
    } else {
	cap= 10;
	cont= NewBytes(cap);
    }
}

ByteArray::ByteArray(int size)                
{
    if (size <= 0)
	size= 10;
    cont= NewBytes(cap= size);
}

ByteArray::~ByteArray()               
{
    SafeDelete(cont);
}

void ByteArray::operator= (byte *s)
{
    strreplace(&cont, s);
    cap= strlen(s);
}

int ByteArray::Hash()
{
    register int hash;
    register byte *p;

    for (hash = 0, p = cont; *p; p++)
	hash = (hash << 1) ^ *p;
    return abs(hash);
}

bool ByteArray::IsEqual(ObjPtr b)
{
    return b->IsKindOf(ByteArray)
	    && strcmp (cont, ((ByteArray*)b)->cont) == 0;
}

int ByteArray::Compare(ObjPtr b)
{
    return strcmp(cont, Guard(b, ByteArray)->cont);
}

void ByteArray::SetString(byte *s)
{
   SafeDelete(cont);
   int l= strlen(s)+1;
   cap= l;
   cont= NewBytes(l);
   bcopy(s, cont, l);
}

ostream& ByteArray::PrintOn(ostream& s)
{
    Object::PrintOn(s);
    return PrintString(s, cont, cap);
}

istream& ByteArray::ReadFrom(istream& s)
{
    Object::ReadFrom(s);
    SafeDelete(cont);
    return ReadString(s, &cont, &cap);
}
