//$Application,ApplDialog,ApplIntHandler$
#include "Application.h"
#include "Document.h"
#include "Error.h"
#include "Storage.h"
#include "Menu.h"
#include "CmdNo.h"
#include "Window.h"
#include "Alert.h"
#include "ObjList.h"
#include "String.h"
#include "WindowSystem.h"
#include "FileDialog.h"
#include "DialogItems.h"
#include "ObjectTable.h"
#include <signal.h>

extern int getopt(int, char**, char*), optind;
extern char *optarg;

bool        gBatch= TRUE;
Application *gApplication= 0;
ClipBoard   *gClipBoard;
char        *gProgname;

static int  untitledCnt= 0;
static char *defaultOpts= "E:";
extern bool gAbort;

//---- ApplIntHandler --------------------------------------------------------------

class ApplIntHandler : public SysEvtHandler {
public:
    ApplIntHandler() : (SIGINT)
	{ }
    void Notify(SysEventCodes, int);
};

void ApplIntHandler::Notify(SysEventCodes, int)
{
    if (gApplication)
	gApplication->Inspect();
}

static void ApplErrorHandler(int level, bool, char *location, char *msg)
{
    gApplication->DoOnError(level, location, msg);
} 

//---- initial Application Dialog ----------------------------------------------

MetaImpl(ApplDialog, I_O(appl));

ApplDialog::ApplDialog(Application *eh, char *title= 0) : (title, eBWinDefault+eBWinFixed)
{   
    appl= eh; 
}

void ApplDialog::Control(int id, int part, void *vp)
{ 
    appl->Control(id, part, vp); 
}

VObject *ApplDialog::DoCreateDialog() 
{
    return new BorderItem(appl->DoCreateDialog(), Point(5)); 
}

Point ApplDialog::GetInitialPos()
{
    return gPoint0;
} 

//---- Application -------------------------------------------------------------

AbstractMetaImpl(Application, (I_CS(label), I_I(argc), I_O(documents), I_O(menu),
			I_O(applDialog), I_P(lastDocPos),
			I_B(printHierarchy), I_CS(version), I_CSV(argv, argc),
			I_CS(mainDocumentType), I_CS(opts),
			I_O(gWindow), I_R(gScreenRect),
			I_CSS(gEnviron), I_B(gDebug), I_B(gBatch), I_B(gAbort)));

Application::Application(int ac, char **av, char *dt, char *op)
{
    documents= 0;
    menu= 0;
    applDialog= 0;
    clipboard= 0;
    version= "Version 1.3, 10/27/88, \251IFI";

    if (gApplication)
	Error("Application", "only one Application !!");
    else {
	UpdateGlobals();
	ObjectTableAddRoot(this);
	SetErrorHandler(ApplErrorHandler);
	gProgname= label= av[0];
	printHierarchy= FALSE;
	lastDocPos= Point(150, 100);
	documents= new ObjList;
	applDialog= new ApplDialog(this, label);
	menu= new Menu(label);
	mainDocumentType= strsave(dt);
	argc= ac;
	argv= av;
	opts= op;
    }
}

Application::~Application()
{
    SetErrorHandler(DefaultErrorHandler);
    SafeDelete(documents);
    SafeDelete(applDialog);
    SafeDelete(menu);
}

EvtHandler *Application::GetNextHandler()
{
    return 0;
}

FileDialog *Application::MakeFileDialog()
{
    return new FileDialog;
}

void Application::ParseCommandLine(int argc, char **argv, char *opts)
{
    char optsbuf[100];
    int code;

    strcpy(optsbuf, defaultOpts);
    if (opts)
	strcat(optsbuf, opts);
    while ((code= getopt(argc, argv, optsbuf)) != EOF)
	DoParseOptions(code, optarg, optind);
    while (optind < argc)
	OpenDocument(argv[optind++]);
}

void Application::DoParseOptions(int c, char *arg, int)
{
    int x= lastDocPos.x, y= lastDocPos.y;
    
    if (c == 'E') {
	if (arg) {
	    switch(arg[0]) {
	    case 'a':   // dump core on ErrorExit
		::gAbort= !::gAbort;
		break;
	    case 'd':   // debug
		::gDebug= !::gDebug;
		break;
	    case 'b':   // double buffer
		::gBatch= !::gBatch;
		break;
	    case 'h':   // print hierarchie to cerr
		printHierarchy= !printHierarchy;
		break;
	    case 'm':
		::gMemStatistics= !::gMemStatistics;
		break;
	    case 'e':
		EditSource(TRUE);
		break;
	    case 'w':
		SetIgnoreLevel(0);
		break;
	    case 'i':
		Inspect();
		break;
	    case 'p':
		sscanf(&arg[1],"%d,%d", &x, &y);
		lastDocPos= Point(x,y);
		break;
	    default:
		break;
	    }
	}
    }
}

char *Application::ProgramName()
{
    char *p= rindex(gProgname, '/');
    if (p)
	return p+1;
    return gProgname;
}

Point Application::GetNewDocumentPos()
{
    Point p= lastDocPos;
    lastDocPos+= Point(40, 30);
    return p;
}

void Application::RemoveDocument(Document *dp)
{
    if (documents)
	documents->Remove(dp);
    gSystem->AddCleanupObject(dp);
}

Menu *Application::GetMenu()
{
    return menu;
}

void Application::About()
{
    SunAlert.Show("%s %s", label, version);
}

Command *Application::DoMenuCommand(int cmd)
{            
    switch(cmd) {

    case cNEW:
	NewDocument(mainDocumentType);
	break;

    case cQUIT:
	Quit();
	break;

    case cABOUT:
	About();
	break;

    case cSHOWAPPLWIN:
	ShowApplicationWindow();
	break;

    case cOPEN:
	Open();
	break;
	
    default:
	if (cmd >= cDEBUGFIRST && cmd <= cDEBUGLAST)
	    Debug(cmd-cDEBUGFIRST+1);
	else
	    return EvtHandler::DoMenuCommand(cmd);
    }
    return gNoChanges;
}

void Application::Quit()
{
    if (CloseAllDocuments())
	gSystem->ExitControl();
}

void Application::Debug(int)
{
    ::gDebug= ! ::gDebug;
    gDebug= ::gDebug;
}

void Application::Open()
{
    if (fileDialog == 0)
	fileDialog= MakeFileDialog();
    Window *w= (Window*) applDialog->GetWindow();
    if (fileDialog->ShowInWindow(eFDRead, w, this) == cIdOk)
	OpenDocument(fileDialog->FileName());
}

void Application::Control(int cmd, int, void*)
{
    DoMenuCommand(cmd);
}

void Application::AddDocument(Document *dp)
{
    documents->Add(dp);
    dp->SetApplication(this);
}

Document *Application::FindDocument(int id)
{
    Document *dp;
    Iter next(documents);

    while (dp= (Document*) next())
	if (dp->UniqueId() == id)
	    return dp;
    return 0;
}

Document *Application::DoMakeDocuments(char*)
{
    AbstractMethod("DoMakeDocuments");
    return 0;
}

bool Application::CloseAllDocuments()
{
    Document *dp;
    Iter next(documents);

    while (dp= (Document*) next()) // try to close all documents
	if (! dp->Close())
	    return FALSE;
    return TRUE;
}

void Application::OpenDocument(char *name)
{
    Document *dp;
    FType ft(name);

    if (!CanOpenDocument(ft.FileType())) {
	NoteAlert.Show("cannot handle document @I%s@P (%s)\n", name, ft.Type());
	return;
    }
    dp= DoMakeDocuments(ft.Type()); // let user make his documents
    if (dp) {
	AddDocument(dp);
	dp->OpenWindows();
	dp->Load(name, TRUE, ft.FileType());
    }
}

void Application::NewDocument(char *type)
{
    Document *dp;

    dp= DoMakeDocuments(type); // let user make his documents
    if (dp == 0) {
	Error("NewDocument", "DoMakeDocuments returns 0");
	return;
    }
    AddDocument(dp);
    dp->SetName(form("untitled.%d", untitledCnt++));
    dp->OpenWindows();
}

bool Application::CanOpenDocument(FileType *ft)
{
    if (strcmp(mainDocumentType, cDocTypeUndef) != 0) {
	bool ok= strcmp(ft->Type(), mainDocumentType) == 0;
	if (!ok)
	    if (strcmp(mainDocumentType, cDocTypeAscii) == 0 && ft->IsAscii())
		ok= TRUE;
	return ok;        
    }
    return TRUE;
}

void Application::Run()
{
    gSystem->AddSignalHandler(new ApplIntHandler);
    ClassSetDynLoadHook(this, &Application::DynLoad);

    ParseCommandLine(argc, argv, opts);
    if (printHierarchy)
	ClassPrintHierarchie();

    gClipBoard= clipboard= gWindowSystem->MakeClipboard();
    applDialog->ShowAt(0, GetNewDocumentPos());
    
    gSystem->Control();

    applDialog->Close();
}

int Application::DynLoad(char *name)
{
    extern void *Load(char *progname, char *name);
    
    Object *op= (Object*) Load(gProgname, name);
    if (op == 0) {
	Error("DynLoad", "cannot load class");
	return 0;
    }
    return DynLoadHook(op);
}

int Application::DynLoadHook(Object*)
{
    return 1;
}

VObject *Application::DoCreateDialog() 
{
    return
	new Cluster(1, eVObjVBase,
	    5,                      // gap between buttons
	    new ActionButton(cNEW,  "new"),
	    new ActionButton(cOPEN, "open"),
	    new ActionButton(cQUIT, "quit"),
	    0
	);
}

void Application::ShowApplicationWindow()
{
    applDialog->GetWindow()->Open();    
}

void Application::InspectorId(char *buf, int sz)
{
    strn0cpy(buf, label, sz);
}

void Application::UpdateGlobals()
{
    extern char **environ;
    
    gApplication= this;
    gWindow= ::gWindow;
    gDebug= ::gDebug;
    gBatch= ::gBatch;
    gAbort= ::gAbort;
    gScreenRect= ::gScreenRect;
    gEnviron= environ;
}

void Application::DoOnError(int level, char *location, char *msg)
{
    int ignorelevel= GetIgnoreLevel();
    static bool inError= FALSE;
    
    if (level < ignorelevel || inError)
	return;
    inError= TRUE;
    
    char *type= "Warning";
    if (level >= cFatal)
	type= "Fatal";
    else if (level >= cSysError)
	type= "SysError";
    else if (level >= cError)
	type= "Error";
    
    fprintf(stderr, "%s: %s in <%s>: %s\n", ProgramName(), type, location, msg);
    if (level >= cError) {
	switch (ErrorAlert.Show("%s: %s\nin @B%s@B: %s", ProgramName(), type, location, msg)) {
	case cIdIgnore:
	    break;
	    
	case cIdAbort:
	    Abort();
	    
	case cIdInspect:
	    Inspect();
	    break;
	    
	case cIdTrace:
	    StackTrace(0, FALSE);
	    break;
	}
    }
    inError= FALSE;
}

