#ifndef PolyShape_First
#define PolyShape_First

#include "LineShape.h"

//---- Polygons ----------------------------------------------------------------

class PolyShape : public Shape {
protected:
public:
    GrPolyType type;
    int npts;
    Point *pts;

public:
    MetaDef(PolyShape);
    
    PolyShape();
    ~PolyShape();
    
    void Open();
    bool AddPt(Point ps);
    void Close();
    
    short *GetImage();
    Point *GetPts()
	{ return pts; }
    int GetPtCnt()
	{ return npts; }
    void CalcBBox();
    void MovePoint(int, Point);
    void Draw(Rectangle, Point);
    void Outline(Point, Point);
    bool ContainsPoint(Point p);
    Point *MakeHandles(int *);
    ShapeSketcher *NewSketcher(DrawView*, SketchModes);
    ShapeStretcher *NewStretcher(DrawView*, int handle);
    void ScalePts(int, Point*, Point*, Point, Point);
    void SetProperty(ShapeProperties, int);
    int GetProperty(ShapeProperties);
    bool CanSplit();
    ostream& PrintOn(ostream&);    
    istream& ReadFrom(istream&);
    void MakePoints(int handle, Point delta, Point *p, int &n);
};

class PolySketcher: public ShapeSketcher {
    int maxpts;
    Point lp;
public:
    PolySketcher(DrawView *, Shape *, SketchModes, int);
    void TrackFeedback(Point, Point pp, bool turniton);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    PolyShape *Poly()
	{ return ((PolyShape*) newshape); }
};

class SplineStretcher: public ShapeStretcher {
    class PolyShape *lsp;
    int npts;
    Point pts[10];
public:
    SplineStretcher(DrawView*, Shape*, int);
    void DoIt();
    void UndoIt();
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackFeedback(Point, Point, bool);
    void TrackConstrain(Point, Point, Point*);
};

#endif PolyShape_First
