#include "Token.h"

const int cDoubleClick= 500;  // 0.5 sec

Token::Token(EventFlags f, Rectangle &r)    // constructor for damage events
{
    Code= eEvtDamage;
    Flags= f;
    Pos= r.origin;
    ext= r.extent;
}

Token::Token(EventCodes ec, EventFlags f, Point p)
{
    Code= ec;
    Flags= f;
    Pos= p;
}

bool Token::DoubleClick(Token &t)
{
    if (t.IsMouseButton())
	if (t.Code == Code && abs(t.Pos.x-Pos.x) < 2 && 
			abs(t.Pos.y-Pos.y) < 2 && abs(t.At-At) < cDoubleClick)
	    return TRUE;
    return FALSE;
}

char Token::MapToAscii()
{
    return (Code & 0x7f) + 0x60;
}

Point Token::CursorPoint()
{
    switch (CursorDir()) {
    case eCrsUp:
	return Point(0,-1);
    case eCrsDown:
	return Point(0,1);
    case eCrsLeft:
	return Point(-1,0);
    case eCrsRight:
	return Point(1,0);
    default:
	return gPoint0;
    }
}

