#ifndef TextCmd_First
#define TextCmd_First

#include "StyledText.h"
#include "TextView.h"

//---- CharSelector ------------------------------------------------------------

class CharSelector: public Command {
protected:
    class TextView *tv;
public:    
    CharSelector(TextView*);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackFeedback(Point, Point, bool);
};

//---- RangeSelector ------------------------------------------------------------

class RangeSelector: public CharSelector {
protected:
    int from, to;
    SelPoint startp, endp;
public:    
    RangeSelector(TextView*, Point);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackFeedback(Point, Point, bool);
    virtual void GetRange(int at, int *start, int *end);
};

//---- WordSelector ------------------------------------------------------------

class WordSelector: public RangeSelector {
public:    
    WordSelector(TextView *t, Point p): (t, p)
	{}
    void GetRange(int at, int *start, int *end);
};

//---- ParagraphSelector -----------------------------------------------

class ParagraphSelector: public RangeSelector {
public:    
    ParagraphSelector(TextView *t, Point p): (t, p)
	{}
    void GetRange(int at, int *start, int *end);
};

//---- QuickPasteSelector -----------------------------------------------

class QuickPasteSelector: public CharSelector {
    int from, to;
public:    
    QuickPasteSelector(TextView*, int, int);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

//---- CopyDragPasteSelector -------------------------------------------

class CopyDragPasteSelector: public Command {
    int from, to;
    TextView *tv;
public:    
    CopyDragPasteSelector(TextView*, int, int);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackFeedback(Point, Point, bool);
};

//---- TextCommands ----------------------------------------------------------

class TextCommand: public Command {
protected:
    class TextView *tv;
    class Text *oldText;
    int oldStart, oldEnd;
public:  
    MetaDef(TextCommand);      
    TextCommand(TextView*, int cmdNo, char *cmdName, bool saveOldtext= TRUE);
    ~TextCommand();
    void RestoreSelection();    
    void RedoIt();
};

class CutCopyCommand: public TextCommand {
public:    
    MetaDef(CutCopyCommand);      
    CutCopyCommand(TextView*, int cmdNo, char *cmdName= 0);
    void DoIt();
    void UndoIt();
};

class PasteCommand: public TextCommand {
protected:
    Text *pastetext;
    int newStart,newEnd;   
public: 
    MetaDef(PasteCommand);      
    PasteCommand(TextView*, Text*, int cmdNo= cPASTE, char *cmdName= 0);
    ~PasteCommand();
    void DoIt();
    void UndoIt();
};

class TypeingCommand: public TextCommand {
protected:
    Text *backspaceBuf;    // to store text backspaced over 
    Text *newText;
    int newStart;
public:
    bool completed;
    
    MetaDef(TypeingCommand);
    TypeingCommand(TextView *t, int cmdNo, char *cmdName);
    ~TypeingCommand();
    void UndoIt();
    void RedoIt();
    void Done(Command *newCmd);
    void AddChar(int n=1);
    void DelChar();
};

//---- class ChangeStyle -------------------------------

class ChangeStyleCommand: public TextCommand {
    RunArray *newStyles, *oldStyles;
    TextView *tvp;
    StChangeStyle mode;
    StyleSpec style;    
public:    
    MetaDef(ChangeStyleCommand);
    ChangeStyleCommand(TextView *t,int cmdNo,char *cmdName, StChangeStyle mode, 
		       StyleSpec newStyle);
    void DoIt();
    void UndoIt();
    void RedoIt();
};

#endif TextCmd_First     
