/*---- fontmgr ----------------------------------------------------------------*/

#include "sungr.h"
#include "sunfont.h" 
#include <pixrect/pixrect_hs.h>
#include <pixrect/memvar.h>

extern char *FontLib;

void sunfont_free(fdp)
FontPtr fdp;
{
    if (fdp->fd_notdef) {
	pr_destroy(fdp->fd_notdef);
	fdp->fd_notdef= 0;
    }
    if (fdp->fd_pf) {
	if (fdp->fd_name)
	    pf_close(fdp->fd_pf);
	else
	    _delete(fdp->fd_pf);
	fdp->fd_pf= 0;
    }
}

struct pixrect *ScaleGlyph(spr, sc)
struct pixrect *spr;
double sc;
{
    register int src, dst, x, y, sx, sy, scale;
    struct pixrect *pr, *pr1;
    
    x= spr->pr_size.x;
    y= spr->pr_size.y;

    sx= (int) ((double)x*sc);
    sy= (int) ((double)y*sc);
    
    pr= mem_create(sx, y, 1);
    pr1= mem_create(sx, sy, 1);
    if (sx < x) { 
	scale= x/sx;
	for (dst= 0; dst < sx; dst++)       /* x-shrink */
	    pr_rop(pr, dst, 0, 1, y, COPY|NCLIP, spr, dst*scale, 0);
	for (dst= 0; dst < sy; dst++)       /* y-shrink */
	    pr_rop(pr1, 0, dst, sx, 1, COPY|NCLIP, pr, 0, dst*scale);
    } else {            
	scale= sx/x;
	/* x-magnify */
	for (src= 0; src < x; src++)        /* slice */
	    pr_rop(pr, src*scale, 0, 1, y, COPY|NCLIP, spr, src, 0);
	for (src= 0; src < scale-1; src++)  /* smear */
	    pr_rop(pr, 1, 0, sx-1, y, OR|NCLIP, pr, 0, 0);
	/* y-magnify */
	for (src= 0; src < y; src++)        /* slice */
	    pr_rop(pr1, 0, src*scale, sx, 1, COPY|NCLIP, pr, 0, src);
	for (src= 0; src < scale-1; src++)  /* smear */
	    pr_rop(pr1, 0, 1, sx, sy-1, OR|NCLIP, pr1, 0, 0);
    }
    pr_destroy(pr);
    return pr1;
}

bool _SunFont_LoadFont(fdp)
register FontPtr fdp;
{
    static char pathname[100];
    register struct pixfont *pf;
    register int maxh= 0, maxb= 0, i, w, h, ht;
    struct pixchar pc, *pcp;
    
    if (fdp->fd_name == 0)
	return FALSE;
	
    sprintf(pathname, "./%s", fdp->fd_name);
    if ((pf= pf_open_private(pathname)) == NULL) {
	sprintf(pathname, "%s/fonts/%s", FontLib, fdp->fd_name);
	if ((pf= pf_open(pathname)) == NULL) {
	    Error("SunFont::LoadFont", "can't open font %s", pathname);
	    return TRUE;
	}
    }
    
    pc= pf->pf_char['0'];
    w= pc.pc_pr->pr_size.x;
    h= pc.pc_pr->pr_size.y;
    pc.pc_pr= mem_create(w, h, 1);
    pr_vector(pc.pc_pr, 1,   1,   w-2, 1,   OR, 1);
    pr_vector(pc.pc_pr, w-2, 1,   w-2, h-2, OR, 1);
    pr_vector(pc.pc_pr, w-2, h-2, 1,   h-2, OR, 1);
    pr_vector(pc.pc_pr, 1,   h-2, 1,   1,   OR, 1);
	
    for (i= 0; i < MAXCHAR; i++) {
	pcp= &pf->pf_char[i];
	if (pcp->pc_pr) {
	    ht= - pcp->pc_home.y;
	    maxh= max(maxh, ht);
	    maxb= max(maxb, pcp->pc_pr->pr_size.y - ht);
	} else 
	    *pcp= pc;
	fdp->fd_cw[i]= pcp->pc_adv.x;
    }
    fdp->fd_ht= maxh;
    fdp->fd_bs= maxb;
    fdp->fd_pf= pf;
    fdp->fd_ils= pf->pf_defaultsize.y;
    fdp->fd_notdef= pc.pc_pr;
    fdp->fd_loaded= TRUE;
    return FALSE;
}

FontPtr ConvertFont(fd, face, nfd, fixed)
register FontPtr fd, nfd;
int face;
BOOL fixed;
{
    struct pixfont *pf, *npf;
    register struct pixrect *notdef;
    struct pixchar *pc, *npc;
    register int i, adv, homex, homey;
    
    pf= fd->fd_pf;
    npf= (struct pixfont *) _new(sizeof(struct pixfont));
    *npf= *pf;  /* copy all */
    
    nfd->fd_pf= npf;
    nfd->fd_ht= fd->fd_ht;
    nfd->fd_bs= fd->fd_bs;
    nfd->fd_ils= fd->fd_ils;
    nfd->fd_name= 0;
    nfd->fd_notdef= notdef= fd->fd_notdef;
    nfd->fd_loaded= FALSE;
    
    pc= pf->pf_char;
    npc= npf->pf_char;
    for (i= 0; i < MAXCHAR; i++, pc++, npc++) {
	if (pc->pc_pr != notdef) {
	    adv= homex= homey= 0;
	    
	    switch (face) {
	    case eFaceBold:
		if (fixed)
		    adv= 0;
		else
		    adv= 1;
		break;
	    case eFaceItalic:
		if (fixed)
		    adv= 0;
		else
		    adv= 1;
		homex= -(fd->fd_bs/2);
		break;
	    case eFaceUnderline:
		break;
	    case eFaceOutline:
		adv= 2;
		homex= homey= -1;
		break;
	    case eFaceShadow:
		adv= 3;
		homex= homey= -1;
		break;
	    }
	    npc->pc_pr= 0;
	    npc->pc_adv.x+= adv;
	    npc->pc_home.x+= homex;
	    npc->pc_home.y+= homey;
	}
	nfd->fd_cw[i]= npc->pc_adv.x;
    }
    return nfd;
}

#define scale(x) ((int) ((double)(x)*s))

void _SunFont_ScaleFont(nfd, fd)
register FontPtr nfd, fd;
{
    struct pixfont *pf, *npf;
    register struct pixrect *notdef;
    struct pixchar *pc, *npc;
    register int i;
    double s= (double) nfd->fd_size / (double) fd->fd_size;
    
    pf= fd->fd_pf;
    npf= (struct pixfont *) _new(sizeof(struct pixfont));
    *npf= *pf;  /* copy all */

    nfd->fd_pf= npf;
    nfd->fd_ht= scale(fd->fd_ht);
    nfd->fd_bs= scale(fd->fd_bs);
    nfd->fd_ils= scale(fd->fd_ils);
    nfd->fd_name= 0;
    notdef= nfd->fd_notdef= ScaleGlyph(fd->fd_notdef, s);
    nfd->fd_loaded= TRUE;
    
    pc= pf->pf_char;
    npc= npf->pf_char;
    for (i= 0; i < MAXCHAR; i++, pc++, npc++) {
	if (pc->pc_pr != notdef) {
	    npc->pc_pr= ScaleGlyph(pc->pc_pr, s);
	    npc->pc_adv.x= scale(pc->pc_adv.x);
	    npc->pc_home.x= scale(pc->pc_home.x);
	    npc->pc_home.y= scale(pc->pc_home.y);
	}
	nfd->fd_cw[i]= npc->pc_adv.x;
    }
}

void _SunFont_MakeChar(nfd, fd, face, i, innerfd)
register FontPtr fd, nfd, innerfd;
byte i;
int face;
{
    register int w, h, x, y;
    struct pixfont *pf, *npf;
    struct pixrect *pr, *npr, *pr1;
    
    npf= nfd->fd_pf;
    if (npf->pf_char[i].pc_pr)
	return;
    
    pf= fd->fd_pf;
    pr= pf->pf_char[i].pc_pr;

    w= pr->pr_size.x;
    h= pr->pr_size.y;
    
    switch (face) {
    case eFaceBold:
	npr= mem_create(w+1, h, 1);
	pr_rop(npr, 0, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 1, 0, w, h, OR|NCLIP, pr, 0, 0);
	break;
	
    case eFaceItalic:
	npr= mem_create(w + fd->fd_ht/2, h, 1);
	for (y= 0, x= fd->fd_ht/2; y <= h; y+= 2, x--)
	    pr_rop(npr, x, y, w, 2, OR, pr, 0, y);
	break;
	
    case eFaceUnderline:
	w= max(w, fd->fd_cw[i]);
	y= -pf->pf_char[i].pc_home.y+1;
	npr= mem_create(w, h, 1);
	pr_rop(npr, 0, y, w, 1, SET|NCLIP, 0, 0, 0);
	pr_rop(npr, 0, y, w-1, 1, ERASE|NCLIP, pr, 1, y);
	pr_rop(npr, 1, y, w-1, 1, ERASE|NCLIP, pr, 0, y);
	pr_rop(npr, 0, 0, w, h, OR|NCLIP, pr, 0, 0);
	break;

    case eFaceOutline:
	npr= mem_create(w+2, h+2, 1);
	pr_rop(npr, 0, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 1, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 2, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 0, 1, w+2, h+1, OR|NCLIP, npr, 0, 0);
	pr_rop(npr, 0, 1, w+2, h+1, OR|NCLIP, npr, 0, 0);
	pr_rop(npr, 1, 1, w, h, ERASE|NCLIP, pr, 0, 0);
	break;
	
    case eFaceShadow:
	npr= mem_create(w+3, h+3, 1);
	pr_rop(npr, 0, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 1, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 2, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 3, 0, w, h, OR|NCLIP, pr, 0, 0);
	pr_rop(npr, 0, 1, w+3, h+2, OR|NCLIP, npr, 0, 0);
	pr_rop(npr, 0, 1, w+3, h+2, OR|NCLIP, npr, 0, 0);
	pr_rop(npr, 0, 1, w+3, h+2, OR|NCLIP, npr, 0, 0);
	pr1= innerfd->fd_pf->pf_char[i].pc_pr;
	pr_rop(npr, 1, 1, w, h, ERASE|NCLIP, pr1, 0, 0);
	break;
    }
    npf->pf_char[i].pc_pr= npr;
}

void _SunFont_GetLine(fd, bbp, c, y, bytes)
FontPtr fd;
byte c, *bbp;
int y, bytes;
{
    struct pixrect *pr= fd->fd_pf->pf_char[c].pc_pr;
    register byte *bp;
    register int i, x, lb= mpr_linebytes(pr->pr_size.x, 1);
    int h= pr->pr_size.y, realbytes= (pr->pr_size.x-1)/8+1;
    
    bp= (byte*) mpr_d(pr)->md_image;
    for (x= 0, i= y*lb; x < bytes; x++, i++) {
	if (x < realbytes && y >= 0 && y < h)
	    *bbp++= bp[i];
	else
	    *bbp++= 0;
    }
}

static int linenotempty(pr, y)
struct pixrect *pr;
int y;
{
    register int x, w= mpr_d(pr)->md_linebytes*8;
    
    for (x= 0; x < w; x++)
	if (pr_get(pr, x, y))
	    return 1;
    return 0;
}

bool _SunFont_PMetric(fd, c, w, hx, hy, sx, sy, starty, endy)
FontPtr fd;
byte c;
int *w, *hx, *hy, *sx, *sy, *starty, *endy;
{
    register struct pixchar *pc= &fd->fd_pf->pf_char[c];
    register int y;

    if (pc->pc_pr == 0)
	_Font_CheckChar(fd, c);
    if (pc->pc_pr == 0 || pc->pc_pr == fd->fd_notdef)
	return TRUE;
	
    *w= pc->pc_adv.x;
    *hx= pc->pc_home.x;
    *hy= -pc->pc_home.y;
    *sx= pc->pc_pr->pr_size.x;
    *sy= pc->pc_pr->pr_size.y;
    
    for (y=0; y <*sy; y++)
	if (linenotempty(pc->pc_pr, y))
	    break;
    *starty= y;
    *hy-= *starty;
    for (y= *sy-1; y >= 0; y--)
	if (linenotempty(pc->pc_pr, y))
	    break;
    *endy= y+1;
    *sy= *endy-*starty;
    return FALSE;
}
