//$SunOsPttyConnection$

#include "SunOsPttyConnection.h"
#include <sgtty.h>
#include <errno.h>
#include <signal.h>
#include <osfcn.h>

#include "sunptty.h"

/*
extern int write(int, char*, int);
extern int ioctl(int,int,void*);
extern int read(int, char*, int);
*/
//---- class SunOsPttyConnection ------------------------------------------

SunOsPttyConnection::SunOsPttyConnection(char *name, char **args)
{
    slave= sunPttySpawnSlave(name, args, &pid);
    slaveTtyName= sunPttyGetSlaveTtyName();
    ::sunPttyChars(&pttychars);
}

SunOsPttyConnection::~SunOsPttyConnection()
{
    SafeDelete(slaveTtyName);
    KillChild();
    fclose(slave);
}
    
int SunOsPttyConnection::GetFileNo()
{
    return fileno(slave);
}

FILE *SunOsPttyConnection::GetFile()
{
    return slave;
}

int SunOsPttyConnection::GetPid()
{
    return pid;
}
    
bool SunOsPttyConnection::SubmitToSlave(char *buf, int n)
{
    // SpawnSlave sets file to non blocking
    
    if (write(fileno(slave),buf,n) == -1) {
	if (errno == EWOULDBLOCK) {
	    ioctl (fileno(slave),TIOCFLUSH,0);
	    return (1);
	}
    }
    return 0;
}
    
int SunOsPttyConnection::Read(char *buf, int size)
{
    struct sgttyb tty;
    int n = read(fileno(slave),buf,size); 
    ioctl(fileno(slave),TIOCGETP,&tty);
    mode=tty.sg_flags;
    return n;
}

int SunOsPttyConnection::GetMode()
{
    return mode;
}
    
void SunOsPttyConnection::KillChild()
{
    ::sunPttyKillChild(SIGTERM, pid, slaveTtyName);
}

void SunOsPttyConnection::CleanupPtty()
{
    ::sunPttyCleanupPtty(slaveTtyName);
}

bool SunOsPttyConnection::Echo()
{
    return mode & ECHO;
}

bool SunOsPttyConnection::RawOrCBreak()
{
    return mode & (RAW | CBREAK);
}

void SunOsPttyConnection::BecomeConsole()
{
    ::sunPttyBecomeConsole(slaveTtyName);    
}

void SunOsPttyConnection::SetSize(int r,int c)
{
    ::sunPttySetSize(slaveTtyName, r, c);
}

void SunOsPttyConnection::GetPttyChars(PttyChars *pc)
{
    *pc= pttychars;
}
