//$SunFileType$

#include "SunFileType.h"

#include "../System.h"
#include "../String.h"

#include "sunsystem.h"


SunFileType::SunFileType(char *path): (path)
{
    statbuf= getstatbuf(path);
}

SunFileType::~SunFileType()
{
    SafeDelete(statbuf);
}

long SunFileType::SizeHint()
{
    if (!statbuf)
	return -1;
    return filesize(statbuf);
}

int SunFileType::UniqueId()
{
    if (!statbuf)
	return 0;
    return uniquefileid(statbuf);
}

bool SunFileType::IsExecutable()
{
    if (!statbuf)
	return FALSE;
    return isexecutable(statbuf) > 0;
}
    
bool SunFileType::SystemFileType()
{
    bool ret= FALSE;
    if (!statbuf)
	return FALSE;
    if (isspecial(statbuf)) {
	typename= strsave(cDocTypeSpecial);
	ret= TRUE;
    }
    else if (isdirectory(statbuf)) {
	typename= strsave(cDocTypeDirectory);
	ret= TRUE;
    }
    return ret;
}

