#include "InspectorItem.h"
#include "String.h"
#include "Alert.h"

extern bool ValidAddress(void*);

static char *typenames[16]= {
    0,
    "char",
    "short",
    "int",
    "float",
    "double",
    "Object",
    "bool",
    "Point",
    "Rectangle",
    "int",
    "Font"
};

//---- InspectorItem ---------------------------------------------------------------

MetaImpl0(InspectorItem);

InspectorItem::InspectorItem() : ("", gFixedFont, Point(2,1))
{
    name= 0;
    offset= 0;
    type= cNONE;
    lenoffset= 0;
}

InspectorItem::~InspectorItem()
{
    SafeDelete(name);
}

void InspectorItem::SetInfo(char *n, int t, short o, int len)
{
    if (n) {
	GrFace fc;
	
	strreplace(&name, n);
	
	switch (type= t) {
	case cSUPER:
	    fc= eFaceItalic;
	    break;
	case cUP:
	case cCLASS:
	    fc= eFaceBold;
	    break;
	default:
	    fc= eFacePlain;
	    break;
	}
	font= new Font(gFixedFont->Fid(), gFixedFont->Size(), fc);
    } else {
	SetString("");
	type= cNONE;
    }
    offset= o;
    lenoffset= len;
}

bool InspectorItem::CanDeref()
{
    switch (type) {
    case cUP:
    case cCLASS:
	return TRUE;
    default:
	if (type <= 0 || (type == T_FONT+T_PTR) || (type == T_CHAR+T_VEC))
	    return FALSE;
	if (type & (T_PTR | T_VEC | T_ARR | T_STR2))
	    return TRUE;
    }
}

void InspectorItem::Highlight(HighlightState hst)
{
    if (CanDeref())
	VObject::Highlight(hst);
}

int InspectorItem::Length(void *op, bool &ok)
{
    ok= TRUE;
    if (op && type > 0) {
	if (type & T_VEC) {
	    int *lp= (int*) ((unsigned long) op + (unsigned long) lenoffset);
	    ok= ValidAddress(lp);
	    if (ok)
		return *lp;
	    return 0;
	}
	if (type & T_ARR)
	    return lenoffset;
    }
    return 1;
}

Ref InspectorItem::Deref(void *op)
{
    bool ok;
    
    if (op == 0 || !CanDeref())
	return Ref();
	
    if (type == cCLASS) {
	Object *isa= ((Object*) op)->IsA();
	
	if (isa == 0)
	    NoteAlert.Show("no isa link");
	return Ref(isa);
    }
    void *oo= *((void**) (op+offset));
    if (oo == 0)
	NoteAlert.Show("instance variable \"%s\" is nil", name);
    else if (! ValidAddress(oo)) {
	NoteAlert.Show("instance variable \"%s\": illegal address", name);
	oo= 0;
    }
    return Ref(oo, type, Length(op, ok));
}

void InspectorItem::InitItem(void *op)
{
    void *addr= op;
    Object *oo;
    bool ok;
    int len, ll, t= 0;
    char buf[1000];
    char *types, *s, *bp= buf, *pre, *post;
    
    if (op == 0)
	return;
    
    switch (type) {
    case cNONE:
	SetString("");
	return;
    case cUP:
	SetString("..");
	return;
    case cCLASS:
	SetFString(FALSE, "%s: (0x%x)", name, op);
	return;
    case cSUPER:
	SetFString(FALSE, "%s:", name);
	return;
    default:
	if (type <= 0)
	    return;
	break;
    }
    
    types= typenames[type & 0x0f];
    if (types == 0)
	types= "???";
    
    if (type & (T_STR | T_PTR))
	pre= "*";
    else
	pre= " ";
	
    ok= TRUE;
    if (type & (T_VEC | T_ARR))
	post= form("[%d]", len= Length(op, ok));
    else if (type & T_STR2)   
	post= "[]";
    else
	post= "";
    
    if (!ok)
	post= "[<ill addr>]";
    
    sprintf(bp, "  %-9.9s %1s%-14.14s: ", types, pre, form("%s%s ", name, post));
    bp+= strlen(bp);
    
    addr+= offset;
    
    if (type & (T_PTR | T_STR | T_VEC)) {
	addr= *((void**) addr);
	if (addr == 0)
	    sprintf(bp, "<nil>");
	else if (!ValidAddress(addr))
	    sprintf(bp, "<illegal address>");
	else
	    t= type & ~T_PTR;
    } else
	t= type;
    
    switch (t) {
    case T_CHAR:
	sprintf(bp, "\'%c\'", *((char*) addr));
	break;
    case T_SHORT:
	sprintf(bp, "%d", *((short*) addr));
	break;
    case T_INT:
	sprintf(bp, "%d", *((int*) addr));
	break;
    case T_FLOAT:
	sprintf(bp, "%f", (double)(*((float*) addr)));
	break;
    case T_DOUBLE:
	sprintf(bp, "%f", *((double*) addr));
	break;
    case T_OBJECT:
	oo= (Object*) addr;
	sprintf(bp, "<%s> 0x%x", oo->ClassName(), oo);
	break;
    case T_BOOL:
	sprintf(bp, "%s", *((bool*) addr) ? "true" : "false");
	break;
    case T_POINT:
	sprintf(bp, "%s", ((Point*) addr)->AsString());
	break;
    case T_RECT:
	sprintf(bp, "%s", ((Rectangle*) addr)->AsString());
	break;
    case T_BITS:
	sprintf(bp, "0x%08x", *((int*)addr));
	break;
    case T_FONT:
	sprintf(bp, "%s", ((Font*)addr)->AsString());
	break;
    case T_CHAR+T_STR:
	len= strlen((char*) addr);
    case T_CHAR+T_VEC:
	s= (char*) addr;
	ll= min(len, 50);
	*bp++= '\"';  
	for (int j=0; j<ll; j++)
	    bp= strquotechar(*s++, bp);
	*bp++= '\"';
	if (len > ll) {
	    *bp++= '.'; *bp++= '.'; *bp++= '.';
	}
	*bp= '\0';
	break;
    default:
	break;        
    }
    SetString(buf);
}
