#ifndef Metric_First
#define Metric_First

#include "Point.h"


class Metric {
public:
    Point extent;
    short base;

public:
	Metric();
	
	Metric(Point e, short b);
	
	Metric(Point e);

	Metric(int w);

	Metric(int w, int h);
	    
	Metric(int w, int h, int b);

	/*
	Metric()
	    { extent.x= extent.y= base= 0; }
	
	Metric(Point e, short b)
	    { extent= e; base= b; }
	
	Metric(Point e)
	    { extent= e; base= extent.y; }

	Metric(int w)
	    { extent= Point(w); base= w; }

	Metric(int w, int h)
	    { extent= Point(w,h); base= h; }
	    
	Metric(int w, int h, int b)
	    { extent= Point(w,h); base= b; }
	*/
	
	Point Extent()
	    { return extent; }
	    
	int Width()
	    { return extent.x; }
	    
	int Height()
	    { return extent.y; }
	    
	int Base()
	    { return base; }
	    
	Metric Inset(Point);
	
	Metric Expand(Point);
	
	Metric Merge(Metric);
	
	operator Point()
	       { return extent; }
	
	friend Metric HCat(Metric, Metric, int hgap= 0);
	friend Metric VCat(Metric, Metric, int vgap= 0);

	
	friend bool operator== (Metric m1, Metric m2)
	    { return m1.extent == m2.extent && m1.base == m2.base; }

	friend bool operator!= (Metric m1, Metric m2)
	    { return m1.extent != m2.extent && m1.base != m2.base; }

	friend Metric Min (Metric, Metric);

	friend Metric Max (Metric, Metric);        
};


#endif Metric_First
