//$FileType$

#include "FileType.h"

#include "System.h"
#include "String.h"
#include "Error.h"

char *cMagic              =   "@!",
     *cDocTypeUndef       =   "UNDEF",
     *cDocTypeAscii       =   "ASCII",
     *cDocTypePict        =   "PICT",
     *cDocTypePostScript  =   "POSTSCRIPT",
     *cDocTypeDirectory   =   "SYSDIRECTORY", 
     *cDocTypeSpecial     =   "SYSSPECIAL",
     *cDocCreatorUndef    =   "__UNKNOWN__",
     *cDocSunRasterFile   =   "SUN_RASTERFILE";

const int SUN_RAS_MAGIC     =   0x59a66a95;

FileType::FileType(char *path)
{
    pathname= strsave(path);
    typename= creator= 0;
    isAscii= isETFormat= isSystem= FALSE;
}

FileType::~FileType()
{
    SafeDelete(typename);
    SafeDelete(pathname);
    SafeDelete(creator);
}

long FileType::SizeHint()
{
    return -1;
}

void FileType::WhatType()
{
    char fbuf[200], *bp, ch;
    filebuf infb;
    int l= strlen(cMagic);

    if (SystemFileType()) {
	isSystem= TRUE;
	return;
    }

    infb.open(pathname, input);
    istream from(&infb);
    for (bp= fbuf; bp < fbuf + sizeof(fbuf)-1; bp++) {
	if (!from.get(ch))
	    break;
	if (! isascii(ch)) {
	    isAscii= FALSE;
	    if (NotAsciiFileType())
		return;
	    typename= strsave(cDocTypeUndef);
	    return;
	}
	if (ch == '\n')
	    ch= '\0';
	*bp= ch;
    } 
    *bp= '\0';       
    isAscii= TRUE;
    typename= strsave(cDocTypeAscii);

    if (strncmp(fbuf, cMagic, l) == 0) { // ET++ file
	char bcreator[100], btype[100];
	int d= sscanf(fbuf,"@!%s %s", btype, bcreator);   
	if (d == 1)
	    strreplace(&creator, cDocCreatorUndef);
	else
	    strreplace(&creator, bcreator);                 
	isETFormat= TRUE;
	typename= strsave(btype);
	return;
    }

    if (strncmp(fbuf, "%!", 2) == 0) {
	typename= strsave(cDocTypePostScript);
	return;
    }
}

bool FileType::NotAsciiFileType()
{
    FILE *fp= fopen(PathName(), "r");
    int magic;
    
    fread((char*)&magic, sizeof(int), 1, fp);
    fclose(fp);   
    if (SUN_RAS_MAGIC == magic) {
	typename= strsave(cDocSunRasterFile);
	return TRUE;
    }    
    return FALSE;
}

char *FileType::Creator()
{
    return creator;
}

int FileType::UniqueId()
{
    AbstractMethod("FileType::UniqueId");
    return 0;
}

char *FileType::PathName()
{
    return pathname;
}

char *FileType::FileName()
{
    return PathName();
}

char *FileType::Type()
{
    if (!typename)
	WhatType();
    return typename;
}

bool FileType::IsCCode()
{
    if (!IsAscii())
	return FALSE;
	
    char *p;
    for (p= pathname+strlen(pathname)-1; p >= pathname && *p != '.'; p--)
	;
    p++;
    if (p < pathname || strlen(p) != 1)
	return FALSE;
    return (index("CcHh", *p)) != 0;
}

bool FileType::IsAscii()
{
    if (!typename)
	WhatType();
    return isAscii;
}

bool FileType::IsSystem()
{
    if (!typename)
	WhatType();
    return isSystem;
}

bool FileType::IsExecutable()
{
    if (!typename)
	WhatType();
    return FALSE;
}

bool FileType::IsETFormat()
{
    if (!typename)
	WhatType();
    return isETFormat;    
}
    
bool FileType::SystemFileType()
{
    return FALSE;
}

//---- class FType -------------------------------------------------------

FType::FType(char *p)
{
    ft= gSystem->GetFileType(p);
}
