#ifndef Error_First
#define Error_First

#include "Types.h"

const int cWarning  =   0,
	  cError    =   1000,
	  cSysError =   2000,
	  cFatal    =   3000;
	  
typedef void (*ErrorHandlerFunc)(int level, bool abort, char *location, char *msg);
 
extern void ErrorHandler(int level, char *location, va_list va);
extern void Error(char *location, char *msgfmt, ...);
extern void SysError(char *location, char *msgfmt, ...);
extern void Warning(char *location, char *msgfmt, ...);
extern void Fatal(char *location, char *msgfmt, ...);
extern void AbstractMethod(char*);

extern void DefaultErrorHandler(int level, bool abort, char *location, char *msg);

ErrorHandlerFunc SetErrorHandler(ErrorHandlerFunc newhandler);
ErrorHandlerFunc GetErrorHandler();
int SetAbortLevel(int newlevel);
int GetAbortLevel();
int SetIgnoreLevel(int newlevel);
int GetIgnoreLevel();

extern void _exit(int code);

#endif Error_First
