#ifndef Dialog_First
#define Dialog_First

#include "Clipper.h"
#include "TextView.h"
#include "CmdNo.h"

#include "BorderItems.h"

//---- EditTextItem ------------------------------------------------------------

class EditTextItem: public Clipper {
    int oldTextSize;
    bool freeView;
public:
    MetaDef(EditTextItem);
    
    EditTextItem(int id, class TextView *tv, int w= 0, int l= 1);
    EditTextItem(int id, char* initText= 0, int width= 0, int lines= 1);
    ~EditTextItem();
    
    class TextView *Tv()
	{ return (TextView*) vop; }
    void Init(TextView *tv, int width, int lines, char *it);
    Metric GetMinSize();
    int Base();
    void SetNoSelection()
	{ Tv()->SetNoSelection(); }
    void SetSelection(int from= 0, int to= cMaxInt, bool redraw = TRUE)
	{ Tv()->SetSelection(from, to, redraw); }
    class Text *GetText()
	{ return Tv()->GetText(); }
    int GetTextSize()
	{ return GetText()->Size(); }
    virtual bool Validate();
    void StartInputFocus(bool= TRUE);
    class Text *SetText(Text*);
    void SetString(byte *str, int len= -1);
    void SetView(View*);
    Command *DispatchEvents(Point, Token, Clipper*);
    void DoUpdate(Object*, void* what);
    void DownControl(int, int, void*);
};

//---- NumItem -----------------------------------------------------------------

class NumItem: public EditTextItem {
    int minVal, maxVal, currVal, inc;
public:
    MetaDef(NumItem);
    
    NumItem(int id, int val, int minval= -cMaxInt, int maxval= cMaxInt,
						     int ndigits= 4, int inc=1);
    void DownControl(int, int, void*);
    int GetValue();
    void SetValue(int, bool redraw= TRUE);
    void SetRange(int min, int max);
    void GetRange(int &min, int &max);
    void SetInc(int);
    int GetInc();
    void Incr();
    void Decr();
    bool Validate();
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
};

//---- FloatItem ---------------------------------------------------------------

class FloatItem: public EditTextItem {
    float minVal, maxVal, currVal, inc;
public:
    MetaDef(FloatItem);
    
    FloatItem(int id, float val, float minval, float maxval,
						    int ndigits= 5, float inc=1);
    void DownControl(int, int, void*);
    float GetValue();
    void SetValue(float, bool redraw= TRUE);
    void SetRange(float min, float max);
    void GetRange(float &min, float &max);
    void SetInc(float);
    float GetInc();
    void Incr();
    void Decr();
    bool Validate();
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
};

//---- RestrTextItem ----------------------------------------------------------

class RestrTextItem: public EditTextItem {
public:
    MetaDef(RestrTextItem);
    RestrTextItem(int id, class RegularExp *rex, char* initText= 0, int width= 0, 
								  int lines= 1);
};

//---- Button ------------------------------------------------------------------
  
class Button: public CompositeVObject {
public:
    MetaDef(Button);
    Button(int id= cIdNone, VObject *gop= 0);
    Command *DoLeftButtonDownCommand(Point, Token, int);
    virtual void Flush(int msec= 200);
    virtual void ItemSelected();
};

//---- ButtonCommand -----------------------------------------------------------

class ButtonCommand: public Command {
    Button *item;
    bool lastinside, inside;
    Rectangle rect;
public:
    ButtonCommand(Button*, Rectangle, bool b= FALSE);
    void TrackFeedback(Point, Point, bool);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

//---- PopupItem ---------------------------------------------------------------

class PopupItem: public Button {
    Menu *menu;
public:
    MetaDef(PopupItem);
    PopupItem(int id= cIdNone, VObject *g= 0, Menu *m= 0);
    PopupItem(int id, char *t, Menu *m= 0);
    ~PopupItem();
    Metric GetMinSize();
    int Base();
    void SetOrigin(Point at);
    void SetExtent(Point e);
    void Highlight(HighlightState hst);
    void DrawBackground(Rectangle r);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- ActionButton ------------------------------------------------------------

enum ActionButtonFlags {
    eActionDefaultButton  = BIT(eDiaNodeLast+1),
    eActionButtonLast     = eVObjLast+1
};

class ActionButton: public Button {
public:
    MetaDef(ActionButton);
    ActionButton(int id= cIdNone, VObject *g= 0, bool dflt= FALSE);
    ActionButton(int id, char *t, bool dflt= FALSE);
    
    int CalcBorder()
	{ return TestFlag(eActionDefaultButton) ? 6 : 2; }
    Metric GetMinSize();
    int Base();
    void SetOrigin(Point);
    void SetExtent(Point e);
    void Highlight(HighlightState);
    void DrawBackground(Rectangle);
    void Control(int, int, void*);
    void SetView(View *vp);
};

//---- ImageButton -------------------------------------------------------------

class ImageButton: public Button {
protected:
    bool idleEvents;
    Bitmap *bm1, *bm2;
public:
    MetaDef(ImageButton);
    ImageButton(int id= cIdNone, Bitmap *b1= 0, Bitmap *b2= 0, bool idle= FALSE);
    ~ImageButton();
    Metric GetMinSize();
    void Draw(Rectangle);
    void Highlight(HighlightState);
    Command *DoLeftButtonDownCommand(Point, Token, int);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- OnOffItem ---------------------------------------------------------------
  
class OnOffItem: public Button {
protected:
    Bitmap *on, *off, *highlight;
    bool state;
public:
    MetaDef(OnOffItem);
    OnOffItem(int id, Bitmap*, Bitmap*, Bitmap*, bool);
    ~OnOffItem();
    void SetState(bool, bool redraw= TRUE);
    bool GetValue()
	{ return state; }
    void ItemSelected();
    void DownControl(int, int, void*);
    Metric GetMinSize();
    int Base();
    void Draw(Rectangle);
    void Highlight(HighlightState);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- RadioButton -------------------------------------------------------------

class RadioButton: public OnOffItem {
public:
    MetaDef(RadioButton);
    RadioButton(int id= cIdNone, bool state = FALSE);
    void InitNew();
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- ToggleButton ------------------------------------------------------------

class ToggleButton: public OnOffItem {
public:
    MetaDef(ToggleButton);
    ToggleButton(int id= cIdNone, bool state = FALSE);
    void InitNew();
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- CycleItem ---------------------------------------------------------------

class CycleItem: public CompositeVObject {
    short current;
    VObjAlign align;
    bool mode;
public:
    MetaDef(CycleItem);
    CycleItem(int id= cIdNone, VObjAlign a= eVObjVBase, Collection *cp= 0);
    CycleItem(int id, VObjAlign a, VObject*, ...);
    CycleItem(int id, VObjAlign a, va_list ap);
    void Init(VObjAlign a);
    void SetOrigin(Point at);
    Metric GetMinSize();
    void Draw(Rectangle);
    Command *DispatchEvents(Point, Token, Clipper*);
    void DownControl(int id, int part, void *val);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- LabeledButton -----------------------------------------------------------

class LabeledButton: public Cluster {
public:
    MetaDef(LabeledButton);
    LabeledButton(int id= cIdNone, OnOffItem *b= 0, VObject *g= 0,
				Point gap= gPoint10, VObjAlign g= eVObjVBase);
    LabeledButton(int id, char *t, bool w= TRUE);
    Command *DoLeftButtonDownCommand(Point, Token, int);
    void Control(int, int, void*);
};

//---- EnumItem ----------------------------------------------------------------

class EnumItem: public Cluster {
public:
    MetaDef(EnumItem);
    EnumItem(int id= cIdNone, VObjAlign a= eVObjVBase, VObject *ci= 0, Point gap= gPoint10);
    void Control(int, int, void*);
};

//---- OneOfCluster ------------------------------------------------------------

class OneOfCluster: public Cluster {
public:
    MetaDef(OneOfCluster);
    OneOfCluster(int id= cIdNone, VObjAlign a= eVObjHLeft, Point g= gPoint0, Collection *cp= 0);
    OneOfCluster(int id, VObjAlign a, Point g, VObject*, ...);
    OneOfCluster(int id, VObjAlign a, Point g, char*, ...);
    void Init(int n= 0);
    void Set(int id);
    void Control(int id, int part, void *v);
};

//---- ManyOfCluster -----------------------------------------------------------

class ManyOfCluster: public Cluster {
    int bits;
public:
    MetaDef(ManyOfCluster);
    ManyOfCluster(int id= cIdNone, VObjAlign a= eVObjHLeft, Point g= gPoint0, Collection *cp= 0);
    ManyOfCluster(int id, VObjAlign a, Point g, VObject*, ...);
    ManyOfCluster(int id, VObjAlign a, Point g, char*, ...);
    void Control(int id, int part, void *v);
};

//---- BackgroundItem ----------------------------------------------------------

class BackgroundItem: public CompositeVObject {
    GrPattern pattern;
public:
    MetaDef(BackgroundItem);
    BackgroundItem(GrPattern p= ePatWhite, VObject *ip= 0);
    void DrawBackground(Rectangle r);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
};

//---- LineItem -----------------------------------------------------------------

class LineItem : public VObject {
    short lineWidth, minLength;
    bool dir;
public:
    MetaDef(LineItem);
    LineItem(bool d= TRUE, int lw= 1, int ml= 20, int id= cIdNone);
    Metric GetMinSize();
    void Draw(Rectangle);
};

#endif Dialog_First

