//$DialogView,Dialog$
#include "Dialog.h"
#include "DialogItems.h"
#include "OrdCollection.h"
#include "Menu.h"
#include "Error.h"
#include "CmdNo.h"
#include "Window.h"

//---- DialogView -------------------------------------------------------------

MetaImpl(DialogView, (I_O(dialogRoot), I_O(textItems),
	    I_O(activeText), I_O(defaultButton), I_B(modified), I_O(menu)));

DialogView::DialogView(EvtHandler *eh) : (eh, Point(3000))
{
    dialogRoot= 0;
    modified= TRUE;
    activeText= 0;
    textItems= 0;
    defaultButton= 0;
    menu= 0;
}

DialogView::~DialogView()
{
    if (dialogRoot) {
	dialogRoot->FreeAll();
	SafeDelete(dialogRoot);
    }
    SafeDelete(textItems);
}

void DialogView::Open(bool mode)
{
    View::Open(mode);
    if (mode)
	Update();
    if (dialogRoot)
	dialogRoot->Open(mode);
}

VObject *DialogView::DoCreateDialog()
{
    return 0;
}

Metric DialogView::GetMinSize()
{
    Update();
    CalcLayout(FALSE);
    return View::GetMinSize();
}

VObject *DialogView::SetDialog(VObject *dia, bool redraw)
{
    VObject *olddialog= 0;
    if (dia) {
	olddialog= dialogRoot;
	dialogRoot= dia;
	dialogRoot->SetContainer(this);
	dialogRoot->SetView(this);
	dialogRoot->Enable();
	CalcLayout(redraw);
    }
    return olddialog;
}

void DialogView::SetOrigin(Point at)
{
    View::SetOrigin(at);
    if (dialogRoot) 
	dialogRoot->SetOrigin(at);
}

void DialogView::CalcLayout(bool redraw)
{
    if (dialogRoot) {
	dialogRoot->CalcExtent();
	dialogRoot->SetOrigin(GetOrigin());
	SetExtent(dialogRoot->GetExtent());
	if (redraw)
	    ForceRedraw();
    }
}

void DialogView::Update()
{
    if (modified) {
	if (dialogRoot)
	    CalcLayout();
	else
	    SetDialog(DoCreateDialog(), FALSE);

	if (activeText) {
	    activeText->StartInputFocus();
	    activeText->SetSelection(0, cMaxInt, FALSE);
	}
	modified= FALSE;
    }    
}

void DialogView::Control(int id, int part, void *val)
{
    switch (part) {

    case cPartActiveText:
	if (activeText && (activeText != (EditTextItem*) val))
	    activeText->EndInputFocus();
	activeText= (EditTextItem*) val;
	activeText->StartInputFocus();
	break;

    case cPartLayoutChanged:
	CalcLayout();
	break;

    default:
	break;
    }
    View::Control(id, part, val);
}

Command *DialogView::DispatchEvents(Point lp, Token t, Clipper *vf)
{    
    if (t.IsKey()) {
	if (textItems && t.Code == '\t') {
	    DoTab(t);
	    return gNoChanges;
	}
	if (defaultButton && t.Code == '\r') {
	    defaultButton->Flush();
	    return gNoChanges;
	}
    }
    if ((t.IsCursorKey() || t.IsKey()) && activeText && activeText->Enabled())
	return activeText->DispatchEvents(lp, t, vf);

    if (dialogRoot)
	return dialogRoot->Input(lp, t, vf);
    return View::DispatchEvents(lp, t, vf);
}

//---- Menus --------------------------------------------------------------------

Menu *DialogView::GetMenu()
{
    if (GetNextHandler())
	return View::GetMenu();
    if (menu == 0)
	menu= new Menu("dialog");
    return menu;
}

bool DialogView::HasSelection()
{
    if (activeText)
	return activeText->Tv()->HasSelection();
    return View::HasSelection();
}

Command *DialogView::DoMenuCommand(int cmd)
{
    if (activeText) {
	EditTextItem *oldactive= activeText;
	activeText= 0;
	Command *rcmd= oldactive->DoMenuCommand(cmd);
	activeText= oldactive;
	return rcmd;
    }
    return View::DoMenuCommand(cmd);
}

void DialogView::AddTextItem (EditTextItem* t)
{
    if (textItems == 0)
	textItems= new OrdCollection();
    textItems->Add(t);
    if (activeText == 0)  // the first appended textitem becomes the active one
	activeText= t;             
}

void DialogView::SetDefaultButton (ActionButton *b)
{
    defaultButton= b;
}

void DialogView::DoTab(Token t)
{
    EditTextItem *ti, *at= 0;
    int cnt;

    if (!activeText) { // take the first enabled item
	Iter next(textItems);
	while (ti= (EditTextItem*)next())
	    if (ti->Enabled()) {
		at= ti;
		break;
	    }
    } else if (t.Flags & eFlgShiftKey) {
	for (ti= activeText, cnt= 0; cnt < textItems->Size(); cnt++) {
	    ti = (EditTextItem*) textItems->AtBefore(ti);
	    if (!ti) // wrap around
		ti = (EditTextItem*) textItems->Last();
	    if (ti->Enabled()) {
		at= ti;
		break;
	    }
	}
    } else {
	for (ti= activeText, cnt= 0; cnt < textItems->Size(); cnt++) {
	    ti = (EditTextItem*) textItems->AtAfter(ti);
	    if (!ti) // wrap around
		ti = (EditTextItem*) textItems->First();
	    if (ti->Enabled()){
		at= ti;
		break;
	    }
	}
    } 
    if (activeText)   
	activeText->EndInputFocus();
    activeText= at;
    if (activeText) {
	activeText->SetSelection();
	activeText->StartInputFocus();
    }
}

EditTextItem* DialogView::RemoveTextItem (EditTextItem* t)
{
    if (activeText == t)
	activeText= 0;
    return (EditTextItem*) textItems->Remove(t);
}

void DialogView::EnableItem (int id, bool b)
{
    VObject *gop;
    if (gop= FindItem(id))
	gop->Enable(b, TRUE);
}

VObject *DialogView::FindItem(int id)
{
    return dialogRoot->FindItem(id);
}

void DialogView::Draw(Rectangle r)
{
    if (dialogRoot)
	dialogRoot->DrawAll(r);
}

//---- Dialog -------------------------------------------------------------------

AbstractMetaImpl(Dialog, (I_O(dw), I_I(actionId)));

Dialog::Dialog(char *title, int f)
{
    if (f == 0)
	f= eBWinDefault;
    if (f & eBWinBlock)
	f|= eBWinFixed;
    if (title)
	dw= new Window(this, gPoint_1, f, this, title);
    else
	dw= new BlankWin(this, gPoint_1, f);
}

Dialog::~Dialog()
{   
    Object *op= dw;
    dw= 0;
    SafeDelete(op);
}

void Dialog::DoSetDefaults()
{
}

void Dialog::DoSave()
{
}

void Dialog::DoRestore() 
{
}

void Dialog::DoSetup() 
{
}

Point Dialog::GetInitialPos()
{
    if (GetDefaultButton())
	return GetDefaultButton()->contentRect.Center();
    return GetExtent()/2;
}

int Dialog::ShowAt(VObject *fp, Point p)
{
    bool b= IsModified() && !GetRoot();
    Update();
    if (b)
	DoSetDefaults();
    DoSave();
    DoSetup();
    dw->OpenAt(p - GetInitialPos(), fp);
    return actionId;
}

int Dialog::Show()
{
    return ShowAt(gWindow, gToken.Pos);
}

int Dialog::ShowOnWindow(VObject *fp)
{
    return ShowAt(fp, fp->GetExtent()/2);
}

void Dialog::Control(int id, int part, void *vp)
{
    bool veto;

    switch (id) {
    case cIdDefault:
	DoSetDefaults();
	DoSetup();
	break;
    case cIdCloseBox:
	dw->Close();
	break;
    default:
	if (part == cPartAction) {
	    DialogView::Control(id, part, vp);
	    if (id != cIdCancel) {
		veto= FALSE;
		GetRoot()->DownControl(0, cPartValidate, &veto);
		if (veto) 
		    return;
	    }
	    actionId= id;
	    dw->Close();
	    if (id == cIdCancel)
		DoRestore();
	    return;
	}
	break;
    }
    DialogView::Control(id, part, vp);
}

BlankWin *Dialog::GetWindow()
{ 
    return dw; 
}

void Dialog::Close()
{
    dw->Close();
}

void Dialog::InspectorId(char *buf, int sz)
{
    if (dw)
	dw->InspectorId(buf, sz);
    else
	DialogView::InspectorId(buf, sz); 
}
