#ifndef CollectionView_First
#define CollectionView_First

#include "View.h"

//---- CollectionView options --------------------------------------------------

enum CollViewOptions {
    eCVGrid             = BIT(eViewLast+1),
    eCVDontStuckToBorder= BIT(eViewLast+2),
    eCVClearSelection   = BIT(eViewLast+3),
    eCVInvertSelection  = BIT(eViewLast+4),
    eCVExpandRows       = BIT(eViewLast+5),
    eCVExpandCols       = BIT(eViewLast+6),
    eCVModified         = BIT(eViewLast+7),
    eCVDefault          = 0,
    eCVLast             = eViewLast + 7
};

//---- CollectionView ----------------------------------------------------------

class CollectionView: public View {
public:
    class Collection *matrix;
    Rectangle selection;
    Point gap, minExtent;
    short *xPos, *yPos, rows, cols;
    VObject *defaultItem;
    int clickCount;
    Menu *menu;

public:
    MetaDef(CollectionView);

    CollectionView(EvtHandler*, class Collection *, CollViewOptions o= eCVDefault,
							   int r= 0, int c= 1);
    ~CollectionView();
    class Collection *GetCollection()
	{ return matrix; }
    void Modified();
    void SetDefaultItem(class VObject *d);
    void SetCollection(class Collection*, bool freeold= TRUE);
    void SetMinExtent(Point);
    Metric GetMinSize();
    void SetOrigin(Point at);
    void SetGap(Point g)
	{ gap= g; }
    void Draw(Rectangle);
    void DoHighlightSelection(HighlightState);
    Command *DoLeftButtonDownCommand(Point, Token, int);
    Command *DoKeyCommand(int, Point, Token);
    void SetMenu(Menu *m)
	{ menu= m; }
    Menu *GetMenu()
	{ return menu; }
    void DoCreateMenu(Menu *);
    virtual void DoSelect(Rectangle);
    Rectangle GetSelection()
	{ return selection; }
    int SetSelection(Rectangle);
    void SetNoSelection()
	{ SetSelection(gRect0); }
    Point PointToItem(Point, bool *outside= 0);
    VObject *PointToItemPtr(Point, Point*);
    void DoUpdate(Object*, void*);
    void Update();
    Rectangle ItemRect(int, int);
    class VObject *GetItem(int x, int y);
    Point ItemPos(class VObject *);
    Rectangle ItemRect(Rectangle r);
    void InvalidateItemRect(Rectangle r)
	{ InvalidateRect(ItemRect(r)); }
    void ConstrainScroll(Point*);
    ostream& PrintOn (ostream&);
    bool PrintOnWhenDependent(Object *from);
    istream& ReadFrom(istream&);
    
    //---- inspecting
    void InspectorId(char *, int);

    virtual void DoOnItem(int, VObject*, Point);
};

//---- CellSelector ------------------------------------------------------------

class CellSelector: public Command {
protected:
    CollectionView *lvp;
    VObject *lastcell, *newcell;
public:
    CellSelector(CollectionView*);
    void TrackFeedback(Point, Point, bool);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

#endif CollectionView_First

