#ifndef BlankWin_First
#define BlankWin_First

#include "Clipper.h"

extern Token gToken;
extern bool gBatch;
extern bool gInUpdate;
extern class BlankWin *gWindow;


enum BWinFlags {
    eBWinOverlay=   BIT(eClipperLast+1),
    eBWinBlock  =   BIT(eClipperLast+2),
    eBWinActive =   BIT(eClipperLast+3),
    eBWinFixed  =   BIT(eClipperLast+4),
    eBWinDefault=   0,
    eBWinLast   =   eClipperLast+4
};


class BlankWin: public Clipper {
    class WindowPort *portDesc;     // Port descriptor
    EvtHandler *nexthandler;

    void input(void*, Token*);
    
public:
    MetaDef(BlankWin);
    
    BlankWin(Point minsize= gPoint0, BWinFlags f= eBWinDefault);
    BlankWin(VObject *vp= 0, Point minsize= gPoint0, BWinFlags f= eBWinDefault);
    BlankWin(EvtHandler *eh, VObject *vp= 0, Point minsize= gPoint0, BWinFlags f= eBWinDefault);
    ~BlankWin();
    
    void MakePort();
    VObject *GetContainer();
    EvtHandler *GetNextHandler();
    
    void Update();
    void SetOrigin(Point at);
    void SetExtent(Point e);
    void SetFocus(Rectangle, Point);
    void DrawAll(Rectangle);
    void DrawForeground(Rectangle);
    void DrawBackground(Rectangle);
    void InvalidateRect(Rectangle);
    void PushBackEvent(Token);
    void UpdateEvent(bool batch= gBatch);
    void Open(bool mode= TRUE);
    void OpenAt(Point p, VObject *vf= 0);
    Command *GetMover();
    Command *GetStretcher();
    Command *DoMiddleButtonDownCommand(Point, Token, int);
    Command *DoLeftButtonDownCommand(Point, Token, int);
    virtual void ActivateWindow(bool);
    Command *DispatchEvents(Point lp, Token t, Clipper *vf);

    PortDesc GetPortDesc()
	{ return (PortDesc)portDesc; }
    void SetPortDesc(PortDesc newport)
	{ portDesc= (class WindowPort*)newport; }
    Rectangle ScreenRect();
    Rectangle GetRect();
    Token ReadEvent(int timeout= -1, bool overread= TRUE);
    void Bell(long d= 100);
    void SetMousePos(Point);
    void Fullscreen(bool);
    void Grab(bool);
    void Top();
    void Bottom();
    void ScrollRect(Rectangle r, Point delta);

    //---- Menu related methods
    class Menu *GetMenu();
    void DoCreateMenu(class Menu *);
    void DoSetupMenu(class Menu *);
    Command *DoMenuCommand(int);
};

//---- BlankWindowStretcher ---------------------------------------------------------

class BlankWindowStretcher: public VObjectStretcher {
    Point ddd;
public:
    BlankWindowStretcher(BlankWin *w, Rectangle r);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackConstrain(Point ap, Point pp, Point *np);
};

#endif BlankWin_First

