#ifndef Bitmap_First
#define Bitmap_First

#include "Root.h"
#include "Rectangle.h"

typedef struct Bitmap *BitmapPtr;

class Bitmap : public Root {
protected:
    Point size;
    short *image;
    
    Bitmap();
    
public:
    Bitmap(Point sz, short *data);
    Bitmap(const char *filename);
    
    virtual ~Bitmap();

    virtual void Init(Point sz, short *data);
    Point Size()
	{ return size; }
    virtual void GetLine(byte*, int, int);
    int ShortsPerLine()
	{ return ((size.x-1)/16+1); }
    int BytesPerLine()
	{ return ((size.x-1)/8+1); }
    int Shorts()
	{ return ShortsPerLine() * size.y; }
    int Bytes()
	{ return Shorts() * 2; }
    short *GetImage()
	{ return image; }
    ostream& StoreOn(ostream&);
    friend ostream& operator<< (ostream &s, BitmapPtr &bp)
	{ return bp->StoreOn(s); }
    friend istream& operator>> (istream&, BitmapPtr&);
};

class StaticBitmap {
    Bitmap *bm;
public:
    StaticBitmap(Point sz, short *data)
	{ bm= new Bitmap(sz, data); }
    StaticBitmap(const char *filename)
	{ bm= new Bitmap(filename); }
    ~StaticBitmap()
	{ SafeDelete(bm); }
    Bitmap *operator& ()
	{ return bm; }
};

#endif Bitmap_First

