<include sgml.mac>
.so macros
.TL
ET++ \- Introduction
.AB
ET++ is a homogeneous object-oriented class library integrating user interface
building blocks, basic data structures, and support for object input/output
with high level application framework components. ET++ is implemented in C++
and runs under <tm UNIX> and either <tm SunWindows>, <tm NeWS>, or the X11 window
system.
.AE
.\"==============================================================================
.H 1 "Introduction"
This paper is intended for programmers who are familiar with the basics
of object-oriented programming and the C++ programming language. It should
provide enough information to start developing applications with ET++.
The paper is not intended to replace studying the ET++
example applications and their source code. Emphasis is put on the description
of conventions and mechanisms which are not immediately understood by
reading source.
.P
To learn about ET++ the following documents may be of help:
.IP 1.
Andr\(e' Weinand, Erich Gamma, Rudolf Marty (1989) Design and Implementation of
ET++, a Seamless Object-Oriented Application Framework, Structured Programming,
Vol. 10, No. 2, Springer Verlag (a copy of this paper is included in the
distribution).
.P
This is the most recent paper about ET++ and describes the basic architecture,
the imaging model and the built-in programming environment.
.IP 2.
Schmucker KJ (1986) Object Oriented Programming for the Macintosh. Hayden
Hasbrouck Heights, New Jersey.
.P
This book describes the MacApp application framework. The basic architecture of 
ET++ is close to MacApp and the concepts of Views, Documents and
Commands are similiar enough to get a basic understanding of the functionality
of these classes.
.IP 3.
Goldberg A, Smalltalk-80 (1983), The Language and its Implementation
Addison-Wesley, Reading, Mass.
.P
The ET++'s collection classes use the terminology of the Smalltalk-80 collection
classes.
.\"==============================================================================
.H 1 "Generic Behaviour of ET++ Based Applications"
This section describes the generic behaviour of ET++ based applications.
.\"------------------------------------------------------------------------------
.H 2 "The User Interface of ET++ applications"
The assignment of the mouse buttons is:
.TS
tab(!) box;
l l. 
<key LEFT>!selects an entry from a permanent menu,
!a button, or a range of text 
<key MIDDLE>!application specific
<key RIGHT>!displays a pop-up menu
.TE
.\"..............................................................................
.H 3 "Manipulating windows"
Commands to change the state of a window can be invoked while the cursor is in
the title bar or in the border surrounding a window. A mouse click with the
left mouse button moves a window on top of all the other windows. The middle
mouse button can be used to move a window on the screen desktop. The commands
displayed in the pop-up menu of a window are self explanatory. A window can be
resized with the little stretch icons in every corner. 
The boxes on the left and right of the title bar can be used to collapse a 
window to an icon.
.P
Most ET++ applications provide scrollbars to control the visible portion of a
document. Moving the thumb in the scrollbar updates the visible portion of the
window concurrently. Windows which can be subdivided into several panes showing
disconnected portions of a view have fence markers in their lower right
corner. They can be dragged with the left mouse button to adjust the size of
the different panes. A double click on these markers moves them back to their
initial position.
.P
Every ET++ application has an associated application window. This window is
used to create <cmd new>, to <cmd open> existing documents and to <cmd quit>
the application.  There is a button for each of the above operations.
Applications working with several documents types, 
typically add a button to create a new document for each type. The menu item
<cmd application window> of the file submenu displayed in the interior of a
window can be used to bring the application window on top whenever it is
obscured.
.\"..............................................................................
.H 3 "The Main Menu"
The standard pop-up menu displayed in the content area of a window contains the
generic editing commands <cmd cut>, <cmd copy>, <cmd paste> and in a pullright
menu the file and printing commands. To display a pullright menu move the mouse
a few pixels to the right while the item is selected. Menu items with a pull
right menu are marked with an arrow. The commands of the <cmd file> submenu
are:
.IP "<cmd load>"
replace the contents of a window with another document.
(the open button from the application window always creates a new window)
.IP "<cmd import>\ \ \ "
import the contents of another document or file
(only applications which can import anything include this command)
.IP "<cmd save>"
save the document
.IP "<cmd save as>"
save the document under a different name
.IP "<cmd revert>\ \ \ "
revert the document to the latest version stored on disk
.IP "<cmd print>"
command to choose a printer and define the print options.
.P
Every application is free to add additional pullright menus after the 
<cmd file> entry.
.\"..............................................................................
.H 3 "Dialog Boxes:"
ET++ applications use several styles of dialog boxes:
.IP Alerts:
for short confirmations and messages, alerts grab all input events and block
other applications from receiving input
.IP "Process-Modal Dialogs:"    
block all windows of one application. Input in windows of other
applications is still possible and the dialog window can be moved around. An
example is the file dialog described below. The windows of 
Process-Modal Dialogs do not have close boxes.
.IP "Modeless Dialogs:"
behave like ordinary windows.
.P
All dialogs provide a pop-up menu with the standard editing commands (<cmd
cut>, <cmd copy>, <cmd paste>). The <key TAB> key can be used to jump to each
text item from top to bottom in sequence. Some dialogs have a default button
marked with a double border; typing a carriage return has the same effect as
selecting it with the mouse.
.\"..............................................................................
.H 3 "File Dialog"
Whenever a filename has to be entered during a <cmd save>, <cmd load>, <cmd
open>, or <cmd import> command a file dialog box is displayed. This dialog box
displays a list of the files from the current directory. The filename can be
selected either from this scrollable list or entered directly into the text
field at the bottom.
.P
The file name entered in the text field may include shell meta characters.
A double click in the file list opens the document, if the name corresponds to
a file; if it is a directory the working directory will be changed accordingly.
<notice>
all ET++ applications displaying a list of items support to
scroll with the cursor keys or to type in a letter to jump to the first entry
starting with this letter while the cursor is over the list.
.P
The name of the current working directory together with a popup item labeled
<cmd Directory> is displayed above the list of files. Clicking on the pop-up
item displays a menu with the names of the parent directories. To change the
current working directory to a parent directory the corresponding item can be
selected.
.\"..............................................................................
.H 3 "Editing Text"
All ET++ applications provide the same user interface to manipulate text in
dialog boxes or text editors. The <key LEFT> mouse button is used to select a
range of text. A double click selects words and a tripple click lines or
paragraphs. A selection can be extended by clicking the left mouse button
while the <key SHIFT> key is depressed. The cursor keys can be used to
move the caret from the keyboard. Beside the common cut/copy/paste operations a quick paste and
a <key CTRL> click command are available. Quick paste can be used to copy some
text and insert it at the current position in one step. For a quick paste the
text has to be selected while the <key CTRL> and <key SHIFT> keys are
depressed. A <key CTRL> click (eg. a click while the <key CTRL> key is
depressed with the left mouse button) inserts the selected text at this
position.
.P
Some ET++ applications use a standard find/change dialog to search for a text
pattern. This pattern can be specified with a regular expression with the same
syntax as in GNU-Emacs. Refer to the file <etpath /doc/regex.doc> for a
description of their syntax.
.\"..............................................................................
.H 3 "Interrupting and Aborting Applications"
If an ET++ application performs a complex, lengthy task, you can interrupt the
calculation in SunWindows and X11 with the <key L1> function key on the SUN
keyboard. This brings up a modefull dialog giving you the name of the
interrupted operation and the choice of aborting or continuing.
.P
Whenever ET++ applications hang (e.g because of sending output to stdout or
stderr while in fullscreen mode) press the <key L1> function key on a sun
keyboard three times. This will exit your application without saving anything.
.P
<notice> pressing the interrupt key will bring up the inspector.
.\"..............................................................................
.H 3 "Printing"
Printing is initiated with the <cmd print>-entry of the main menu or with the
key combination <key META>-<key CTRL>-<key SHIFT>-<key p>. The former selects a
document's view for printing while the latter selects the current window for a
screen dump. In both cases a modefull dialog is opened for selecting a printing
device, and setting various printing options. The printing device is selected
by clicking on an item in the top left printer list. Currently only a <tm
PostScript> and a Pic device is supported. If the selected printer has options
available the <cmd option> button is enabled.
.IP "<cmd Apply>\ \ \ "
dismisses the print dialog and applies the selected options (e.g.  the paper
format) to the current view or the current window without printing anything.
.IP "<cmd Print>\ \ \ "
prints the view or window to the specified printing device.  Printing can be
aborted with the <key L1> function key.
.IP "<cmd Save as ...>"
opens a file dialog where you can specify a file for collecting the printing
output.
.P
The check box <cmd show pages> enables drawing page breaks. Currently page
breaks are displayed for each and every view of an application. This is
considered a bug not a feature.
.H 4 "PostScript options"
The options <cmd Resolution> and <cmd Orientation> are self-explanatory.
.IP "<cmd PS-prolog>"
If set, the <cmd PS-prolog> option includes the PostScript prolog <etpath
/postscript/ET.ps> in the output. Otherwise a non-standard PostScript
structuring comment "<code %%Include: ET>" is used.
.IP "<cmd smooth>"
The <cmd smooth> check box enables smoothing of bitmaps and bitmap fonts. This
option is only applicable if you are using a LaserWriter and your spooler
supports encrypted PostScript files (as our spooler does). Then the file <etpath
/postscript/smooth.ps> is downloaded to the printer to implement the
non-standard smooth command.
.P
.IP "<cmd Printer name>"
The editable text line <cmd Printer name> specifies the name of the printer used
with the <path lpr -P<name\>> command.
.\"..............................................................................
.H 3 "Command Line Arguments"
All ET++ based applications can be invoked with the following 
command line arguments:
.TS
tab(!) box;
lfB l.
-Eb!turn double buffering off
-Ei!start the inspector together with the application
-Ee!start the source code browser together with the application
-Em!gather and display memory statistics
-Epx,y!specify the position of the top left corner
!of the application window (micky -Ep400,500)
-Ew!enable warning messages
-Ed!set debugging mode
.TE
trailing command line arguments without a <quote -> prefix are interpreted as
the names of documents that should be loaded initially.
.\"------------------------------------------------------------------------------
.H 2 "The Built-in Programming Environment"
If the ET++ library has been configured to include the programming environment
all applications linked with this library have built-in an inspector and a
source code browser. The inspector is used to view the state of the objects of
a running application. There are several ways to invoke the ET++ inspector:
<item>
Hit the interrupt key in the window (control terminal) the application was
started from. The inspector initially shows the only instance of the
application object (including the global variables).
<item>
Invoke the application with the <bold \-Ei> option.
<item>
Execute a so called inspect-click over the object to be inspected. An inspect
click consists of a click with the left mouse button while the <key META/CTRL>
and <key SHIFT> keys are depressed. This method cannot only be used to start
the inspector but also to select any visible object for inspection. An
inspect-click is a convenient feature to explore the structure and objects of a
running application.
.P
The inspector window is subdivided into five panes. The top right pane displays
an alphabetically sorted list of all classes of the running application.
Together with the class name the number of instances of this class is displayed
in parenthesis. The menu provides the commands:
.IP "<cmd update>\ \ \ "
update the list of classes and the instance count
.IP "<cmd hide/show empty classes>" 
show or hide classes with no instances
.P
Clicking on a class name shows all its instances in the pane to the right. On
top of the top middle pane the current number of instances of this class is
indicated. The instances are identified by their hexadecimal address. Some
classes provide some additional identification for their objects, for example,
instances of the class <code Document> display the name of the document or
collections display their size and if there is one, the identification of the
first entry.  The menu of this subview consists of the entry <cmd all
instances>.  This command expands the list of instances with the indirect
members of the currently selected class, e.g. instances of its subclasses.
This feature is convenient when the exact class of an instance to be inspected
is not known. The desired instance can be found by clicking
on one of its superclasses followed by the menu selection <cmd all instances>.
Clicking on a member of a class displays the values of its instance variables
in the left of the bottom panes.
.P
Together with the values of the instance variables the name of the classes
where the variables are inherited from are shown. If an instance variable is a
pointer to another object the hexadecimal value together with the dynamic type
of the pointer is displayed. To dereference the pointer click on the instance
variable and the corresponding object is displayed in the bottom right pane of
the inspector. The <quote ..> mark on top of the instance variables panes
supports to go back to the previously
inspected object.
.P
From the inspector there is always instant access to the source code of the
inspected object. The menu items <cmd edit definition> or <cmd edit
implementation> from the menu displayed in the bottom panes pop-up the ET++
source code browser (see below) with the code of the definition or
implementation of the corresponding class. 
.P
The menu item <cmd references> fills the top right pane of the inspector with a
list of all other objects pointing to the currently viewed object. Clicking on
an item in this list shows the corresponding object in the bottom left pane.
This feature is particularly helpful to explore the relationships among the
objects of an application. In addition this function helps to find garbage
objects, e.g. objects that are not referenced by any other objects.
.P
The inspector provides special views for several data structures.  ET++ uses
trees of <code VObjects> for the layout of dialog items or the window
contents.  If a <code VObject> is inspected, which is part of such a <code
VObject> tree the menu item <cmd VObject Tree> is enabled. After selecting this
command the inspector displays the corresponding <code VObject> tree
graphically in a separate window. An object is selected for inspection in this
representation by clicking on the corresponding node in the tree. Try, for
example, an instance of the class <code Window> or <code Dialog>.  If the inspected
object is a <code Collection> the menu includes the item <cmd Collection
Table>. This command shows the contents of a collection in a tabular form in a
separate window and clicking on an object loads it into
the inspector.
.P
Notice that when an object follows the change propagation (<ref ET++
foundation>) protocols, the inspector will be updated automatically whenever
the state of the object is modified. Otherwise there is a menu item <cmd
update> to update the display of the inspector manually.
.\"..............................................................................
.H 3 "The Source Code Browser"
The source code browser displays on the left an alphabetically sorted list of
all the classes known in the running application. The class to be edited can be
selected from this list. On the left there is a full fledged editor where the
code is displayed and can be edited with the usual text editing operations as
in all ET++ applications. The editor uses the convention to display comments in
italic and the names of classes and the headers of methods or functions in a
bold face. It is possible to turn the usage of different faces off by defining
the environment variable <code ET_NO_STYLEDCODE>. This reduces the loading
time of large source files. To reformat the source code after some changes use
the <cmd reformat> menu item.
.P
If the class has been compiled with the modified version of the C++ driver
<path CC> distributed in the <etpath /C++> directory the full pathname of the source file
will be compiled into the binaries. Otherwise ET++ uses the following searching
order:
.IP 1. 
the current directory
.IP 2.
ET++'s source directory <etpath /src>
.IP 3.
any other directory as specified in the environment variable <code ET_SRC_PATH>.
.P
The editor gives some support for finding matching brackets,
a double click near a delimiter
<code (>, <code )>, <code ">, <code {>, <code }> sets the selection upto the
matching delimiter.
.P
The <cmd browse> submenu provides some additional options
to browse in the ET++ class hierarchy.
.IP "<cmd implementation/definition>"
a toggle to choose whether the definition or implementation of a class
should be edited
.IP "<cmd super class>"
edit the super class
.IP "<cmd class> <italic name of a class>"
edit the class in the current selection
.IP "<cmd spawn>\ \ \ "
spawn another instance of the source code browser
.IP "<cmd show in hierarchy>"
pops-up a window with a tree view of the class hierarchy and reveals 
the position of the currently edited class.
.IP "<cmd show inheritance path>" 
displays in the so called <italic flat inheritance view> all classes in a
sorted table together with a list of their superclasses.
.IP "<cmd go back>"
switch back to the previously edited class
.IP "<cmd goto line>"
select and reveal the line number entered in a dialog box
.P
The class to be edited can not only be selected from the alphabetical list in
the source code browser but form the tree and flat inheritance view as well.
Subtrees of the class tree view can be selectively collapsed or expanded with
the middle mouse button. Collapsed subtrees are marked with a round border. A
subtree can be promoted with a click of the middle button together with the
<key SHIFT> key. The same click on the root node brings back the full tree.
Class names displayed in an italic face indicate abstract classes.
.\"==============================================================================
.H 1 "Implementing an ET++ Application"
.\"------------------------------------------------------------------------------
.H 2 "Coding Conventions"
This section describes the coding conventions or idioms
used for developing applications with ET++.
.\"..............................................................................
.H 3 "Run-time Information about Classes"
C++ does not provide information about the class hierarchy and the instance
variables of objects at run-time. ET++ requires this information for the object
input/output facility (<ref object input/output>) and the programming
environment. In order to preserve enough information until run-time a few
conventions have to be followed. The basic idea is to call a macro in the
definition and implementation part of a class. The following example shows a class
conforming the ET++ coding conventions.
.P1
<italic // file Example.h>

class Example: public Object {
    class Collection *col; 
    int size; 
    char *name; 
public:
    \f(TBMetaDef(Example);\fP
    Example(); 
    //... 
};

<italic // file Example.c>

\f(TBMetaImpl0(Example);\fP

Example::Example() 
{
    //...
}
.P2
In the simplest form both macros just take the name of the class as
argument. Information about the instance variables can be specified with
the <code MetaImpl> macro. In this macro the instance variable's type and
name are enumerated:
.P1
MetaImpl(example, (I_O(col), I_I(size), I_CS(name)));
.P2
The symbols <code I_?> are used to specify the type of an instance variable.
Their meaning is described in the following table:
.TS
tab(!) box;
lfTT l.
I_O!pointer to an instance of class Object or one of its
!subclasses (Collection is a subclass of Object). 
I_I!int 
I_X!hexadecimal decimal display of an int
I_S!short
I_C!character
I_F!float
I_D!double
I_P!Point
I_R!Rectangle
I_FT!Font
I_CS!zero terminated character string
I_CSS!zero terminated array of zero terminated
!character strings (e.g. argv)
.TE
.P
Arrays of these <italic primitive> types with a fixed constant size require as
a second argument their size. For example <code I_IA(contents, 20)> specifies
an integer array of size 20.
.P
Dynamically growing arrays typically use another instance variable to store their
actual size. Arrays of this kind can be described with the <code I_?V>
specifier.
This specifier takes the name of the instance variable storing the actual size
as the second argument. For example the class <code CheapText> stores the
contents of a text in a dynamically growing character array:
.P1
class CheapText: public Text {
   char *contents;   // contents of text
   int  len;         // length of the text
   int  size;        // allocated size of character array
   //...
};

MetaImpl(CheapText, (I_CV(contents, len), I_I(len), I_I(size)));
.P2
Instance variables that are structures have to be described by enumerating
their individual fields:
.P1
struct sv {
    int iv1;
    int iv2;
};

class X: public Object {
   iv sv;
   //...
};

MetaImpl(X, (I_I(sv.iv1), I_I(sv.iv2)));
.P2
The order of the instance variable declarations in the <code MetaImpl> macro is
irrelevant. Misspelled instance variable names are detected by the compiler.
.P
For abstract classes the macro <code AbstractMetaImpl> should be used. This
macro has the same calling conventions as <code MetaImpl>. The information
whether a class is abstract or not is used only in the programming environment
to highlight them with an italic faced font.
.P
These macros declare an instance of a so called meta class for a class. The term
metaclass is used in ET++ to refer to a class that stores information about
another class. Metaclasses are instances of the class <italic Class> which is
itself a subclass of <code Object>. Inspecting an instance of <code Class>
illustrates what kind of information is stored in a meta class.
In order to get access from an instance of a
class to its corresponding meta class the macros generate a method called <code
IsA> returning the meta class instance. Another generated method called <code
Members> enumerates all instance variables of an object and provides
information about their types and offsets.
.P
The consequences of not conforming these conventions and not calling these two
macros are:
<item>
the fields of an instance cannot be inspected in the inspector 
<item>
the type of an instance refers not to the class itself but to a superclass
<item>
it is not possible to test the dynamic type of an <code Object> with the <code
IsKindOf> method (<ref ET++ foundation>)
<item>
it is not possible to store a pointer to such an object with the ET++ object
input/output facility
<item>
the source code is not accessible from the browser
.P
.\"..............................................................................
.H 3 "Providing additional Information for the Inspector"
The two top right panes in the inspector are used to browse the instances of a
class. Instances of a class are displayed with their hexadecimal address. In
order to give some additional information to identify an object the method
<code InspectorId> can be overridden.  This method typically uses the value of
an instance variable and fills a buffer given as argument with a string. For
example, documents use their name as illustrated below:
.P1
void Document::InspectorId(char *buf, int size)
{
    strncpy(buf, docName, size);
}
.P2
.\"..............................................................................
.H 3 "Header Files"
To protect header files against multiple includes ET++
uses <code #ifndef>, <code #endif> preprocessor directives:
.P1
--- File Object.h ---

#ifndef Object_First 
#define Object_First 

// class definition  

#endif  Object_First
.P2
The number of included files in a header file should always be minimized,
otherwise <path cpp> will soon reach its limits. For this reason only the
superclass of a class should be included in a header file whenever possible.
Consequently pointer instance variables are declared as shown below:
.P1
#include "Collection.h"

class OrdCollection: public Collection {
  \f(TBclass\fP ObjArray *contents; 
  //... 
};
.P2
The header file of <code ObjArray> is only included in the implementation file
of the class.
.\"..............................................................................
.H 3 "Naming Conventions"
The implementation of ET++ uses the following naming conventions:
<item>
Class names and methods start with a capital letter
<item>
Instance and local variables start with a lower case letter
<item>
The constants of an enumeration type start with an <quote e>
.P1
enum Direction { eHor, eVert };
.P2
<item>
Global variables start with a <quote g> (<code gApplication>)
<item>
Constants start with a <quote c>
<item>
Constants for command codes start with a <quote c> and the rest of the
identifier is capitalized (<code cCUT>).
.P
.\"..............................................................................
.H 3 "Deleting Objects"
An object should never by deleted by calling the delete operator directly it is
preferable to use the macro <code SafeDelete>. This macro tests if the pointer
is 0, if not calls the delete operator and sets the pointer to 0. The test for
a 0 pointer is necessary when virtual destructors are used, otherwise the
application will crash because the address 0 is dereferenced.
.P
This and some other useful macros, inline functions and basic types functions
are defined in the file <path Types.h>.
.\"..............................................................................
.H 3 "Static Constructors/Destructors"
Implementations of C++ typically have some problems with correct calling order
of static constructors. This results in some nasty bugs when there are
dependencies among the different constructors.
.P
The best way to circumvent this problem is to avoid static objects completely.
Wherever possible try to use <italic delayed creation> of global objects as
illustrated below:
.P1
PrintDialog *gPrintDialog= 0;

Class::AnyMethod()
{
    if (gPrintDialog == 0)
       gPrintDialog= new PrintDialog;
}
.P2
A global object created in this way can be freed with the help of the <code
ONEXIT> macro. The statements defined with this macro will be executed when
the application terminates. The only argument of <code ONEXIT> is a unique
name, typically the name of class implemented in this file.
.P1
ONEXIT(PrintDialog)
{
    SafeDelete (gPrintDialog);
    // any other statement that should be executed upon exiting
}
.P2
The counter part to <code ONEXIT> is <code ONENTRY> providing for the execution
of code when the application is started.
.H 3 "Secure Casts"
The Guard construct provides for explicit secure type conversions between
subclasses of <code Object>. Example:
.P1
int TextItem::Compare(ObjPtr op)
{
    return strcmp(text, \f(TBGuard(op, TextItem)\fP->text);
}
.P2
<code op> is casted to a <code TextItem> if its dynamic type is <code
TextItem> otherwise an error will be signaled.  
.\"..............................................................................
.H 3 "Using the +e2 Compiler Option"
The ET++ distribution includes a patch to AT&T's <path cfront> which adds a
<bold +e2> option. The intend of this option is to reduce the binary size of
an application by minimizing the number of generated <italic vtbls>. This new option is
comparable with <path cfront>'s standard options <bold +e0>, <bold +e1> but is
easier to use. When <path cfront> is called with the <bold +e2> option a vtbl
for a class is only generated in those files including a special comment. This
comment consists of a list of class names indicating that a vtbl for such a
class has to be included in the generated object file. The convention for using
this comment is to add it in the file implementing the corresponding class. For
the file <path Set.c> which implements the classes <code SetIter> and <code
Set> the <bold +e2>-comment is shown below:
.P1
<bold //$>Set, SetIter<bold $>
.P2
The error message of the loader:
.P1
ld: __Set_vtbl undefined
.P2
indicates that the <bold +e2> option is used but a corresponding <bold +e2>-comment is missing.
.\"..............................................................................
.H 3 "ET++ Makefiles"
When compiling a new application start with copying an existing makefile and
use it as a template. <etpath /applications/micky/makefile> is a good
example.
.P
Several macros have to be adapted according your local installation.

.TB "ET_DIR = \fIET_DIR\fP"
Replace <italic ET_DIR> with the directory ET++ was installed in.

.TB "CCFLAGS = +e2 -I$(ET_DIR)/src"
The option <bold +e2> is only valid if the patches distributed 
in <etpath /C++> were applied.

.TB "LD = $(ET_DIR)/bin/etld"
<code Etld> is a shell script for optimized linking of ET++ applications
on BSD systems.
It avoids to link an application twice to find out the static
constructors/destructors on BSD systems.
The options of <path etld> are:
.IP "\-col:\ \ \"
link only the collection classes. This option can be used when no graphical classes
are used in an application
.IP "\-static:\ \ \"
link the application statically (only applicable on SUNOS 4.0 and above).
.P
All other options are passed unmodified to the
linker.
.P

.TB "MAKEDEP = $(ET_DIR)/bin/domakedep"
In order to maintain the makefile dependencies we use Kim Walden's public
domain makefile generator. The source for this tool is distributed with ET++ in
the <etpath /util/makedep> directory. The dependencies are stored in a separate
file called <path deps>. This file is included in the makefile with the <code
include> directive of Sun's make. To create the dependencies file in the first
place execute
.P1
touch deps
.P2
followed by
.P1
make depend
.P2
<notice>The standard c-preprocessor runs out of <italic temporary string
space> (whatever this means) and aborts when the pathnames of the included
files specified with the <code -I><italic directory> option become too long. The work around is
to use symbolic links or relative pathnames to shorten the pathnames of the
included files.
.H 2 "Other built-in Utilities"
ET++ applications have built-in some utilities which can be invoked from the
keyboard. In order to use them depress the <key SHIFT>, <key CTRL>, 
<key META> keys together with one of the following characters:
.TS
tab(!) box;
lfB l.
s!display on the standard output the actual number of instances of classes 
 !derived from <code Object>
p!produce hardcopy output of the window contents
q!close this window
w!enable warning messages
.TE
.\"==============================================================================
.H 1 "An Overview of the ET++ Class Library"
.\"------------------------------------------------------------------------------
.H 2 "ET++'s Foundation"
The ET++ foundation are the root class of the class library the class <code
Object> and the class <code Class>, together with an object input/output
facility.
.\"..............................................................................
.H 3 "The Class Object"
All objects that should be managed by the collection classes described below
have to be derived from the class <code Object>. The most important methods
of <code Object> can be categorized into:
.H 4 "Inquiries about an Object"

.TB "Class *IsA()"
Return the metaclass object associated with <code this>, this method is
generated by the <code MetaDef>-macro.

.TB "char *ClassName()"
Return the class name of an <code Object>.

.TB "bool IsKindOf(className)"
<code IsKindOf> is a macro returning <code TRUE> if the object is an instance
of the same or of a subclass of <code className>. Example:
.P1
Object *op; 
if (op->IsKindOf(Collection)) //...
.P2
.H 4 "Comparing Objects"
To compare two objects for equality the method <code IsEqual> should be used.
The collection classes described below use this method to perform
comparisons.

.TB "bool IsEqual(Object *anotherObject)"
The class <code TextItem> implements the <code IsEqual> test as shown below.
.P1
bool TextItem::IsEqual(Object *op)
{
    return (op->IsKindOf(TextItem) && 
	    strcmp(text, ((String*)op)->text) == 0);
}
.P2
This method takes a pointer to any object as argument, for this reason the
dynamic type of the object has to be checked before performing the equality
test.

.TB "int Compare(Object *op)"
Compare <code op> with <code this>, this method should return a negative result
if <code this < op>, zero if <code this == op>, and a positive result if
<code this \> op>.

.TB "int Hash()"
Return a hash value of an object used as probe in the ET++ collection classes based on
hashing (<code Set>, <code Dictionary>).
<code Hash> should always be overridden
when a class overrides <code IsEqual>.
.H 4 "Object Input/Output"
Input/Output of an object structure of arbitrary complexity is based on the two
methods:

.TB "ostream& PrintOn(ostream &s)"
.TB "istream& ReadFrom(istream &s)"
These methods have to be overridden to write or read the object's instance
variables to or from a C++ stream. Example:
.P1
class Foo:: public Object {
    int i;
    ObjList *ol;
public:
    ostream& PrintOn(ostream &s)
	{
	    Object::PrintOn(s); 
	    return s << i SP << ol SP; 
	}
    istream& ReadFrom(istream &s)
	{ 
	    Object::ReadFrom(s);
	    return s >> i >> ol; 
	}
};
.P2
Instance variables that are pointers to other objects, <code ol> in the example
above, can be treated as all the other instance variables. 
<notice>In order to correctly store a pointer to an object it is necesseray
that the corresponding class conforms the ET++ coding conventions, e.g. it calls
<code MetaDef> and <code MetaImpl> macro.
.P
ET++ takes care of
linearizing (even circular) pointer structures automatically. Both methods
should always start with a call to the inherited method to store or read the
instance variables of the superclass. Instance variables written to a stream
have to be separated with some white space characters. As a shorthand notation
for <code << " "> the macro <code SP> can be used (<code NL> can be used for
<code << "\en">). In addition to reading the instance variables of an object
the <code ReadFrom> method should initialize variables that have not been
written out in the <code PrintOn> method. If an instance variable is of one of
the types enum, <code bool> or <code char*> it has to be treated specially
For those instance variables use the
constructs illustrated in the following example:
.P1
enum Flags {
    eflag1,
    eflag2
};

class Foo2: public Object {
    char *str;
    bool b;
    Flags f;
public:
    //...
    ostream& PrintOn(ostream &s)
	{
	    Object::PrintOn(s); 
	    PrintString(s, str);
	    return s << b SP << f SP; 
	}
    istream& ReadFrom(istream &s)
	{ 
	    Object::ReadFrom(s);
	    ReadString(s, &str);
	    return s >> \f(TBBool\fP(b) >> \f(TBEnum\fP(f);
	}
};
.P2  
The functions <code PrintString/ReadString> take care of quoting characters
which would conflict with the ET++ file format for objects.
.H 4 "Copying Objects"
There are two different methods to produce a copy of an object.

.TB "Object *Clone()"
<code Clone> returns a copy of an object without copying the references to other
objects from this object. 

.TB "Object *DeepClone()"
<code DeepClone> returns a copy of an object and recursively copies the
references to other objects, e.g. a deep clone object does not share any
pointer instance variables with the original object. The implementation of <code
DeepClone> in the class <code Object> is based on the ET++ object input/output
facility described in the next section. This method typically does not have to
be overridden when the corresponding <code PrintOn> and <code ReadFrom> methods
are implemented.
.H 4 "Change Propagation"
The class Object defines the framework to synchronize the state of different
objects.
.P1
void AddDependent(Object*);
Object* RemoveDependent(Object*);
void Changed()
void ChangedWhat(void* what)
void DoUpdate(Object*,void*);
void ChiefDied(Object*);
.P2
This so called <italic change propagation mechanism> is modelled after the
Smalltalk-80 changed and update principle. An object can announce its changes
by calling the <code Changed> method. <code Changed> triggers a call to <code
DoUpdate> for all objects that have been registered as dependent of <code this>
with <code AddDependent>.
.P
<code Changed> can be called with an argument to specify the reason for the
change which will be passed to the <code DoUpdate> method. <code DoUpdate> is
implemented as an empty method in the class <code Object>. In order to react
on a change <code DoUpdate> has to be overridden. When an object is deleted all
dependents are notified with a call to <code ChiefDied> that has to be
overridden similar as <code DoUpdate> to react on this event.

.TB "bool PrintOnWhenDependent(Object *anObject)"
This method is a hook that allows to control whether a dependency relationship
of an object should be stored during a call to <code PrintOn>. By default this
method returns <code TRUE> indicating that the dependency relationship between
<code this> and <code anObject> should be stored.
.H 4 "Programming Environment Support"
The class <code Object> defines several methods to be used in conjunction with the
ET++ programming environment.

.TB "void Inspect()"
<code Inspect> starts the Inspector and displays the state of <code this>.

.TB "void EditSource(bool definition)"
<code EditSource> pops up the source code browser loaded with the source code of <code
this>' class. Whether the class definition or the class implementation should
be loaded initially is specified in <code definition>.

.H 4 "Flags"
The class <code Object> provides some space to associate with each object a set
of flags. These flags can be used instead of boolean valued instance variables.
The manipulation methods for flags are:
.P1
void SetFlag(int f, bool b)
void SetFlag(int f)
void ResetFlag(int f)
bool TestFlag(int f)
void InvertFlag(int f)
.P2
ET++ uses the convention as shown below to avoid a conflict with a superclass
that uses the same flag. For example the flags for the class <code Class> a
subclass of <code Object> are:
.P1
enum ObjFlags {
    eObjIsDeleted   =   BIT(1),
    eObjLast        =   1
};

<italic // class ><code Class> <italic a subclass of> <code Object>

enum ClassFlags {
    eClassAbstract  =   BIT(eObjLast + 1),
    eClassLast      =   eObjLast + 1
};
.P2
<code BIT> is a macro defined in <path Types.h> and sets the bit at the
given position.
.H 4 "Error Handling"
ET++ allows a client to register a procedure to be called whenever a fatal
or non-fatal error occurs. This facility is intended for error reporting
and logging but not for error correction or recovery. An error handler
is of the type:
.P1
void (*ErrorHandlerFunc)(int level, bool abort, char *location, char *msg);
.P2
<code Level> indicates the severity of the error. Errors are categorized
into:
.TS 
tab(!);
l l.
warning! 0-999
error!1000-1999
system errors!2000-2999
fatal errors! > 3000
.TE
If <code abort> is set to <code TRUE> the application aborts after reporting the
error. <code location> indicates the method or function where the error occurred and <code msg>
stands for the corresponding error message.
If only the collection classes are used without the application framework classes
the function to be called on error conditions is set with
<code SetErrorHandler>. Otherwise the method <code DoOnError> of
<code Application> can be overriden to report the error. The default
implementation of this method shows an alert box with the options to ignore,
abort, display a stack trace, or to invoke the ET++ inspector.
To call the installed error handler, use either:
.P
.P1
void Error(char *location, char *msgfmt, ...);
void SysError(char *location, char *msgfmt, ...);
void Warning(char *location, char *msgfmt, ...);
void Fatal(char *location, char *msgfmt, ...);
.P2
All these functions provide a <code printf> like interface to format the message.
The class <code Object> overloads these functions and prepends the class name
to <code location>.
.P
The functions below allow to set at which error level the application should
be aborted (<code SetAbortLevel>) and which messages should be ignored
(<code SetIgnoreLevel>). Both methods return the old level.
.P1 
int SetAbortLevel(int newlevel);
int SetIgnoreLevel(int newlevel);
.P2
.P
After a crash of an application the SUNOS interface of ET++ automatically
displays a stack trace.
.\"..............................................................................
.H 3 "The Collection Classes"
The ET++ collection classes are modelled after the Smalltalk-80 collection
classes. The inheritance relationship among the different classes is shown in
the following table.
.P1
Object                          
    Collection          \fIabstract superclass for all collection classes\fP
    Set                 \fIhash table\fP
    Bag                 \fIhash table with duplicate objects\fP
	Dictionary      \fIdata structure for storing key value pairs\fP
	    AssocArray  \fIa multi dimensional associative array\fP
			    \fI(see <etpath /examples/AssocArray.c>)\fP
    ObjArray            \fIarray of object pointers, with range checking and\fP
			\fIthe possibility to grow or shrink\fP
    SeqCollection       \fIabstract superclass for collections preserving the\fP
			\fIthe order in which the objects were added\fP
	ObjList         \fIdoubly linked lists\fP
	    SortedObjList \fIsorted list based on <code Object::Compare()>\fP
	OrdCollection   \fIOrdered Collection - array based implementation of a list\fP
.P2
The collection classes are written to work on instances of class <code
Object>. Some of the methods supported by all collections come in pairs, e.g.
<code Remove>, <code RemovePtr>. The difference between these methods is that
<code Remove> uses <code IsEqual> in comparisons and <code RemovePtr> uses
pointer identity. This distinction is important for collections with duplicate
entries like <code ObjLists> or <code OrdCollections>, because <code IsEqual>
does not uniquely identify an object.

.TB "Object* Add(Object*)"
Adds an <code Object> to a collection and returns a pointer to an object
actually in the collection.

.TB "Object* Remove(Object*)" 
.TB "Object* RemovePtr(Object*)"
Remove an <code Object>.

.TB "Object* Find(Object*)" 
.TB "Object* FindPtr(Object*)"
Find an <code Object> in a collection, returns 0 when the <code Object> is not
found

.TB "bool Contains (Object*)" 
.TB "bool ContainsPtr (Object*)"
Test whether an <code Object> is contained in a collection.
.H 4 "Memory Management"
The collection classes are implemented by storing pointers to the objects and
not the objects itself. Due to the possibility that an object is shared among
several collections, the collection itself cannot decide when an object should
be freed. For this reason all collections use the policy to manage only the
storage for the collection data structures but not for the objects
stored in the collection. The decision when to delete an object is up to the
client of a collection. The destructor of a collection does not free the
objects stored in the collection. The method <code FreeAll> can be used to free
the contents of a collection.
.H 4 "Iterating over a <code Collection>"
The ET++ collection classes use the notion of an <italic iterator>
to visit all the
objects of a collection. An iterator is responsible to store the state of the
traversal and to provide the method <code operator()()> to skip to the next
object of the collection. When all the objects of a collection have been
visited <code operator()()> returns 0. Every collection class provides an
implementation of an <code Iterator>. The abstract interface of all these
iterators is defined in the class <code Iterator>.
.P
The class hierarchy for iterators:
.P1
Iterator                    \fIabstract superclass for iterators\fP
    SetIter                 \fIiterator for Sets\fP
    DictIter                \fI   "      " Dictionaries\fP
    ObjListIter             \fI   "      " ObjLists\fP
	RevObjListIter      \fI   "      " reverse iterator for ObjLists\fP
    OrdCollectionIter       \fI   "      " iterator for OrdCollections\fP
	RevOrdCollectionIter\fI   "      " reverse iterator for OrdCollectiions\fP
.P2
Iterators are used as shown below:
.P1
ObjList shapes;
shapes.Add(new BoxShape);

//...

ObjListIter next(Shapes);

Shape *s;
Rectangle r;

while (s= (Shape*)next())
	s->Draw(r);
.P2
The type of the object returned from <code operator()()> is <code Object*>.
For this reason it typically has to be casted to a more specific type before an
operation can be executed.
.P
An algorithm implemented to work for all kinds of collections which needs an
iterator can request an instance of an iterator with the method <code
GetIterator> from a collection. The returned instance is dynamically allocated
and has to be freed by the programmer (to reduce the memory allocation overhead
ET++ uses its own memory management for iterators). An example for such an
algorithm is <code Collection::Contains> which is implemented only in terms of
the abstract interfaces of <code Collection> and <code Iterator> and is
therefore applicable to any collection.
.P1
bool Collection::Contains(Object *anObject)
{
    Iterator *next= GetIterator();
    Object *op;
    bool found= FALSE;

    while (op= (*next)())
	if (op->IsEqual(anObject)) {
	    Found= TRUE;
	    break;
	}
    delete next;
    return found;
}
.P2
It is error prone and results in ugly code to delete dynamically allocated
iterators manually. For this reason ET++ provides as a kind of syntactic sugar
an additional class <code Iter> which takes care of freeing a dynamically
allocated iterator instance in its destructor.
.P1
bool Collection::Contains(Object *anObject)
{
    Iter next(this);  // or: Iter next(GetIterator()); 
    Object *op;

    while (op= next())
	if (op->IsEqual(anObject)) 
	    return TRUE;
    return FALSE;
}
.P2
A method can be applied to all object of a collection with the
macro:

.TB "void ForEach(itemType,method)(arguments,...)"
Example:
.P1
Collection *col;
bool on, redraw;

col->ForEach(VObject,Enable)(on, redraw);
.P2
In this case <code col> is a collection of <code VObjects> and the method
<code Enable> is called for all its members with the arguments <code on> and
<code redraw>.
<notice><code ForEach> is a macro which expands into several statements without
scope delimiters <code { }>. Enclose <code ForEach> with <code { }> where it
becomes necessary.
.br
In addition <code ForEach> constructs two variables
by concatenating the <code itemType> and <code method> parameters. So don't use 
any whitespace in <code ForEach>'s parameter list.
.P
In order to assert that all items of a collection are of a certain type
<code AssertClass(ClassName)> can be used.
.\"..............................................................................
.H 3 "Built-in Types and Collections"
The collection classes can only manage instances of classes derived from <code
Object>. In order to store the built-in types float or int, ET++ provides the
classes <code ObjInt> and <code ObjFloat>. These classes have as instance
variable a number of the corresponding type and implement the abstract methods
defined in <code Object>.
.H 3 "Strings"
The current version of ET++ does not include a class <code String> for
string manipulation and only offers some utility functions 
(<etpath /src/String.h>). 
.\"..............................................................................
.H 3 "Point and Rectangles"
The classes <code Point> and <code Rectangle> should be used whenever
coordinates have to be manipulated. Predefined <code Points> and <code
Rectangles> are: <code gPoint0> (0,0), <code gPoint1> (1,1), <code gPoint_1>
(-1, -1), <code gPoint2>, <code gPoint4>, and <code gRect0> (<code gPoint0>,
<code gPoint0>). Using
this constants reduces the binary size of an application.
.\"==============================================================================
.H 1 "Window System Interface"
The graphic primitives and the corresponding constants can be found in the
following files in <etpath /src>
.HU "Drawing/Cursors (<path Port.h>):"
This file exports constants for patterns, raster ops, linecaps, 
polygon types and cursors together with all the drawing primitives.
.HU "Fonts (<path Font.h>)"
This file exports the definitions and constants related to font management. 
The meaning of some standard fonts defined in this file are:
.TS
tab(!);
lfTT l.
gSysFont!font to be used in menus, titlebars etc.
gApplFont!default font of an application
gFixedFont!a fixedwidth font
.TE
The size of these fonts is can be set in the environment variable
<code ET_FONT_SIZE>. 12 point fonts will be used by default.
.HU "Bitmaps (<path Bitmap.h>)"
The example below illustrates how to create a static bitmap:
.P1
static short UpArrowBits[]= {
#   include "images/UpArrow.image" 
};
static StaticBitmap ArrowUp(Point(16,16), UpArrowBits);
.P2
The file <path images/UpArrow.image> contains a list shorts and is typically
generated on SUNs with <path iconedit(1)>. <path Iconedit> allows only to create either 16x16
or 64x64 bitmaps, in order to extract a subregion of such a bitmap the utility
bmcut (<etpath /util/bmcut>) can be used.
.HU "Events (<path Token.h>):"         
This file contains the definition of a class <code Token>, which used to
describe window system events.
.\"==============================================================================
.H 1 "Application Framework Classes"
The following discussion of the basic application framework classes <code
Application>, <code Document>, <code View>, <code Window>, and <code Command>
is intended as a conceptual introduction to the most important aspects of ET++
and of an application framework (e.g. MacApp) in general. Most of these
classes originate from MacApp and therefore have a similar behavior and
interface.
.P
Upon starting an ET++ application the main program creates an <code
Application> object and calls the <code Run> method for that object in order to
hand control to ET++. When the user wants to create a new document or open an
existing one ET++ puts up the appropriate dialogs and calls a method of the
application object to create a new <code Document> object.
.P
A <code Document> object contains an applications's data and
provides methods to save the data on disk and read it back into memory. In
addition it creates <code Windows>, and defines the window layout
by creating <code Expanders>, <code Clippers>, or <code Scrollers> and installs
the corresponding <code Views>. <code View> objects provide drawing surfaces on
which the document's data or other information is displayed. It also forwards
input events to interaction objects within the <code View> and knows how to
print its surface onto a printer.
.br
A <code Clipper> is a rectangular area of the window that shows part of a <code
VObject> (a <code View> is a subclass of <code VObject>) and knows how to
scroll that part of a <code VObject>.
.br
A <code Window> object controls the document's window on the screen and manages
all operations pertaining to windows including opening, closing, resizing,
moving, and redrawing. All the classes mentioned above are subclasses of the
class <code EvtHandler> which defines abstract methods to react on input
events. The default implementation forwards them to another <code EvtHandler>.
.br
The <code Command> class provides a convenient framework for implementing
undoable commands. It is subclassed for every command of an application to add
fields that will maintain the state necessary to do, undo and redo the command,
and to implement the corresponding methods <code DoIt>, <code UndoIt> and <code
RedoIt>. Calling these methods is done completely under the control of ET++.
.P
The following sections describe some mechanisms related to the application framework
classes.
.\"..............................................................................
.H 3 "Storing/Loading Documents"
To store or load the contents of a document in a file the methods <code DoRead>
and <code DoWrite> have to be overridden in a subclass of <code Document>.
.P1
void DoRead(istream &, FileType *ft);
void DoWrite(ostream &, int option);
.P2
The implementation of these methods typically uses the object input/output
facility to transfer the contents of a document to a C++ stream (FileType is
explained below). If the standard ET++ format is used to store a document both
methods should first call the inherited <code DoRead>/<code DoWrite> methods. These
inherited methods take care of writing and reading an additional header line
stored together with the document. The header line consists of the external
document type (e.g. <code DRAW, VOBTEXT>) and the name of the application which
generated the document. If a document has to be stored as a pure ascii document
without the header line the calls of the inherited method have to be omitted.
The external document type is associated with a document in the class <code
Document>'s constructor:

.TB "Document(char *extDocType)"
This external document type is used whenever ET++ has to decide whether an
application can handle the contents of a file. A set of predefined external
document or file types can be found in <path FileType.h>.
.P
An application handling only a single type of documents hands their external
type name over to ET++ in the constructor of the class <code Application>.

.TB "Application(int argc, char *argv, char *mainDocType, char *opts)"

Every application that handles several document types must override the method:

.TB "bool Application::CanOpenDocument(FileType *ft)"

ET++ calls this method to test whether an application can handle the
contents of a file. <code Filetype> is a class giving access to status
information about a file. Its member functions are:

.TB "char *Type()"
returns the external document type associated with the file

.TB "char *Creator()"
returns the name of the ET++ application which generated the file, 0 indicates
that the creator is unknown.

.TB "long SizeHint()"
returns the size of the file in bytes (-1 indicates that no information about
the size available)

.TB "bool IsAscii()"
returns whether the file is an ascii file or not.
.P
The following example shows how <code CanOpenDocument> is implemented for an
application handling ascii files and files with the external type <code DRAW>.
.P1
bool myApplication::CanOpenDocument(class FileType *ft)
{
    return strismember(ft->Type(), "DRAW", cDocTypeAscii, 0);    
}
.P2
<code Strismember> is a utility function which checks whether the first argument
is in the set of strings specified in the following zero terminated argument
list.
.P
The method <code Document::CanLoadDocument> can be overridden to specify which
subset of the external file types specified in <code CanOpenDocument> an
already open document can handle, e.g. can replace its current contents.
.P
A <code Document> class which can read its contents from a file stored in
different formats uses the additional <code FileType> parameter passed by ET++
to the <code DoRead> method in order to perform the necessary conversions.
Example:
.P1
void myDocument::DoRead(istream &s, FileType *ft)
{
    if (strcmp(ft->Type(), "DRAW") == 0) 
	// read document stored in DRAW format
    else if (ft->IsAscii()) 
	// read the contents from an ordinary ascii file
    else
	Error("Cannot Read files of type %s", ft->Type());
}
.P2
.P
The mechanism to import the contents of another document or a file is based
on the two methods:
.P1
    bool CanImportDocument(class FileType *ft);
    Command *DoImport(istream &s, FileType *ft);
.P2
ET++ calls <code CanImportDocument> for the first time with <code ft> set to
zero, only if this call returns <code TRUE> the <cmd import> command will be inserted
into the pop-up menu. <code Import> returns a command object which can be
used to provide undoable import commands.
.\"..............................................................................
.H 3 "Creating the Initial Window Layout"
In addition to storing the data of an application on disk, the class Document
is responsible to create an initial window layout for a document.

.TB "Window *DoMakeWindows()"
This method has to be overridden in subclasses of <code Document> to create the
<code Window> and to install a document's views therein.
.P 
A <code View> is typically not installed directly into a <code Window> but
combined with one of the following classes:
.IP "<code Clipper>"
instances of <code Clipper> show a rectangular cutout of a <code View> and
establish a clipping boundary
.IP "<code Scroller>"
in addition to the functionality provided by the class <code Clipper> instances
of <code Scroller> surround a <code View> with scrollbars.
.IP "<code Splitter>"
instances of <code Splitters> allow to split a <code View> in up to four panes,
showing disconnected portions of the <code View>.
.P
In the simplest case a <code Window> shows only one <code View> through a <code
Scroller> as illustrated in the following example:
.P1
Window *myDoc::DoMakeWindows()
{   
    myView *view= new myView(this, /* ... */);

    return new Window(this, Point(560, 400), eBWinDefault, 
	new Scroller(view)
    );
}
.P2
The first argument of the class <code Window>'s constructor is the object which
will receive events not handled by the window itself, eg. the next event
handler. The <code Point> parameter specifies the window's extent. The third argument
is used to specify the desired behaviour of the window. The set of flags that
can be specified are:
.TS 
tab(!);
lfTT l.
eBWinOverlay!used in menus or alerts to give a hint to the underlying
!window system to optimize the damage handling of a window.
eBWinBlock!used for modefull dialogs, setting this flags
!preempts any input in another window of this process
eBWinFixed!the extent of the window cannot be changed by the user
eWinCanClose!clicking on the close box will hide the window
!this option is typically for windows of modeless dialogs
eBWinDefault!used for application windows
.TE
The last argument is the <code VObject> representing the window's contents. In
this case a new <code Scroller> is created and the <code View> is passed as
first argument to the <code Scroller>. To exchange the <code Scroller> with a
<code Clipper> or a <code Splitter> only the call <code new Scroller> has to be
replaced with the corresponding class name.
.P
The class <code Expander> is used to describe more complex
window layouts. <code Expanders> distribute the available space evenly among
their contained <code VObjects>. The following example illustrates how an
<code Expander> is used to show two <code Scrollers> side by side in one
window. When this window is resized the layout is recalculated and each <code
Scroller> will be assigned the same extent.
.P1
Window *TwoViewDoc::DoMakeWindows()
{   
    myView *view1= new TextView(/*...*/);
    myView *view2= new TextView(/*...*/);
    
    return new Window(this, Point(700, 400), eBWinDefault,
	new Expander(eHor, gPoint2, 
	    new Scroller(view1),
	    new Scroller(view2),
	    0)
    );
}
.P2
The first argument of the <code Expander>'s constructor specifies whether the
available space should be subdivided either in the horizontal (<code eHor>) or
vertical (<code eVert>) direction. The <code Point> argument defines the gap to be used
between the <code VObject>s following in the zero terminated variable argument list.
.P
A <code VObject> can further control the layout mechanism of <code Expander>s
by setting the flags <code eVObjHFixed> or <code eVObjVFixed>. If one of these
flags are set an <code Expander> will not change the size of the <code VObject>
in the corresponding direction. <code Expander>s can be nested to arbitrary
depth.
.P
A document using several windows can create them in <code DoMakeWindows()>.
Each of them is added to the list of a document's windows with a call to <code
AddWindow()>. The window returned from <code DoMakeWindows> is considered as
the base window of the document. ET++ automatically updates the base window's
title bar with the document name and the initial position of the icon is set to
its top left corner.
.\"..............................................................................
.H 3 "Commands"
Every <code Command> objects returned from an event handler method is
assigned a name and an numerical identifier. The name is
used in the <cmd undo> menu entry to show which command can be undone. The
name, identifier and some flags are associated with a command in its
constructor.
<notice>Never assign the id 0 to an undoable command.
.P
The following flags can be set in the constructor of commands:
.TS
tab(!) box;
lfTT l.
eCmdCanUndo!command is undoable (default)
eCmdCausesChange!command modifies the contents of a document (default)
eCmdMoveEvents!provides for mouse up drawing, e.g. TrackMouse
!will be called until this flag is reset
eCmdIdleEvents!call TrackMouse even when there is no mouse activity
eCmdFullScreen!allows tracking and drawing on the full screen
eCmdDoDelete!the command object will be deleted by ET++ (default)
.TE
The predefined command object <code gNoChanges> is returned when an <code
EvtHandler> method (e.g. <code DoKeyCommand, DoMenuCommand>) does not modify the contents of a <code Document>.
.H 3 "User Interface Classes"
.\"
.H 3 "Text handling"
The ET++ classes to handle text can be subdivided in classes storing 
the text and classes which render the text
on the screen. The classes storing the text contents
are all derived from <code Text>, the corresponding class hierarchy
is shown in the following table:
.P1
Text                        \fIabstract superclass for text storage\fP
    CheapText               \fIfor smaller texts without font attributes\fP
    GapText                 \fIfor larger texts\fP
	StyledText          \fIfor texts with font attributes\fP
	    VObjectText     \fIfor texts including graphic objects\fP
.P2 
The text classes have constructors to set either their initial size or
their initial contents. The class <code StyledText> has an additional
constructor to specify a string using different font faces.
.TB "StyledText(Font fd, char* format, ...);"

<code format> contains a format specification a la <code printf>.
In addition the face of the font <code fd> can be changed with the notation
<code @B> (bold), <code @I> (italic), <code @O> (outline), <code @S> (shadow), 
<code @P> (plain), @U (underline). Example:
.P1
StyledText message("File @B%s@B does not exist", filename);
.P2
The same notation is used in <code Alerts> to specify the format of the
message string.
.P
The contents of the text is modified with methods modelled after the
cut/copy/paste operations:
.P1
    void Cut(int from,int to);   
    void Paste(TextPtr t,int from,int to); 
    void Copy(Text* save,int from, int to);
    void Insert(byte c, int from,int to);
    void Append(byte c); 
    void Copy(Text* save,int from, int to);
.P2
The arguments <code from> and <code to> specify the range charactes affected by
an operation. 
.P
The text classes give support to attach a so called <italic mark> to a range of
text. Marks are instances of the class <code Mark> and can be considered as 
a robust pointer to a text range which remains valid in the
face of insertions and deletions in the text.
.P
In addition the text classes include the pattern matching method <code Search>
based
on regular expressions. The class <code RegularExpr> uses the syntax described
in <etpath doc/regex.doc>. 
In order to create an editable text on the screen
instance of a text storage class is created and handed over to any 
text rendering class.
<code Text> classes and Views can be freely combined.
An exception are <code VObjectTexts>, they should always be
used together with a <code VObjectTextView>. A <code VObjectTextView> takes care of
dispatching events among the contained VObjects and alows to resize them
interactively.
The class hierarchy for the text rendering classes is shown below:
.P1
StaticTextView              \fIreadonly text view without a selection\fP
    TextView                \fItextview with a selection\fP
	CodeTextView        \fIadds features to edit source code\fP
	ShellTextView       \fIa textview connected with a UNIX shell, \fP
			    \fIproviding a fancier interface to the shell\fP
	VObjectTextView     \fIa textview adding some support to manipulate\fP
			    \fIgraphical objects stored in a <code VObjectText>\fP
	RestrTextView       \fIrestricts the input from the user, input\fP
			    \fIis only accepted if the resulting text\fP
			    \fImatches a client specified regular expression\fP
.P2
The properties of a <code TextView> can be set in its constructor:
.P1
TextView(EvtHandler *eh, Rectangle r, Text *cont, eTextJust just, 
	 eSpacing sp, bool wrap, TextViewFlags tf, Point border)
.P2
.TS
tab(!);
lfTT l.
next!TextView next event handler
r!dimensions of the view. If <code r.extent.width>  or <code r.extent.height> is
 ! set to <code cFit>, the corresponding dimension is always is always adapted
 !to the size of the text.
cont!install the given text in the view
just!text justification (<code eLeft, eRight, eCenter, eJustified>)
sp!line spacing (<code eOne, eOneHalf, eTwo)>)
wrap!lines wrap around right margin?
tf!flags of a TextView see below
border!border around the text
.TE
Except for the first three arguments default values are provided in all
constructors of <code TextViews>.
Further characteristics are specified in <code tf> with the following
flags:
.TS
tab(!);
lfTT l.
eTextViewReadOnly!text is read only
eTextFormPreempt!preempt formatting when there is user input and resume
!when the application is idle
eTextNoFind!do not add the <cmd find/change> menu entry in <code TextViews>
.TE
.P
<code TextViews> batch incoming input from the keyboard and insert the new text
in one batch. A side effect of this optimization is that, if <code DoKeyCommand>
is overridden in order to handle some input characters especially, it will not
always be called for these characters. This case can be handled properly 
by calling <code SetStopChars> with a string specifiying the characters which
may not be batched.
.P
Whenever a <code TextView>'s dimension or contents changes all its dependent objects are
notified of the change with change propagation <ref 4.1.1.5>. The exact reason for
the change is passed to <code DoUpdate> and is specified with one of 
the constants described below:
.TS
tab(!) box;
lfTT l.
eOrigin!origin of textview changed
eExtent!extent of textview changed
eText!the text itself has been modified
.TE
These change notifications are typically used to adapt the size
of graphical boxes keeping text to the text's extent. 
.\"==============================================================================
.H 1 "Menus"
Menus are maintained with the following methods of class <code EvtHandler>:
.P1
virtual class Menu *GetMenu();
virtual void DoCreateMenu(class Menu*);
virtual void DoSetupMenu(class Menu*);
virtual class Command *DoMenuCommand(int);
.P2

.TB "Menu *GetMenu()"
is called whenever the right mouse button is pressed in order to bring up a menu. 
When overridden <code GetMenu> should return a menu pointer held in an instance 
variable of <code EvtHandler> or a subclass thereof. The default implementation
calls <code GetNextHandler()->GetMenu()>.

.TB "void DoCreateMenu(Menu*)"
is called once for a new menu returned from <code GetMenu>. When overridden it 
should call the inherited <code DoCreateMenu> and then install its own new menu
entries in the menu given as parameter. The following code fragment is a typical 
example:
.P1
void aSubClass::DoCreateMenu(Menu *menu)
{
    aBaseClass::DoCreateMenu(menu);
    menu->Append(new MenuLineItem);
    menu->Append(new TextItem(cMENUCMD1, "command 1"));
    menu->Append(new TextItem(cMENUCMD2, "command 2"));
}
.P2
In this example a <code MenuLineItem> and two <code TextItem>s are appended to
the menu (it is possible to append any <code VObject> to a menu). The
following code shows a shorter notation for this common case:
.P1
void aSubClass::DoCreateMenu(Menu *menu)
{
    aBaseClass::DoCreateMenu(menu);
    menu->AppendItems("-",
		      "command 1", cMENUCMD1,
		      "command 2", cMENUCMD2,
		      0);
}
.P2

.TB "Command *DoMenuCommand(int id)"
Every menu item should have a unique id which is given to
<code DoMenuCommand> when a menu command is selected. Standard ids can be found 
in <path CmdNo.h>. Application ids should start with id <code cUSERCMD>.
.br
Example:
.P1
Command aSubClass::DoMenuCommand(int id)
{
    switch (id) {
    case cMENUCMD1:
	return new MenuCmd1;
    case cMENUCMD2:
	return new MenuCmd2;
    default:
	return aBaseClass::DoMenuCommand(id):
    }
}
.P2

.TB "void DoSetupMenu(Menu *m)"
Initially all menu items are disabled (greyed out). You must override 
<code DoSetupMenu> in order to enable all currently selectable menu items. 
<code DoSetupMenu> is called whenever a menu is going to be opened. 
.br
.P1
void aSubClass::DoSetupMenu(Menu *m)
{
    aBaseClass::DoSetupMenu(m);
    if (\fI possible to choose cmd 1 \fP)
	m->EnableItem(cMENUCMD1);
    if (\fI possible to choose cmd 2 \fP)
	m->EnableItem(cMENUCMD2);
}
.P2
.\"==============================================================================
.H 1 "DialogViews and Dialogs"
A <code DialogView> implements a standard behavior for a <code View>
dealing with different dialog items. It maintains an active text and
allows to cycle through all editable text items with the <key TAB> key.
In addition it identifies a default item (a special <code
ActionButton>) which can be activated with the <key RETURN> key.

.TB "VObject *DoCreateDialog()"
This method is called once to create and return the tree of dialog items (<code
VObjects>, <code CompositeVObjects>) making up the dialog. Output only dialog
items like <code TextItems> and <code ImageItems> can be found in <path
VObject.h>. Grouping of several items can be achieved with <code Cluster>s or
<code Expander>s.  Various input sensitive items like <code ToggleButton>s,
<code ImageButton>s, <code ActionButton>s, and <code RadioButton>s are defined
in <path DialogItems.h>. In addition <path DialogItems.h> contains the
specialized clusters <code OneOfCluster> and <code ManyOfCluster> to
implement a <italic one of> and a <italic many of> behavior of several buttons.
.P
More complex dialog items can be build by installing a <code View> in a
<code Clipper>, in a <code Scroller>, or even in a <code Splitter>.
For example to implement a scrollable list of arbitrary <code VObject>s it is
only neccessary to build a <code Collection> of <code VObject>s, install the
<code Collection> in a <code CollectionView> and put the <code View> in a <code
Scroller>.
.P
Another example is a <code TextView> inside a small <code Clipper> to implement
an editable text line. The predefined class <code EditTextItem> implements this
often used abstraction and can be found in <path DialogItems.h>.
.P
Every dialog item must have a unique identifier (id) in order to be able to
identify any actions performed on it. Items with a standard behavior
(e.g. ok-, cancel-, and default-buttons) should have one of the predefined ids
found in <path CmdNo.h>. User defined items should use ids above <code
cIdFirstUser>.  Output only items like <code Clusters> or <code Expanders>
should have id <code cIdNone>.

.TB "void Control(int id, int part, void *data)"
Whenever an action is performed on a dialog item <code Control> is called
giving the items's id (<code id>), a so called part code (<code part>) and
any additional information (<code data>).
The part code identifies the action performed on the item. For
example when single clicking in a <code CollectionView> <code Control> is called
with parameter <code part == cPartCollSelect>. In this case <code data> is a pointer to a <code Rectangle>,
which gives the selected item or a range of selected items.  Other predefined
part codes can be found in <path CmdNo.h>.
The inherited <code Control> method should be
called whenever an action dismisses the <code Dialog>, e.g. for ids
<code cIdOk>, <code cIdYes>, <code cIdNo>, <code cIdCancel>, <code cIdDefault>.
.P
A subclass of <code DialogView>, <code Dialog> automatically creates and installs itself in
a window, thereby implementing modal and modeless dialog boxes. In
addition it implements the behavior to close the window whenever an
<code ActionButton> is pressed and it factors out the behavior for
undoable dialog boxes by overriding <code Control>.

.TB "void DoSetDefaults()"
is called after the dialog tree is created the first time or an <code
ActionButton> returns the id <code cIdDefault>. In the latter case the
dialog remains opened even if the inherited <code Control> is called.

.TB "void DoSetup()"
must be overriden to enable and disable dialog items according to other
selected options. It is called whenever the dialog is opened.

.TB "void DoSave()"
must be overridden to save the state of all dialog items in order to be
able to undo all settings when the <code Cancel> button is pressed or an item
returns id <code cIdCancel>.

.TB "void DoRestore()"
is called whenever the <code Cancel> button is pressed to restore the
dialog items to their previous state.
.P
You find examples for implementing dialogs in <path FileDialog.C>, path
<path PrintDialog.C>, <path FindDialog.C>, <path GotoDialog.C>, and
<path POSTSCRIPT/PostScript.C>.
.\"==============================================================================
.H 1 "Clipboard"
Class <code ClipBoard> is the basic abstraction for the ET++ clipboard.
The basic idea is to hide all details of maintaining a local and global
clipboard completely from the application. But currently this
abstraction exists only in a very rudimentary implementation. The local
clipboard works under all window systems; the global clipboard only
under SunWindows and X11.
.P
In order to make clipboard support available between different ET++
applications under SunWindow it is necessary to start a separate
process <path clipboard>, a prototypical implementation of a simple
minded clipboard server process. At start up time every ET++
application automatically connects to this server process, thereby
making the clipboard data available to other ET++ applications.
Currently it is not possible to cut and paste between the SunView
clipboard and ET++ applications.
.P
Under X11 the clipboard mechanism works with the PRIMARY selection and
CUTBUFFER0.
.P
The <code ClipBoard> class is not directly accessed in an application,
but used through four methods of class <code View>. In order to make a
selection available for the clipboard, the following methods of class
<code View> must be overridden.

.TB "Command *PasteData(char *type, istream &is>"
<code PasteData> is called after selecting the <cmd paste> menu
command.  The clipboards data is accessible via the <code stream>
parameter.

.TB "bool CanPaste(char *type)"
This method is called whenever the <code View>'s popup menu is
displayed. The <code View> must check if it is possible to paste the
clipboard's data into it's data structure. The <cmd paste> menu entry
is only enabled if <code CanPaste> returns <code TRUE>.

.TB "void SelectionToClipboard(char *type, ostream &os)"
Whenever an application want to paste the clipboard, this method is
called for the current selection holder. The selection holder must
write the selection in the ET++ standard input/output format to the
stream <code os>.
.P
But remember: the ET++ clipboard mechanism is not yet finished! But it
works between most applications dealing with text. It is for example
possible to copy a text containing different <code VObject>s from <path
vobedit> into the <path draw> application even if the draw application
does not contain the code to support the selection's data. Dynamic
loading <quote automagically> loads the necessary .o files into the
running application (try to copy an annotation from <path vobedit>
 into a text object in <path draw>).
.\"==============================================================================
.H 1 "Learning by Example
We currently do not provide manual pages or a lot of documentation about ET++
classes. The best way to learn ET++ is to study the example applications
included in this distribution. The following table lists in order of increasing
complexity the features illustrated by the example applications.
.HU Micky:
The almost empty application
.HU TwoShapes
An application for moving and stretching two simple shapes and includes a menu
to modify the fill pattern of one shape.
<item>Undoable commands
<item>Handling menus, including graphical menu entries
<item>Generic stretchers and movers
<item>Handling the type of a document
<item>Alert boxes
.P
.HU ThreeShapes
An extension of two shapes with a boxed editable text shape. A shape's
fill pattern can be changed with a menu while the cursor is over the shape.
<item>TextViews and their change propagation protocol
<item>Redirecting input events to an arbitrary object
.P
.HU Miniedit
A simple text editor for ascii files. 
<item>Handling pure ascii files
<item>Using <code CodeTextViews>
.P
.HU TwoViews
An application displaying two <code TextViews> in the same window. Both <code TextViews> show
the same text and are updated automatically due to the delayed update mechanism
used in the text classes.
<item>Two views in one window
.P
.HU Typescript
A fancy interface to a unix shell providing the text editing functions for the
current command line as found in all ET++ applications. Output from the shell
is read only and is not editable a reverted caret marks the fence between
output from the shell and the current command line. Input of the user is shown
in a bold styled font. Typescript emulates only a dumb terminal, e.g. <path
more> can be used but more demanding full screen applications a la <path vi>
are not supported.
<item>Using <code ShellTextViews>
.P
.HU PolyDocApp
A merge of miniedit and twoshapes, illustrating how different document types
can be handled within one application. Miniedit documents have an additional
entry <cmd import> in the file submenu. <cmd Import> allows to include another
text file into the document.
<item>Extending the application window
<item>Handling different document types in one application
<item>Importing files
.P
.HU Dialog
The intend of this application is not to show how to create dialogs but to
present all the different dialog items of ET++ in a window.
.HU Calculator
A simple infix calculator. 
<item>Advanced usage of event distribution mechanism
<item>Layout of a two dimensional cluster
.P
.HU Tree
A tree browser. Trees can be stored either in the standard ET++ or pure ascii
format. The ascii format uses indenting by two blanks to define the levels of
the hierarchy. Clicking on a node invokes the source code editor if the name of
the node corresponds a class name. An example of an ascii file is <cmd import>.
This file was generated with makehier provided in the <etpath /bin>
directory. <path makehier> is a <path awk> script that analyzes all *.[cCh] files and
determines the inheritance relationship among the different classes.
<item>Extending the <cmd save> dialog with additional options
<item>Storing a document in different formats
<item>Using <code TreeViews>
<item>Building up a tree for a <code TreeView>
<item>Loading documents of different types with automatic conversion
<item>Using a <code DialogView> as a palette
.P
.HU Vobedit
A text editor with the ability to integrate arbitrary graphical objects
(instances of <code VObject>). These objects behave as ordinary characters and flow
with the text when characters are inserted. Some graphical objects are provided
in the submenu <cmd vobjects>. Selecting an entry from this menu inserts the
corresponding object into the text. Examples are <code Button>s, <code TextView>s, a <italic
window> with a running shell, or recursively another instance of a
<code VObjectTextView> that can be scrolled independently of the rest of the text.
The inserted objects still behave as expected, e.g. they respond to mouse
clicks and keyboard input. The currently active <code VObject> receiving the keyboard
input is highlighted with a grey border. Once inserted the size of a graphical
object can be changed by stretching the bottom left corner with the left mouse
button.
<item>Using the classes <code VObjectText>/<code VObjectTextView>
.P
.HU Layout
This application allows to study and to verify the layout management of the 
ET++ dialog classes.
<item>Generic stretchers, movers
<item>Layout management of clusters
.P
.HU Draw
A full fledged drawing editor with the possibility to dynamically link new shape
types while the application is running. Examples are the shapes defined in
<path DynShape.c>. The file <path dynshapedoc> is a draw document including a <code
DynShape> shape. When this document is loaded the corresponding classes are
dynamically linked and the palette is updated accordingly.
.P
Draw can maintain connections among different shapes. A connection between two
shapes is established by selecting the shapes (a selection can be extended with
a shift click) and then choosing the menu entry connect. Text entered while a
shape is selected is attached to this shape, e.g. when the shape is moved the
text will be moved accordingly. SUN rasterfiles can be imported with <cmd
import> from the file submenu (works only under SunView). Shapes can not only
be moved with the mouse but with the cursor keys as well.
<item>Change propagation to maintain the connectivity among shapes (<path Connection.[ch]>)
<item><code TextViews> as shapes (<path TextShape.[ch]>)
<item>Dynamic linking of classes
<item>Using a collection class to manage the shapes
<item>Using pull down menus
<item>Adding submenus to the main menu
<item>Using the clipboard
.P
Sources of other code examples can be found in the ET++ class library itself.
.P
.HU "FindChange.[Ch]:"
<item>A modeless dialog
<item>Aborting a lenghty operation (change all command)
.HU "PrintDialog.[Ch]:"
<item>A modefull dialog
.HU "Documents.C:"
<item>Alert boxes
.P
.HU "PROGENV/SrcEdit.C"
<item>
Displaying a window without a document. Examples are the hierarchy
and the flat inheritance view.
<item>
Using a <code CollectionView> as a fixed list menu (the class <code ClassListView>).
.P
.HU "ShellTextView.C"
<item>
Dispatching input from other sources than the window system, e.g. a pseudo tty.
<item>Using <code StyledText>
<item>Using robust pointers to text positions with <code Marks>
.P
.HU "PROGENV/Inspector.C"
<item>
The inspector window itself is an example of a complex layout of a window 
with several panes.
.P
