/*
 * exports.h - 
 *  
 *      ExportElmt list set up during  parse. 
 *      (not kept in Module data struct)
 *
 *  SetExports runs through type, value & macro defs and sets the 
 *  exports flag accordingly.
 *
 *  the exportsParsed boolean means whether the symbol "EXPORTS"
 *  was parsed - since if EXPORTS was parsed and the export list
 *  is empty, NOTHING is exported, otherwise if the "EXPORTS"
 *  symbol was not parsed (export list is empty) then EVERYTHING
 *  is exported
 *
 * Mike Sample
 * 91/09/04
 *
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 *
 */


typedef struct ExportElmt
{
    char* name;
    struct ExportElmt* next;
} ExportElmt;


void
SetExports PROTO((Module* m, ExportElmt* e, int exportsParsed));


