/*
 * util.c  - C encoder/decode related utility routines
 *
 *  MS 91/11/04
 *
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */


#define FIRST_LEVEL 1    /* must be 1 or greater */
#define MAX_VAR_REF 512 /* max chars for ref'ing a var eg v->foo->bar.x->v*/

void   MakeVarPtrRef PROTO((CRules* r, TypeDef* td, Type* parent,
                            Type* fieldType, char* parentVarName,
                            char* newVarName));

void   MakeVarValueRef PROTO((CRules* r, TypeDef* td, Type* parent,
                            Type* fieldType, char* parentVarName,
                            char* newVarName));

void   MakeChoiceIdValueRef PROTO((CRules* r, TypeDef* td, Type* parent,
                            Type* fieldType, char* parentVarName,
                            char* newVarName));

void   PrintElmtAllocCode PROTO((FILE* f, Type* type, char* varPtrRefName));

void   PrintEocDecoders PROTO((FILE* f, int maxLenLevel, int minLenLevel,
                              char* lenBaseVarName, int totalLevel,
                              char* totalBaseVarName));

