/*
 * c_rules.h
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

/* see asn1module.h for CTDI (C type def info) */

typedef struct CRules
{
    int  maxDigitsToAppend;  
    char* choiceIdFieldName;   /* name of choiceId field */
    char* choiceIdEnumSuffix;  /* suffix for choiceId enum def name */
    char* choiceUnionFieldName; /* what the name of the choice's union is */
    char* choiceUnionDefSuffix;  /* suffix for choice union def name */
    int   capitalizeNamedElmts;
    char* printRoutineBaseName;  /* eg if "Print" -> PrintFoo(..) */
    char* encodeRoutineBaseName;
    char* decodeRoutineBaseName;
    char* freeRoutineBaseName;
    CTDI typeConvTbl[BASICTYPE_MACRODEF + 1];
}  CRules;

extern CRules cRulesG;







