/*
 * gen_c_vals.c - prints ASN.1 values in C format
 *
 *
 * MS Feb 92
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include <stdio.h>
#include "snacc_config.h"
#include "basetypes.h"
#include "ber.h"
#include "list.h"
#include "oid.h"
#include "asn1module.h"
#include "mem.h"
#include "define.h"
#include "typetbl.h"
#include "rules.h"
#include "type_info.h"
#include "str_util.h"
#include "snacc_util.h"
#include "util.h"
#include "c_kwd.h"
#include "gen_c_vals.h"

/* non-exported routines' prototypes */

static void PrintValueDefsName PROTO((FILE* f, CRules* r, ValueDef* v));
static void PrintValueDefsType PROTO((FILE* f, CRules* r, ValueDef* v));
static void PrintValueInstatiation PROTO((FILE* f, CRules* r, ValueDef* v));




void
PrintCValueDef PARAMS((src, r, v),
FILE* src _AND_
CRules* r _AND_
ValueDef* v)
{
    /* just do oid's, ints and bools for now */
    if ((v->value->basicValue->choiceId != BASICVALUE_OID) &&
        (v->value->basicValue->choiceId != BASICVALUE_INTEGER) &&
        (v->value->basicValue->choiceId != BASICVALUE_BOOLEAN))
        return;

    /*
     * put instantiation in src file
     */
    PrintValueDefsType(src, r, v);
    fprintf(src," ");
    PrintValueDefsName(src, r, v);
    fprintf(src," = ");
    PrintValueInstatiation(src, r, v);
    fprintf(src,";\n\n");

}  /* PrintCValueDef */

void
PrintCValueExtern PARAMS(( hdr, r, v),
FILE* hdr _AND_
CRules* r _AND_
ValueDef* v)
{
    /* just do oid's, ints and bools for now */
    if ((v->value->basicValue->choiceId != BASICVALUE_OID) &&
        (v->value->basicValue->choiceId != BASICVALUE_INTEGER) &&
        (v->value->basicValue->choiceId != BASICVALUE_BOOLEAN))
        return;

    /*
     * put extern declaration in hdr file
     */
    fprintf(hdr,"extern ");
    PrintValueDefsType(hdr, r, v);
    fprintf(hdr," ");
    PrintValueDefsName(hdr, r, v);
    fprintf(hdr,";\n");

}  /* PrintCValueExtern */


static void
PrintValueDefsName PARAMS((f, r, v),
FILE* f _AND_
CRules* r _AND_
ValueDef* v)
{
    char* cName;
    cName = Asn1ValueName2CValueName(v->definedName);
    fprintf(f, "%s", cName);
    Free(cName);
}

static void
PrintValueDefsType PARAMS((f, r, v),
FILE* f _AND_
CRules* r _AND_
ValueDef* v)
{
    /* needs work - just do ints bools and oid's for now */
    switch (v->value->basicValue->choiceId)
    {
        case(BASICVALUE_OID):
            fprintf(f, "%s", r->typeConvTbl[BASICTYPE_OID].cTypeName);
            break;

        case(BASICVALUE_INTEGER):
            fprintf(f, "%s", r->typeConvTbl[BASICTYPE_INTEGER].cTypeName);
            break;

        case(BASICVALUE_BOOLEAN):
            fprintf(f, "%s", r->typeConvTbl[BASICTYPE_BOOLEAN].cTypeName);
            break;

        default:
           break;
    }
}


static void
PrintValueInstatiation PARAMS((f, r, v),
FILE* f _AND_
CRules* r _AND_
ValueDef* v)
{
    /* needs work - just do ints, bools and oids for now */
    switch (v->value->basicValue->choiceId)
    {
        case(BASICVALUE_OID):
            PrintCOidValue(f, r, v->value->basicValue->a.oid);
            break;

        case(BASICVALUE_INTEGER):
            fprintf(f, "%d", v->value->basicValue->a.integer);
            break;

        case(BASICVALUE_BOOLEAN):
            if ( v->value->basicValue->a.boolean)
                fprintf(f, "TRUE");
            else
               fprintf(f, "FALSE");
            break;

        default:
           break;
    }


}



/*
 * given an AOID, a c value is produced.
 * This is used for turning ASN.1 OBJECT ID values
 * into usable c values.
 *
 * eg for the oid { 0 1 2 } (in AOID format)
 * 
 * {
 *     2,
 *     "\1\2"
 * }
 * is produced.
 */
void
PrintCOidValue PARAMS((f, r, oid),
FILE* f _AND_
CRules* r _AND_
AOID* oid)
{
    int i;

    fprintf(f, "{ ");
    fprintf(f, "%d, ",oid->len);
    fprintf(f, "\"");

    /* print encoded oid string in C's 'octal' escape format */
    for (i = 0; i < oid->len; i++)
        fprintf(f, "\\%o", oid->str[i]);
    fprintf(f, "\"");
    fprintf(f, " }");

} /* PrintCOidValue */





