/*
 * c_kwd.c - routines for determining whether a given str is a C
 *             keyword
 *
 *    NOTE: this was hacked up really quickly.  It uses a slow linear
 *          search. A much better approach is to use a hash tbl.
 * 
 * MS 92
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include <string.h>
#include "snacc_config.h"
#include "c_kwd.h"

/*
 * last elmt must be NULL.
 * key words grabbed from K&R 2nd Ed
 */
static char* cKWdG[] =
{
    "auto", "break", "case", "char", "const", "continue",
    "default", "do", "double", "else", "enum", "extern",
    "float", "for", "goto", "if", "int", "long", "register",
    "return", "short", "signed", "sizeof", "static", "struct",
    "switch",  "typedef", "union", "unsigned", "void", "volatile",
    "while", NULL
};


/*
 * returns non-zero if the given str is a C key word
 */
int
IsCKeyWord PARAMS((str),
char* str)
{
    int i;

    for (i=0; (cKWdG[i] != NULL) && (strcmp(cKWdG[i],str) != 0); i++);

    return(cKWdG[i] != NULL);
}



