/*
 *   gen_cpp_code.c - routines for printing C++ code from type trees
 *
 *   assumes that the type tree has already been run through the 
 *   c++ type generator (cpp_types.c).
 *
 *  This was hastily written - it has some huge routines in it.
 *  Needs a lot of cleaning up and modularization...
 *
 * Mike Sample
 * 92
 * Copyright (C) 1991, 1992 Michael Sample 
 *           and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <ctype.h>
#include "snacc_config.h"
#include "basetypes.h"
#include "ber.h"
#include "list.h"
#include "define.h"
#include "asn1module.h"
#include "mem.h"
#include "typetbl.h"
#include "cpp_rules.h"
#include "cpp_types.h"
#include "str_util.h"
#include "snacc_util.h"
#include "print.h"
#include "tag_util.h"  /* get GetTags/FreeTags/CountTags/TagByteLen */
#include "rules.h"
#include "util.h"
#include "gen_c_code.h" /* for PrintConditionalIncludeOpen/Close */
#include "gen_cpp_vals.h"
#include "gen_cpp_any.h"
#include "gen_cpp_code.h"


static char* bufTypeNameG = "BUF_TYPE";
static char* lenTypeNameG = "AsnLen";
static char* tagTypeNameG = "AsnTag";
static char* envTypeNameG = "ENV_TYPE";
static long int longJmpValG  = -100;
static char* baseClassesG = ": public AsnType";

static int printTypesG;
static int printEncodersG;
static int printDecodersG;
static int printPrintersG;
static int printFreeG;


static void PrintSrcComment PROTO((FILE* src, Module* m));
static void PrintHdrComment PROTO((FILE* hdr, Module* m));

static void PrintSrcIncludes PROTO((FILE* src, ModuleList* mods, Module* m));

static void PrintCppTypeDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods, 
                                Module* m, CppRules* r, TypeDef* td));


static void PrintCppValueDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods, 
                                 Module* m, CppRules* r, ValueDef* vd));


static void PrintCppChoiceDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                               Module* m, CppRules* r, TypeDef* td, 
                               Type* parent, Type* choice));

static void PrintCppSeqDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                            Module* m, CppRules* r, TypeDef* td, 
                            Type* parent, Type* seq));

static void PrintCppSetDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                                 Module* m, CppRules* r, TypeDef* td, 
                                 Type* parent, Type* set));
                                
static void PrintCppSetOfDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                                  Module* m, CppRules* r, TypeDef* td, 
                                  Type* parent, Type* setOf));

static void PrintCppAnyDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                                      Module* m, CppRules* r, TypeDef* td, 
                                      Type* parent, Type* setOf));

static void PrintCppListClass PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                              Module* m, CppRules* r, TypeDef* td, 
                              Type* parent, Type* setOf));

static void PrintCppListMethods PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                              Module* m, CppRules* r, TypeDef* td, 
                              Type* parent, Type* setOf));

static void PrintCppSeqOfDefCode PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                                  Module* m, CppRules* r, TypeDef* td, 
                                  Type* parent, Type* seqOf));


static void PrintCppType PROTO((FILE* src, FILE* hdr, ModuleList* mods,
                         Module* m, CppRules* r, TypeDef* td,
                         Type* parent, Type* t));

static void PrintPduMemberFcns PROTO((FILE* src, FILE* hdr, CppRules* r));

static void PrintForwardTypeDecl PROTO((FILE* f, TypeDef* td));

static void PrintForwardValueDecl PROTO((FILE* f, ValueDef* vd));

static void PrintCppEocEncoders PROTO((FILE* src, TypeDef* td, Type* t, char* bufVarName));

static int HasShortLen PROTO((Type* t));

static void PrintCppTagAndLenEncodingCode PROTO((FILE* src, TypeDef* td, Type* t,
                                          char* lenVarName, char* bufVarName));

static void PrintCppTagAndLenList PROTO((FILE* src, Type* t, TagList* tagList,
                                  char* lenVarName, char* bufVarName));

static void PrintCppLenEncodingCode PROTO((FILE* f, int isCons, int isShort,
                                    char* lenVarName, char* bufVarName));

static int CppCountVariableLevels PROTO((Type* t));

static void PrintCppSimpleDef PROTO((FILE* hdr, FILE* src, CppRules* r, TypeDef* td));


static int RestAreTailOptional PROTO((NamedTypeList* e));

static void PrintCppListTagAndLenDecCode PROTO((FILE* src, TypeDef* td, Type* t));
void PrintMakeTag PROTO((FILE* f, Tag* tag));

void PrintCloneMethod PROTO((FILE* f, TypeDef* td));

void PrintDerivedConstructors PROTO((FILE* f, CppRules* r, TypeDef* td));

void PrintNoArgConstructor PROTO((FILE* f, CppRules* r, TypeDef* td));



void
PrintCppCode PARAMS((src, hdr, mods, m, r, longJmpVal, printTypes, printValues, printEncoders, printDecoders, printPrinters, printFree),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
long int longJmpVal _AND_
int printTypes _AND_
int printValues _AND_
int printEncoders _AND_
int printDecoders _AND_
int printPrinters _AND_
int printFree)
{
    TypeDef* td;
    ValueDef* vd;

    longJmpValG = longJmpVal;
    printTypesG = printTypes;
    printEncodersG = printEncoders;
    printDecodersG = printDecoders;
    printPrintersG = printPrinters;
    printFreeG = printFree;

    PrintSrcComment(src, m);
    PrintHdrComment(hdr, m);

    PrintConditionalIncludeOpen(hdr, m->cppHdrFileName);

    PrintSrcIncludes(src, mods, m);

    fprintf(hdr,"// forward declarations\n\n"); 
    FOR_EACH_LIST_ELMT(td, m->typeDefs)
    {
        PrintForwardTypeDecl(hdr,td);
    }
    fprintf(hdr,"\n");

    if (printValues)
    {
        fprintf(src,"// value defs\n\n"); 
        FOR_EACH_LIST_ELMT(vd, m->valueDefs)
        {
            PrintCppValueDef(src, r, vd);
        }
        fprintf(src,"\n\n");
    }

    PrintCppAnyCode(src, hdr, r, mods, m);

    FOR_EACH_LIST_ELMT(td, m->typeDefs)
    {
        PrintCppTypeDefCode(src, hdr, mods, m, r, td);
    }

    if (printValues)
    {
        fprintf(hdr,"// externs for value defs\n\n"); 
        FOR_EACH_LIST_ELMT(vd, m->valueDefs)
        {
            PrintCppValueExtern(hdr, r, vd);
        }
    }

    PrintConditionalIncludeClose(hdr, m->cppHdrFileName);

} /* PrintCppCode */


static void
PrintSrcComment PARAMS((src, m),
FILE* src _AND_
Module* m)
{
    long int t;

    t = time(0);
    fprintf(src,"//\n");
    fprintf(src,"// %s - class member functions for ASN.1 module %s\n", m->cppSrcFileName, m->modId->name);
    fprintf(src,"//\n");
    fprintf(src,"//   This file was generated by snacc on %s", ctime(&t));
    fprintf(src,"//   UBC snacc written by Mike Sample\n");
    fprintf(src,"//   NOTE: this is a machine generated file - editing not recommended\n");
    fprintf(src,"//\n\n");

}  /* PrintSrcComment */

static void
PrintHdrComment PARAMS((hdr, m),
FILE* hdr _AND_
Module* m)
{
    long int t;

    t = time(0);
    fprintf(hdr,"//\n");
    fprintf(hdr,"// %s - class definitions for ASN.1 module %s\n", m->cppHdrFileName, m->modId->name);
    fprintf(hdr,"//\n");
    fprintf(hdr,"//   This file was generated by snacc on %s", ctime(&t));
    fprintf(hdr,"//   UBC snacc by Mike Sample\n");
    fprintf(hdr,"//   NOTE: this is a machine generated file - editing not recommended\n");
    fprintf(hdr,"//\n\n");

}  /* PrintHdrComment */




static void
PrintSrcIncludes PARAMS((src, mods, m),
FILE* src _AND_
ModuleList* mods _AND_
Module* m)
{
    void* tmp;
    Module* currMod;
    
    fprintf(src,"\n");
    fprintf(src,"#include \"asn_incl.h\"\n");  
    tmp = (void*) CURR_LIST_NODE(mods); /* remember curr loc */
    FOR_EACH_LIST_ELMT(currMod, mods)
    {
        fprintf(src,"#include \"%s\"\n", currMod->cppHdrFileName);
    }
    SET_CURR_LIST_NODE(mods, tmp);
    fprintf(src,"\n\n");
    
}  /* PrintSrcIncludes */

static void
PrintCppTypeDefCode PARAMS((src, hdr, mods, m, r, td),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td)
{
    CNamedElmt* n;

    switch(td->type->basicType->choiceId)
    {
        case(BASICTYPE_BOOLEAN):  /* library type */
        case(BASICTYPE_REAL):  /* library type */
        case(BASICTYPE_OCTETSTRING):  /* library type */
        case(BASICTYPE_NULL):  /* library type */
        case(BASICTYPE_OID):  /* library type */
        case(BASICTYPE_INTEGER):  /* library type */
        case(BASICTYPE_BITSTRING):  /* library type */
        case(BASICTYPE_ENUMERATED):  /* library type */
            PrintCppSimpleDef(hdr, src, r, td);
            break;


        case(BASICTYPE_SEQUENCEOF):  /* list types */
        case(BASICTYPE_SETOF):
            PrintCppSetOfDefCode(src, hdr, mods, m, r, td, NULL, td->type);
            break;

        case(BASICTYPE_IMPORTTYPEREF):  /* type references */
        case(BASICTYPE_LOCALTYPEREF):
            /*
             * if this type has been re-tagged then
             * must create new class instead of using a typedef
             */
            PrintCppSimpleDef(hdr, src, r, td);
            break;

        case(BASICTYPE_ANYDEFINEDBY):  /* ANY types */
        case(BASICTYPE_ANY):
/*
            fprintf(stderr,"  ANY types require modification. ");
            fprintf(stderr,"  The source files will have a \" ANY - Fix Me! \" comment before related code.\n\n");
*/
            PrintCppAnyDefCode(src, hdr, mods, m, r, td, NULL, td->type);
            break;

        case(BASICTYPE_CHOICE):
            PrintCppChoiceDefCode(src, hdr, mods, m, r, td, NULL, td->type);
            break;

        case(BASICTYPE_SET):
            PrintCppSetDefCode(src, hdr, mods, m, r, td, NULL, td->type);
            break;

        case(BASICTYPE_SEQUENCE):
            PrintCppSeqDefCode(src, hdr, mods, m, r, td, NULL, td->type);
            break;

        case(BASICTYPE_COMPONENTSOF):
        case(BASICTYPE_SELECTION):
        case(BASICTYPE_UNKNOWN):
        case(BASICTYPE_MACRODEF):
        case(BASICTYPE_MACROTYPE):
            /* do nothing */
            break;
    }
}  /* PrintCppTypeDefCode */
 


static void 
PrintCppChoiceDefCode PARAMS((src, hdr, mods, m, r, td, parent, choice),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* choice)
{
    NamedType* e;
    char* classStr;
    char* formStr;
    char* codeStr;
    int tagLen, i;
    Tag* tag;
    TagList* tags;
    char* varName;
    CppTRI* cpptri;
    int elmtLevel;
    int varCount, tmpVarCount;
    int stoleChoiceTags;
    enum BasicTypeChoiceId tmpTypeId;
    NamedType* defByNamedType;



    /* put class spec in hdr file */

    fprintf(hdr,"class %s %s\n", td->cppTypeDefInfo->className, baseClassesG);
    fprintf(hdr,"{\n");
    fprintf(hdr,"    public:\n");



    /* write out choiceId enum type */
    
    fprintf(hdr,"      enum %s\n", r->choiceIdEnumName);
    fprintf(hdr,"      {\n");
    FOR_EACH_LIST_ELMT(e, choice->basicType->a.choice)
    {
        fprintf(hdr,"           %s = %d", 
                e->type->cppTypeRefInfo->choiceIdSymbol,
                e->type->cppTypeRefInfo->choiceIdValue);
        if (e != (NamedType*)LAST_LIST_ELMT(choice->basicType->a.choice))
            fprintf(hdr,",\n");
        else
            fprintf(hdr,"\n");
    }
    
    fprintf(hdr,"      };\n\n");
    
    /* write out the choice Id field */
    /*     fprintf(hdr,"    protected:\n"); */
    fprintf(hdr,"      enum %s %s;\n", r->choiceIdEnumName,
            r->choiceIdFieldName);
    
    /* write out the choice element union */
    fprintf(hdr,"      union %s\n", r->choiceUnionName);
    fprintf(hdr,"      {\n");
    
    FOR_EACH_LIST_ELMT(e, choice->basicType->a.choice)
    {
        fprintf(hdr, "           ");
        PrintCppType(src, hdr, mods, m, r, td, choice, e->type);
        fprintf(hdr, " %s;\n", e->type->cppTypeRefInfo->fieldName);
    }
    fprintf(hdr,"      };\n\n");
    /*    fprintf(hdr,"      } %s;\n\n", r->choiceUnionFieldName); */
    
    

    PrintNoArgConstructor(hdr, r, td);

    /* write proto of  ostream printing routine */
    if (printPrintersG)
        fprintf(hdr,"      void Print(ostream& os);\n", 
                td->cppTypeDefInfo->className);
    

    /* print clone routine for ANY mgmt */
    PrintCloneMethod(hdr, td);

    /* do BEnc inline */
    if (printEncodersG)
    {
        fprintf(hdr,"      %s B%s(%s b)\n", lenTypeNameG, 
                r->encodeBaseName, bufTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s l;\n", lenTypeNameG);
        fprintf(hdr,"          l = B%s(b);\n",r->encodeContentBaseName);
        
        /* encode each tag/len pair if any */
        FOR_EACH_LIST_ELMT_RVS(tag, choice->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* choices are constructed */
            tagLen = TagByteLen(tag->code);
            
            fprintf(hdr,"          l += BEncConsLen(b, l);\n");
            
            if (tag->class == UNIV)
                fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %s);\n",
                        tagLen, classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %d);\n",
                        tagLen, classStr, formStr, tag->code);
        }
        fprintf(hdr,"          return(l);\n");
        fprintf(hdr,"      }\n\n");
    }
    /* end of BEnc inline */


    /* Do BDec inline */
    if (printDecodersG)
    {
        fprintf(hdr,"      void B%s(%s b, %s& bytesDecoded, %s env)\n", 
                r->decodeBaseName, bufTypeNameG, lenTypeNameG, envTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s elmtLen;\n", lenTypeNameG);
        fprintf(hdr,"          %s tag;\n", tagTypeNameG);
        
        /* print extra locals for redundant lengths */
        for (i = 1; (choice->tags != NULL) && (i <= LIST_COUNT(choice->tags));
             i++)
        {
            fprintf(hdr,"          %s extraLen%d;\n", lenTypeNameG, i);
        }
        fprintf(hdr,"\n");
        
        /*  decode tag/length pair(s) */
        elmtLevel = 0;
        FOR_EACH_LIST_ELMT(tag, choice->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* choices are constructed */
            
            fprintf(hdr,"          if ( BDecTag(b, bytesDecoded, env) != ");
            
            if (tag->class == UNIV)
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %s))", classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %d))", classStr, formStr, tag->code);
            fprintf(hdr,"          {\n");
            fprintf(hdr,"              Asn1Error(\"%s::B%s: ERROR - wrong tag\\n\");\n", td->cppTypeDefInfo->className, r->decodeBaseName);
            fprintf(hdr,"              longjmp(env, %d);\n", longJmpValG--);
            fprintf(hdr,"          }\n");
            
            fprintf(hdr,"          extraLen%d = BDecLen(b, bytesDecoded, env);\n", ++elmtLevel);
        }
        
        /* decode identifying tag from choice body */
        fprintf(hdr,"          /*  CHOICEs are a special case - grab identifying tag */\n");
        fprintf(hdr,"          /*  this allows easier handling of nested CHOICEs */\n");
        fprintf(hdr,"          tag = BDecTag(b, bytesDecoded, env);\n");
        fprintf(hdr,"          elmtLen = BDecLen(b, bytesDecoded, env);\n");
        
        fprintf(hdr,"          B%s(b, tag, elmtLen, bytesDecoded, env);\n", 
                r->decodeContentBaseName);
        
        /* grab any EOCs that match redundant, indef lengths */
        for (i = elmtLevel; i > 0; i--)
        {
            fprintf(hdr,"          if (extraLen%d == INDEFINITE_LEN)\n", i);
            fprintf(hdr,"              BDecEoc(b, bytesDecoded, env);\n");
        }
        
        fprintf(hdr,"      }\n\n");
    }
    /* end of BDec inline */

    /* print content enc/dec protos */
    if (printEncodersG)
        fprintf(hdr,"      %s B%s(%s b);\n", lenTypeNameG, 
                r->encodeContentBaseName,bufTypeNameG);

    if (printDecodersG)
        fprintf(hdr,"      void   B%s(%s b, %s tag, %s elmtLen, %s& bytesDecoded, %s env);\n\n", r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG );


    PrintPduMemberFcns(src, hdr, r);

    /* close class definition */
    fprintf(hdr,"};\n\n\n");


    /* now write member function definitions to the src file */
    /* The member fcns that need defining are BerEncode/DecodeContent */

    /* BerEncode */
    if (printEncodersG)
    {
        fprintf(src,"%s\n", lenTypeNameG);
        fprintf(src,"%s::B%s(%s b)\n", td->cppTypeDefInfo->className,
                r->encodeContentBaseName, bufTypeNameG);
        
        fprintf(src,"{\n");
        
        /* print local vars */
        fprintf(src,"    %s l;\n",lenTypeNameG);
        fprintf(src,"    switch(%s)\n", r->choiceIdFieldName);
        fprintf(src,"    {\n");
        FOR_EACH_LIST_ELMT(e, choice->basicType->a.choice)
        {
            cpptri =  e->type->cppTypeRefInfo;
            
            fprintf(src, "       case(%s):\n", cpptri->choiceIdSymbol);
            
            varName = cpptri->fieldName;
            
            /* encode Eoc(s) if nec */
            PrintCppEocEncoders(src, td, e->type, "b");
            
            /* encode content */
            tmpTypeId = GetBuiltinType(e->type);
            if (tmpTypeId == BASICTYPE_ANYDEFINEDBY)
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                defByNamedType = e->type->basicType->a.anyDefinedBy->link;
                if (GetBuiltinType(defByNamedType->type) == BASICTYPE_OID)
                {
                    fprintf(src,"SetTypeByOid(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }
                else
                {
                    fprintf(src,"SetTypeByInt(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }

                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b);\n", r->encodeBaseName);
            }
            else if (tmpTypeId == BASICTYPE_ANY)
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"SetTypeBy???(???);\n");

                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b);\n", r->encodeBaseName);
            }
            else
            {
                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                fprintf(src,"B%s(b);\n", r->encodeContentBaseName);
            }


            /* encode tag(s) & len(s) */
            PrintCppTagAndLenEncodingCode(src, td, e->type, "l", "b");

            
            fprintf(src,"    break;\n\n");
        }
        fprintf(src,"    } /* end switch */\n");
        
        fprintf(src,"    return(l);\n");
        fprintf(src,"} /* %s::B%s */\n\n\n", td->cppTypeDefInfo->className,
                r->encodeContentBaseName);
    }
    /* end of BerEncodeContent method code */



    /* write BerDecodeContent to src */
    if (printDecodersG)
    {
        fprintf(src,"void\n");
        fprintf(src,"%s::B%s(%s b, %s tag, %s elmtLen0, %s& bytesDecoded, %s env)\n", td->cppTypeDefInfo->className, r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG);
        
        fprintf(src,"{\n");
        
        /* print local vars */
        /* count max number of extra length var nec 
         * by counting tag/len pairs on components of the CHOICE
         */
        varCount = 0;
        FOR_EACH_LIST_ELMT(e, choice->basicType->a.choice)
        {
            tmpVarCount = CppCountVariableLevels(e->type);
            if (tmpVarCount > varCount)
                varCount = tmpVarCount;
        }
        /* write extra length vars - remeber choice content
         * decoders are passed the 'key' tag so need one less 
         * than max var count.
         */
        for (i = 1; i < varCount; i++)
        {
            fprintf(src,"    %s elmtLen%d;\n", lenTypeNameG, i);
        }
        
        /* switch on given tag - choices always have the key tag decoded */
        fprintf(src,"    switch(tag)\n");
        fprintf(src,"    {\n");
        FOR_EACH_LIST_ELMT(e, choice->basicType->a.choice)
        {
            cpptri =  e->type->cppTypeRefInfo;
            
            tags = GetTags(e->type, &stoleChoiceTags);

            if (LIST_EMPTY(tags))
            {
                fprintf(src,"      // ANY Type?\n");
                fprintf(src,"      case(MAKE_TAG_ID( ?, ?, ?)):\n");
            }
            else
            {
                tag = (Tag*)FIRST_LIST_ELMT(tags);
                classStr = Class2ClassStr(tag->class);
                codeStr = Code2UnivCodeStr(tag->code);
                formStr = Form2FormStr(tag->form);
                
                if ( tag->class == UNIV)
                {
                    if (tag->form == ANY_FORM)
                    {
                        fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                classStr , Form2FormStr(PRIM) , codeStr);
                        fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                classStr , Form2FormStr(CONS) , codeStr);
                    }
                    else
                        fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                classStr , formStr , codeStr);
                }
                else
                {
                    if (tag->form == ANY_FORM)
                    {
                        fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                classStr , Form2FormStr(PRIM) , tag->code);
                        fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                classStr , Form2FormStr(CONS) , tag->code);
                    }
                    else
                        fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                classStr , formStr , tag->code);
                }
                
                
                /* now decode extra tags/length pairs */
                GListFirst(tags);
                GListNext(tags);
                elmtLevel = 0;
                if ( stoleChoiceTags)
                {
                    FOR_REST_LIST_ELMT(tag, tags)
                    {
                        classStr = Class2ClassStr(tag->class);
                        codeStr = Code2UnivCodeStr(tag->code);
                        formStr = Form2FormStr(tag->form);
                        
                        if ( tag->class == UNIV)
                        {
                            if (tag->form == ANY_FORM)
                            {
                                fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                        classStr , Form2FormStr(PRIM) , codeStr);
                                fprintf(src,"       case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                        classStr , Form2FormStr(CONS) , codeStr);
                            }
                            else
                                fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                        classStr , formStr , codeStr);
                        }
                        else
                        {
                            if (tag->form == ANY_FORM)
                            {
                                fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                        classStr , Form2FormStr(PRIM) , tag->code);
                                fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                        classStr , Form2FormStr(CONS) , tag->code);
                            }
                            else
                                fprintf(src,"      case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                        classStr , formStr , tag->code);
                        }
                    }
                }
                else /* didn't steal nested choice's tags */
                {
                    FOR_REST_LIST_ELMT(tag, tags)
                    {
                        classStr = Class2ClassStr(tag->class);
                        codeStr = Code2UnivCodeStr(tag->code);
                        formStr = Form2FormStr(tag->form);
                        
                        fprintf(src,"        tag = BDecTag(b, bytesDecoded, env);\n");
                        if (tag->form == ANY_FORM)
                        {
                            if (tag->class == UNIV)
                            {
                                fprintf(src,"        if ((tag != MAKE_TAG_ID( %s, %s, %s)) &&\n",  classStr, Form2FormStr(PRIM), codeStr);
                                fprintf(src,"            (tag != MAKE_TAG_ID( %s, %s, %s)))\n", classStr, Form2FormStr(CONS), codeStr);
                            }
                            else
                            {
                                fprintf(src,"        if ((tag != MAKE_TAG_ID( %s, %s, %d)) &&\n", classStr, Form2FormStr(PRIM), tag->code);
                                fprintf(src,"            (tag != MAKE_TAG_ID( %s, %s, %d)))\n", classStr, Form2FormStr(CONS), tag->code);
                            }
                            
                        }
                        else
                        {
                            if ( tag->class == UNIV)
                                fprintf(src,"        if (tag != MAKE_TAG_ID( %s, %s, %s))\n", classStr, formStr, codeStr);
                            else
                                fprintf(src,"        if (tag != MAKE_TAG_ID( %s, %s, %d))\n", classStr, formStr, tag->code);
                        }
                        
                        fprintf(src,"        {\n");
                        fprintf(src,"             Asn1Error(\"Unexpected Tag\\n\");\n");
                        fprintf(src,"             longjmp(env, %d);\n", longJmpValG--);
                        fprintf(src,"        }\n\n");
                        
                        fprintf(src,"        elmtLen%d = BDecLen (b, bytesDecoded, env);\n", ++elmtLevel);
                    }
                }
            }
            /*
             * if the choices element is another choice &&
             * we didn't steal its tags then we must grab 
             * the key tag out of the contained CHOICE
             */
            if (!stoleChoiceTags && 
                (GetBuiltinType(e->type) == BASICTYPE_CHOICE))
            {
                fprintf(src,"        tag = BDecTag(b, bytesDecoded, env);\n");
                fprintf(src,"        elmtLen%d = BDecLen (b, bytesDecoded, env);\n", ++elmtLevel);
            }
            
            
            varName = cpptri->fieldName;
            
            /* set choice id for to this elment */
            fprintf(src,"        %s = %s;\n",r->choiceIdFieldName, cpptri->choiceIdSymbol);
            
            /* alloc elmt if nec */
            if (cpptri->isPtr)
                fprintf(src,"        %s = new %s;\n", varName, cpptri->className);
            
            /* decode content */
            tmpTypeId = GetBuiltinType(e->type);
            if (tmpTypeId == BASICTYPE_ANYDEFINEDBY)
            {
                /*
                 * must check for another EOC for ANYs
                 * since the any decode routines decode
                 * their own first tag/len pair
                 */
                elmtLevel++;

                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                defByNamedType = e->type->basicType->a.anyDefinedBy->link;
                if (GetBuiltinType(defByNamedType->type) == BASICTYPE_OID)
                {
                    fprintf(src,"SetTypeByOid(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }
                else
                {
                    fprintf(src,"SetTypeByInt(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }

                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b, bytesDecoded, env);\n",  r->decodeBaseName);
            }
            else if (tmpTypeId == BASICTYPE_ANY)
            {
                /*
                 * must check for another EOC for ANYs
                 * since the any decode routines decode
                 * their own first tag/len pair
                 */
                elmtLevel++;

                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"SetTypeBy???(???);\n");

                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b, bytesDecoded, env);\n",  r->decodeBaseName);
            }
            else
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                fprintf(src,"B%s(b, tag, elmtLen%d, bytesDecoded, env);\n",  r->decodeContentBaseName, elmtLevel);
            }


            /* decode Eoc(s) */
            for (i = elmtLevel-1; i >= 0; i--)
            {
                fprintf(src,"        if (elmtLen%d == INDEFINITE_LEN)\n",i);
                fprintf(src,"            BDecEoc(b, bytesDecoded, env);\n");
            }
            
            fprintf(src,"        break;\n\n");
            FreeTags(tags);
        }
        
        fprintf(src,"      default:\n");
        fprintf(src,"        Asn1Error(\"ERROR - unexpected tag in CHOICE\\n\");\n");
        fprintf(src,"        longjmp(env, %d);\n",longJmpValG--);
        fprintf(src,"        break;\n");
        
        fprintf(src,"    } /* end switch */\n");
        fprintf(src,"} /* %s::B%s */\n\n\n", td->cppTypeDefInfo->className,
                r->decodeContentBaseName);  
    }
    /* end of code for printing BDecodeContent method */


    /* write code for printing */
    if (printPrintersG)
    {
        fprintf(src,"void\n%s::Print(ostream& os)\n",
                td->cppTypeDefInfo->className);
        fprintf(src,"{\n");
        /*    fprintf(src,"    os << \"{\" << endl;\n") */
        fprintf(src,"    switch(choiceId)\n");
        fprintf(src,"    {\n");
        FOR_EACH_LIST_ELMT(e, choice->basicType->a.choice)
        {
            
            fprintf(src,"      case(%s::%s):\n", td->cppTypeDefInfo->className,
                    e->type->cppTypeRefInfo->choiceIdSymbol);
            
            /* value notation so print the choice elmts field name */
            if (e->fieldName != NULL)
                fprintf(src,"        os << \"%s \";\n", e->fieldName);
            
            if (e->type->cppTypeRefInfo->isPtr)
                fprintf(src,"        os <<  *%s;\n", 
                        e->type->cppTypeRefInfo->fieldName);
            else
                fprintf(src,"        os << %s;\n",
                        e->type->cppTypeRefInfo->fieldName);
            
            fprintf(src,"        break;\n\n");
        }
        fprintf(src,"    } /* end of switch */\n");
        
        /*    fprintf(src,"    os << \"}\" << endl;\n") */
        fprintf(src,"}  /* %s::Print */\n\n\n", td->cppTypeDefInfo->className);
    }
    /* end of Print Method code */

} /* PrintCppChoiceDefCode */



static void 
PrintCppSeqDefCode PARAMS((src, hdr, mods, m, r,  td, parent, seq),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* seq)
{
    NamedType* e;
    char* classStr;
    char* formStr;
    char* codeStr;
    int tagLen, i;
    Tag* tag;
    TagList* tags;
    char* varName;
    CppTRI* cpptri;
    int elmtLevel;
    int varCount, tmpVarCount;
    int stoleChoiceTags;
    int inTailOptElmts;
    int hasOptElmts;
    enum BasicTypeChoiceId tmpTypeId;
    NamedType* defByNamedType;
    NamedType* tmpElmt;
    int allOpt;

    /* put class spec in hdr file */

    fprintf(hdr,"class %s %s\n", td->cppTypeDefInfo->className, baseClassesG);
    fprintf(hdr,"{\n");
    fprintf(hdr,"    public:\n");


    /* write out the sequence elmts */
    hasOptElmts = FALSE;
    FOR_EACH_LIST_ELMT(e, seq->basicType->a.sequence)
    {
        fprintf(hdr, "      ");
        PrintCppType(src, hdr, mods, m, r, td, seq, e->type);
        fprintf(hdr, " %s;\n", e->type->cppTypeRefInfo->fieldName);
        if (e->type->optional || (e->type->defaultVal != NULL))
            hasOptElmts = TRUE;
    }

    fprintf(hdr,"\n");

    /* do constructor to init the opt elmts to NULL */
    if (hasOptElmts)
    {
        fprintf(hdr,"      %s()\n", td->cppTypeDefInfo->className);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          /* init optional/default elements to NULL */\n");
        FOR_EACH_LIST_ELMT(e, seq->basicType->a.sequence)
        {
            if ((e->type->cppTypeRefInfo->isPtr) && 
                ((e->type->optional) || (e->type->defaultVal != NULL)))
            {
                fprintf(hdr,"          %s = NULL;\n", 
                        e->type->cppTypeRefInfo->fieldName);
            }
        }

        fprintf(hdr,"      }\n\n");
    }
    else
        PrintNoArgConstructor(hdr, r, td);


    /* write proto of friend for ostream printing */
    if (printPrintersG)
        fprintf(hdr,"      void Print(ostream& os);\n");


    /* print clone routine for ANY mgmt */
    PrintCloneMethod(hdr, td);


    /* print Methods prototypes/inlines */

    /* do BEnc inline */
    if (printEncodersG)
    {
        fprintf(hdr,"      %s B%s(%s b)\n", lenTypeNameG, 
                r->encodeBaseName, bufTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s l;\n", lenTypeNameG);
        fprintf(hdr,"          l = B%s(b);\n",r->encodeContentBaseName);
        
        /* encode each tag/len pair if any */
        FOR_EACH_LIST_ELMT_RVS(tag, seq->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* seq's are constructed */
            tagLen = TagByteLen(tag->code);
            
            fprintf(hdr,"          l += BEncConsLen(b, l);\n");
            
            if (tag->class == UNIV)
                fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %s);\n",
                        tagLen, classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %d);\n",
                        tagLen, classStr, formStr, tag->code);
        }
        fprintf(hdr,"          return(l);\n");
        fprintf(hdr,"      }\n\n");
    }
    /* end of BEnc inline */


    /* Do BDec inline */
    if (printDecodersG)
    {
        fprintf(hdr,"      void B%s(%s b, %s& bytesDecoded, %s env)\n", 
                r->decodeBaseName, bufTypeNameG, lenTypeNameG, envTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s tag;\n", tagTypeNameG);
        
        /* print extra locals for redundant lengths */
        for (i = 1; (seq->tags != NULL) && (i <= LIST_COUNT(seq->tags)); i++)
        {
            fprintf(hdr,"          %s elmtLen%d;\n", lenTypeNameG, i);
        }
        fprintf(hdr,"\n");
        
        /*  decode tag/length pair(s) */
        elmtLevel = 0;
        FOR_EACH_LIST_ELMT(tag, seq->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* seqs are constructed */
            
            fprintf(hdr,"          if ( (tag = BDecTag(b, bytesDecoded, env)) != ");
            
            if (tag->class == UNIV)
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %s))\n", classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %d))\n", classStr, formStr, tag->code);
            fprintf(hdr,"          {\n");
            fprintf(hdr,"              Asn1Error(\"%s::B%s: ERROR - wrong tag\\n\");\n", td->cppTypeDefInfo->className, r->decodeBaseName);
            fprintf(hdr,"              longjmp(env, %d);\n", longJmpValG--);
            fprintf(hdr,"          }\n");
            
            fprintf(hdr,"          elmtLen%d = BDecLen(b, bytesDecoded, env);\n", ++elmtLevel);
        }
        
        fprintf(hdr,"          B%s(b, tag, elmtLen%d, bytesDecoded, env);\n", 
                r->decodeContentBaseName, elmtLevel);
        
        /* grab any EOCs that match redundant, indef lengths */
        for (i = elmtLevel-1; i > 0; i--)
        {
            fprintf(hdr,"          if (elmtLen%d == INDEFINITE_LEN)\n", i);
            fprintf(hdr,"              BDecEoc(b, bytesDecoded, env);\n");
        }
        
        fprintf(hdr,"      }\n\n");
    }
    /* end of BDec inline */



    /* print content enc/dec protos */
    if (printEncodersG)
        fprintf(hdr,"      %s B%s(%s b);\n", lenTypeNameG, 
                r->encodeContentBaseName,bufTypeNameG);

    if (printDecodersG)
        fprintf(hdr,"      void   B%s(%s b, %s tag, %s elmtLen, %s& bytesDecoded, %s env);\n\n", r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG );


    PrintPduMemberFcns(src, hdr, r);

    /* close class definition */
    fprintf(hdr,"};\n\n\n");


    /* now write member function definitions to the src file */
    /* The member fcns that need defining are BerEncode/DecodeContent */

    /* BerEncode method code */
    if (printEncodersG)
    {
        fprintf(src,"%s\n", lenTypeNameG);
        fprintf(src,"%s::B%s(%s b)\n", td->cppTypeDefInfo->className,
                r->encodeContentBaseName, bufTypeNameG);
        
        fprintf(src,"{\n");
        
        /* print local vars */
        fprintf(src,"    %s totalLen = 0;\n", lenTypeNameG);
        fprintf(src,"    %s l;\n\n", lenTypeNameG);
        
        FOR_EACH_LIST_ELMT_RVS(e, seq->basicType->a.sequence)
        {
            cpptri =  e->type->cppTypeRefInfo;
            
            varName = cpptri->fieldName;
            
            /* print optional test if nec*/
            if (e->type->optional || (e->type->defaultVal != NULL))
                fprintf(src, "    if (%s(%s))\n    {\n", cpptri->optTestRoutineName, varName);         

            /* encode Eoc(s) if nec */
            PrintCppEocEncoders(src, td, e->type, "b");
            
            /* encode content */
            tmpTypeId = GetBuiltinType(e->type);
            if (tmpTypeId == BASICTYPE_ANYDEFINEDBY)
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                defByNamedType = e->type->basicType->a.anyDefinedBy->link;
                if (GetBuiltinType(defByNamedType->type) == BASICTYPE_OID)
                {
                    fprintf(src,"SetTypeByOid(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }
                else
                {
                    fprintf(src,"SetTypeByInt(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }

                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b);\n", r->encodeBaseName);
            }
            else if (tmpTypeId == BASICTYPE_ANY)
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"SetTypeBy???(???);\n");

                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b);\n", r->encodeBaseName);
            }
            else
            {
                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                fprintf(src,"B%s(b);\n", r->encodeContentBaseName);
            }


            /* encode tag(s) & len(s) */
            PrintCppTagAndLenEncodingCode(src, td, e->type, "l", "b");

            
            fprintf(src,"    totalLen += l;\n");
            
            /* close optional test if nec */
            if (e->type->optional || (e->type->defaultVal != NULL))
                fprintf(src, "    }\n\n");
            else
                fprintf(src, "\n");
        }
        fprintf(src,"    return(totalLen);\n");
        fprintf(src,"} /* %s::B%s */\n\n\n", td->cppTypeDefInfo->className,
                r->encodeContentBaseName);
    }
    /* end of BerEncodeContent method printing code */



    /* write BerDecodeContent to src */
    if (printDecodersG)
    {
        fprintf(src,"void\n");
        fprintf(src,"%s::B%s(%s b, %s tag0, %s elmtLen0, %s& bytesDecoded, %s env)\n", td->cppTypeDefInfo->className, r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG);
        
        fprintf(src,"{\n");
        
        /* print local vars */
        fprintf(src,"    %s tag1;\n", tagTypeNameG);
        fprintf(src,"    %s seqBytesDecoded = 0;\n", lenTypeNameG);
        /* count max number of extra length var nec */
        varCount = 0;
        FOR_EACH_LIST_ELMT(e, seq->basicType->a.sequence)
        {
            tmpVarCount = CppCountVariableLevels(e->type);

            if (tmpVarCount > varCount)
                varCount = tmpVarCount;
        }
        /* write extra length vars */
        for (i = 1; i <= varCount; i++)
        {
            fprintf(src,"    %s elmtLen%d;\n", lenTypeNameG, i);
        }
        
        /* handle empty seq */ 
        if ((seq->basicType->a.sequence == NULL) || LIST_EMPTY(seq->basicType->a.sequence))
        {
            fprintf(src,"    if (elmtLen0 == INDEFINITE_LEN)\n");
            fprintf(src,"        BDecEoc(b, bytesDecoded, env);\n");
            fprintf(src,"    else if (elmtLen0 != 0)\n");
            fprintf(src,"    {\n");
            fprintf(src,"         Asn1Error(\"Expected an empty sequence\\n\");\n");
            fprintf(src,"         longjmp(env, %d);\n",longJmpValG--);
            fprintf(src,"    }\n");

/*
            forget about posssible extensions to the type
            fprintf(src,"    {\n");
            fprintf(src,"        tag1 = BDecTag(b, bytesDecoded, env);\n\n");
            fprintf(src,"        if ( tag1 == EOC_TAG_ID)\n");
            fprintf(src,"            BDEC_2ND_EOC_OCTET(b, bytesDecoded, env)\n");
            fprintf(src,"        else\n");

            fprintf(src,"            BerDiscardElmt(b, bytesDecoded, env);\n\n");
            fprintf(src,"    }\n");
            fprintf(src,"    else\n");
            fprintf(src,"    {\n");
            fprintf(src,"        BufSkip(b, elmtLen0);\n");
            fprintf(src,"        bytesDecoded%d += elmtLen0;\n");
            fprintf(src,"    }\n");
*/
            
        }
        else
        {
            
            /*  check if all elmts are optional */
            GListFirst(seq->basicType->a.sequence); 
            inTailOptElmts = IsTailOptional(seq->basicType->a.sequence);
            e = (NamedType*)FIRST_LIST_ELMT(seq->basicType->a.sequence);

            tmpTypeId = GetBuiltinType(e->type);

            if (!inTailOptElmts)
            {
                if (((tmpTypeId == BASICTYPE_ANY) ||
                     (tmpTypeId == BASICTYPE_ANYDEFINEDBY)) &&
                    (CountTags(e->type) == 0))
                {
                    if ((e->type->optional) && 
                        (e != (NamedType*)LAST_LIST_ELMT(seq->basicType->a.sequence)))
                        fprintf(src,"<untagged optional ANY - you must fix this>\n");
                }
                else
                    fprintf(src, "    tag1 = BDecTag(b, seqBytesDecoded, env);\n\n");
            }
            else
            {
                fprintf(src, "    if (elmtLen0 == 0)\n");
                fprintf(src, "        return;\n");
                fprintf(src, "    else\n");
                fprintf(src, "    {\n");
                if (((tmpTypeId == BASICTYPE_ANY) ||
                     (tmpTypeId == BASICTYPE_ANYDEFINEDBY)) &&
                    (CountTags(e->type) == 0))
                {
                    if ((e->type->optional) &&
                        (e != (NamedType*)LAST_LIST_ELMT(seq->basicType->a.sequence)))
                        fprintf(src,"<untagged optional ANY - you must fix this>\n");
                }
                else
                    fprintf(src, "        tag1 = BDecTag(b, seqBytesDecoded, env);\n\n");
                fprintf(src,"         if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))\n");
                fprintf(src, "        {\n");
                fprintf(src, "            BDEC_2ND_EOC_OCTET(b, seqBytesDecoded, env)\n");
                fprintf(src, "            bytesDecoded += seqBytesDecoded;\n");
                fprintf(src, "            return;\n");
                fprintf(src, "        }\n");
                fprintf(src, "    }\n\n");
            }
            
            
            FOR_EACH_LIST_ELMT(e, seq->basicType->a.sequence)
            {
                cpptri =  e->type->cppTypeRefInfo;
                elmtLevel = 0;
                
                tags = GetTags(e->type, &stoleChoiceTags);
                
                /*            if (inTailOptElmts)
                              fprintf(src," (!seqDone) && ");
                              */
                if (LIST_EMPTY(tags))
                    fprintf(src,"    // ANY type\n");
                else
                {
                    tag = (Tag*)FIRST_LIST_ELMT(tags);
                    classStr = Class2ClassStr(tag->class);
                    codeStr = Code2UnivCodeStr(tag->code);
                    formStr = Form2FormStr(tag->form);

                    fprintf(src,"    if (");
                    if ( tag->class == UNIV)
                    {
                        if (tag->form == ANY_FORM)
                        {
                            fprintf(src,"( tag1 == MAKE_TAG_ID( %s, %s, %s)) ||\n", classStr , Form2FormStr(PRIM) , codeStr);
                            fprintf(src,"        ( tag1 == MAKE_TAG_ID( %s, %s, %s))", classStr , Form2FormStr(CONS) , codeStr);
                        }
                        else
                            fprintf(src,"( tag1 == MAKE_TAG_ID( %s, %s, %s))", classStr , formStr, codeStr);
                    }
                    else
                    {
                        if (tag->form == ANY_FORM)
                        {
                            fprintf(src,"( tag1 == MAKE_TAG_ID( %s, %s, %d)) ||\n", classStr , Form2FormStr(PRIM), tag->code);
                            fprintf(src,"        ( tag1 == MAKE_TAG_ID( %s, %s, %d))", classStr , Form2FormStr(CONS) , tag->code);
                        }
                        else
                            fprintf(src,"( tag1 == MAKE_TAG_ID( %s, %s, %d))", classStr , formStr , tag->code);
                    }

                
                    /* now decode extra tags/length pairs */
                    GListFirst(tags);
                    GListNext(tags);
                    if ( stoleChoiceTags)
                    {
                        FOR_REST_LIST_ELMT(tag, tags)
                        {
                            fprintf(src," ||\n");
                            classStr = Class2ClassStr(tag->class);
                            codeStr = Code2UnivCodeStr(tag->code);
                            formStr = Form2FormStr(tag->form);
                            
                            if ( tag->class == UNIV)
                            {
                                if (tag->form == ANY_FORM)
                                {
                                    fprintf(src,"         ( tag1 == MAKE_TAG_ID( %s, %s, %s)) ||\n", classStr , Form2FormStr(PRIM) , codeStr);
                                    fprintf(src,"         ( tag1 == MAKE_TAG_ID( %s, %s, %s))",
                                            classStr , Form2FormStr(CONS) , codeStr);
                                }
                                else
                                    fprintf(src,"         ( tag1 == MAKE_TAG_ID( %s, %s, %s))",
                                            classStr , formStr , codeStr);
                            }
                            else
                            {
                                if (tag->form == ANY_FORM)
                                {
                                    fprintf(src,"        ( tag1 == MAKE_TAG_ID( %s, %s, %d)) ||\n", classStr , Form2FormStr(PRIM) , tag->code);
                                    fprintf(src,"    ( tag1 == MAKE_TAG_ID( %s, %s, %d))",                                 classStr , Form2FormStr(CONS), tag->code);
                                }
                                else
                                    fprintf(src,"        ( tag1 == MAKE_TAG_ID( %s, %s, %d))",
                                            classStr , formStr , tag->code);
                            }
                        }
                        fprintf(src,")\n");
                        fprintf(src, "    {\n");
                        fprintf(src, "        elmtLen%d = BDecLen (b, seqBytesDecoded, env);\n", ++elmtLevel);
                    }
                    
                    else /* didn't steal nested choice's tags */
                    {
                        fprintf(src,")\n");
                        fprintf(src, "    {\n");
                        fprintf(src, "        elmtLen%d = BDecLen(b, seqBytesDecoded, env);\n", ++elmtLevel);
                        
                        FOR_REST_LIST_ELMT(tag, tags)
                        {
                            classStr = Class2ClassStr(tag->class);
                            codeStr = Code2UnivCodeStr(tag->code);
                            formStr = Form2FormStr(tag->form);
                            
                            fprintf(src, "        tag1 = BDecTag(b, seqBytesDecoded, env);\n\n");
                            if ( tag->class == UNIV)
                            {
                                if (tag->form == ANY_FORM)
                                {
                                    fprintf(src,"        if (( tag1 != MAKE_TAG_ID( %s, %s, %s)) &&\n", classStr , Form2FormStr(PRIM) , codeStr);
                                    fprintf(src,"           ( tag1 != MAKE_TAG_ID( %s, %s, %s)))\n", classStr , Form2FormStr(CONS) , codeStr);
                                }
                                else
                                    fprintf(src,"    if ( tag1 != MAKE_TAG_ID( %s, %s, %s))\n", classStr , formStr , codeStr);
                            }
                            else
                            {
                                if (tag->form == ANY_FORM)
                                {
                                    fprintf(src,"        if (( tag1 != MAKE_TAG_ID( %s, %s, %d)) &&\n",  classStr , Form2FormStr(PRIM) , tag->code);
                                    fprintf(src,"        ( tag1 != MAKE_TAG_ID( %s, %s, %d)))\n", classStr , Form2FormStr(CONS) , tag->code);
                                }
                                else
                                    fprintf(src,"       if ( tag1 != MAKE_TAG_ID( %s, %s, %d))\n", classStr , formStr , tag->code);
                            }
                            
                            fprintf(src,"        {\n");
                            fprintf(src,"             Asn1Error(\"Unexpected Tag\\n\");\n");
                            fprintf(src,"             longjmp(env, %d);\n",longJmpValG--);
                            fprintf(src,"        }\n\n");
                            fprintf(src,"        elmtLen%d = BDecLen (b, seqBytesDecoded, env);\n", ++elmtLevel);
                        }
                    }
                }
                /*
                 * if this seq element is CHOICE &&
                 * we didn't steal its tags then we must grab 
                 * the key tag out of the contained CHOICE
                 */
                if (!stoleChoiceTags && 
                    (GetBuiltinType(e->type) == BASICTYPE_CHOICE))
                {
                    fprintf(src,"        tag1 = BDecTag(b, seqBytesDecoded, env);\n");
                    fprintf(src,"        elmtLen%d = BDecLen (b, seqBytesDecoded, env);\n", ++elmtLevel);
                }
                              

                
                varName = cpptri->fieldName;

                /* decode content */
                if (cpptri->isPtr)
                    fprintf(src,"        %s = new %s;\n", varName, cpptri->className);
                

                /* decode content */
                tmpTypeId = GetBuiltinType(e->type);
                if (tmpTypeId == BASICTYPE_ANYDEFINEDBY)
                {
                    /*
                     * must check for another EOC for ANYs
                     * since the any decode routines decode
                     * their own first tag/len pair
                     */
                    elmtLevel++;
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    
                    defByNamedType = e->type->basicType->a.anyDefinedBy->link;
                    if (GetBuiltinType(defByNamedType->type) == BASICTYPE_OID)
                    {
                        fprintf(src,"SetTypeByOid(");
                        if (defByNamedType->type->cppTypeRefInfo->isPtr)
                            fprintf(src,"*");
                        fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                    }
                    else
                    {
                        fprintf(src,"SetTypeByInt(");
                        if (defByNamedType->type->cppTypeRefInfo->isPtr)
                            fprintf(src,"*");
                        fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                    }
                    
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    fprintf(src,"B%s(b, seqBytesDecoded, env);\n",  r->decodeBaseName);
                }
                else if (tmpTypeId == BASICTYPE_ANY)
                {
                    /*
                     * must check for another EOC for ANYs
                     * since the any decode routines decode
                     * their own first tag/len pair
                     */
                    elmtLevel++;

                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    fprintf(src,"SetTypeBy???(???);\n");
                    
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    fprintf(src,"B%s(b, seqBytesDecoded, env);\n",  r->decodeBaseName);
                }
                else
                {
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    
                    fprintf(src,"B%s(b, tag1, elmtLen%d, seqBytesDecoded, env);\n",  r->decodeContentBaseName, elmtLevel);
                }

                /* decode Eoc(s) */
                for (i = elmtLevel-1; i > 0; i--)
                {
                    fprintf(src,"        if (elmtLen%d == INDEFINITE_LEN)\n", i);
                    fprintf(src,"            BDecEoc(b, seqBytesDecoded, env);\n\n");
                }
                
                /*
                 * print code for getting the next tag 
                 */
                inTailOptElmts = RestAreTailOptional(seq->basicType->a.sequence);
                if  (e != (NamedType*)LAST_LIST_ELMT(seq->basicType->a.sequence))
                {
                    tmpElmt = (NamedType*)NEXT_LIST_ELMT(seq->basicType->a.sequence);
                    tmpTypeId = GetBuiltinType(tmpElmt->type);
                    if (!inTailOptElmts) 
                    {
                        if (((tmpTypeId == BASICTYPE_ANY) ||
                             (tmpTypeId == BASICTYPE_ANYDEFINEDBY)) &&
                            (CountTags(tmpElmt->type) == 0))
                        {
                            /* don't get a tag since ANY's decode their own */
                            if ((e->type->optional) || 
                                ((tmpElmt->type->optional) && 
                                 (tmpElmt != (NamedType*)LAST_LIST_ELMT(seq->basicType->a.sequence))))
                                /* let this cause a compile error in the generated code */
                                fprintf(src,"  <problems with untagged ANY that is optional or follows an optional sequence element - you must fix this>\n");
                        }
                        else
                            fprintf(src, "        tag1 = BDecTag(b, seqBytesDecoded, env);\n");
                    }
                    else
                    {
                        fprintf(src, "        if ( seqBytesDecoded == elmtLen0)\n");
                        fprintf(src, "        {\n");
                        fprintf(src, "            bytesDecoded += seqBytesDecoded;\n");
                        fprintf(src, "            return;\n");
                        fprintf(src, "        }\n");
                        fprintf(src, "        else\n");
                        fprintf(src, "        {\n");

                        if (((tmpTypeId == BASICTYPE_ANY) ||
                             (tmpTypeId == BASICTYPE_ANYDEFINEDBY)) &&
                            (CountTags(tmpElmt->type) == 0))
                        {
                            /* don't get a tag since ANY's decode their own */
                            if ((e->type->optional) || 
                                ((tmpElmt->type->optional) && 
                                 (tmpElmt != (NamedType*)LAST_LIST_ELMT(seq->basicType->a.sequence))))
                            {
                                /*
                                 * let this cause a compile error in
                                 * the generated code
                                 */
                                fprintf(src,"  <problems with untagged ANY that is optional or follows an optional sequence element - you must fix this>\n");
                            }
                            fprintf(src, "            tag1 = b.PeekByte();\n\n");
                            fprintf(src, "            if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))\n");
                            fprintf(src, "            {\n");
                            fprintf(src, "                BDecEoc(b, seqBytesDecoded, env);\n\n");
                            fprintf(src, "                bytesDecoded += seqBytesDecoded;\n");
                            fprintf(src, "                return;\n");
                            fprintf(src, "            }\n");

                        }
                        else
                        {
                            fprintf(src, "            tag1 = BDecTag(b, seqBytesDecoded, env);\n\n");
                            fprintf(src, "            if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))\n");
                            fprintf(src, "            {\n");
                            fprintf(src, "                BDEC_2ND_EOC_OCTET(b, seqBytesDecoded, env)\n");
                            fprintf(src, "                bytesDecoded += seqBytesDecoded;\n");
                            fprintf(src, "                return;\n");
                            fprintf(src, "            }\n");
                        }
                        fprintf(src, "        }\n");
                        
                    }
                }
            
            
                /*
                 * close tag check if (if there is one) and
                 * print else clause to handle missing non-optional elmt
                 * errors
                 */
                tmpTypeId = GetBuiltinType(e->type);
                if (((tmpTypeId == BASICTYPE_ANYDEFINEDBY) ||
                     (tmpTypeId == BASICTYPE_ANY)) &&
                    (CountTags(e->type) == 0))
                {
                    /* do nothing - no tag check if stmt to close */
                    fprintf(src,"\n\n");
                }
                else if ((!e->type->optional) && !(e->type->defaultVal != NULL))
                {
                    fprintf(src,"    }\n"); /* end of tag check if */
                    fprintf(src,"    else\n");
                    fprintf(src,"    {\n");
                    fprintf(src,"        Asn1Error(\"ERROR - SEQUENCE is missing non-optional elmt.\\n\");\n");
                    fprintf(src,"        longjmp(env, %d);\n",longJmpValG--);
                    fprintf(src,"    }\n\n");
                }
                else
                    fprintf(src,"    }\n\n"); /* end of tag check if */

                FreeTags(tags);
            }

            /* for last elmt only */
            fprintf(src, "    bytesDecoded += seqBytesDecoded;\n");
            fprintf(src, "    if ( elmtLen0 == INDEFINITE_LEN )\n");
            fprintf(src, "    {\n");
            fprintf(src, "        BDecEoc(b, bytesDecoded, env);\n");
            fprintf(src, "        return;\n");
            fprintf(src, "    }\n");
            fprintf(src, "    else if (seqBytesDecoded != elmtLen0)\n");
            fprintf(src, "    {\n");
            fprintf(src, "        Asn1Error(\"ERROR - Length discrepancy on sequence.\\n\");\n");
            fprintf(src, "        longjmp(env, %d);\n",longJmpValG--);
            fprintf(src, "    }\n");
            fprintf(src, "    else\n");
            fprintf(src, "        return;\n");

        }  /* end of non-empty set else clause */
        
        fprintf(src,"} /* %s::B%s */\n\n", td->cppTypeDefInfo->className,
                r->decodeContentBaseName);  
    }
    /* end of code for printing ber decode content method */



    /* write code for printing */
    if (printPrintersG)
    {
        fprintf(src,"void\n%s::Print(ostream& os)\n",
                td->cppTypeDefInfo->className);
        fprintf(src,"{\n");
        allOpt = AllElmtsOptional(seq->basicType->a.sequence);
        if (allOpt)
            fprintf(src,"    int nonePrinted = TRUE;\n");
        fprintf(src,"    os << \"{  -- SEQUENCE --\" << endl;\n");
        fprintf(src,"    indentG += stdIndentG;\n");

        FOR_EACH_LIST_ELMT(e, seq->basicType->a.sequence)
        {
            inTailOptElmts = IsTailOptional(seq->basicType->a.sequence);
            if (e->type->optional || (e->type->defaultVal != NULL))
            {
                fprintf(src,"    if (%s(%s))\n", cpptri->optTestRoutineName,
                        e->type->cppTypeRefInfo->fieldName);
                fprintf(src,"    {\n");
            }

            if (allOpt)
            {
                if (e != FIRST_LIST_ELMT(seq->basicType->a.sequence))
                {
                    fprintf(src, "    if (!nonePrinted)\n");
                    fprintf(src, "        os << \",\" << endl;\n");
                }
                fprintf(src, "    nonePrinted = FALSE;\n");
            }
            else if (inTailOptElmts) /* cannot be first elmt ow allOpt is true */
                fprintf(src, "    os << \",\"<< endl;\n");

            fprintf(src,"    Indent(os, indentG);\n");
            
            if (e->fieldName != NULL)
                fprintf(src,"    os << \"%s \";\n", e->fieldName);
            
            if (e->type->cppTypeRefInfo->isPtr)
                fprintf(src,"    os <<  *%s;\n",
                        e->type->cppTypeRefInfo->fieldName);
            else
                fprintf(src,"    os << %s;\n",
                        e->type->cppTypeRefInfo->fieldName);

            if ((e != LAST_LIST_ELMT(seq->basicType->a.sequence)) &&
                (!inTailOptElmts) &&
                (!NextIsTailOptional(seq->basicType->a.sequence)))
                fprintf(src,"    os << \",\" << endl;\n");

            if (e->type->optional || (e->type->defaultVal != NULL))
            {
                fprintf(src,"    }\n");
            }
            if (e == LAST_LIST_ELMT(seq->basicType->a.sequence))
                fprintf(src,"    os << endl;\n");
        }
        
        fprintf(src,"    indentG -= stdIndentG;\n");
        fprintf(src,"    Indent(os, indentG);\n");
        fprintf(src,"    os << \"}\";\n") ;
        fprintf(src,"}  /* %s::Print */\n\n\n", td->cppTypeDefInfo->className);
    }
    /* end of print method code printer */

} /* PrintCppSeqDefCode */



static void 
PrintCppSetDefCode PARAMS((src, hdr, mods, m, r, td, parent, set),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* set)
{
    NamedType* e;
    char* classStr;
    char* formStr;
    char* codeStr;
    int tagLen, i;
    Tag* tag;
    TagList* tags;
    char* varName;
    CppTRI* cpptri;
    int elmtLevel;
    int varCount, tmpVarCount;
    int stoleChoiceTags;
    int inTailOptElmts;
    int hasOptElmts;
    int mandatoryElmtCount;
    enum BasicTypeChoiceId tmpTypeId;
    NamedType* defByNamedType;
    int allOpt;

    /* put class spec in hdr file */

    fprintf(hdr,"class %s %s\n", td->cppTypeDefInfo->className, baseClassesG);
    fprintf(hdr,"{\n");
    fprintf(hdr,"    public:\n");


    /* write out the sets elmts */
    hasOptElmts = FALSE;
    FOR_EACH_LIST_ELMT(e, set->basicType->a.set)
    {
        fprintf(hdr, "      ");
        PrintCppType(src, hdr, mods, m, r, td, set, e->type);
        fprintf(hdr, " %s;\n", e->type->cppTypeRefInfo->fieldName);
        if (e->type->optional || (e->type->defaultVal != NULL))
            hasOptElmts = TRUE;
    }

    fprintf(hdr,"\n");

    /* do constructor to init the opt elmts to NULL */
    if (hasOptElmts)
    {
        fprintf(hdr,"      %s()\n", td->cppTypeDefInfo->className);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          /* init optional/default elements to NULL */\n");
        FOR_EACH_LIST_ELMT(e, set->basicType->a.set)
        {
            if ((e->type->cppTypeRefInfo->isPtr) && 
                ((e->type->optional) || (e->type->defaultVal != NULL)))
            {
                fprintf(hdr,"          %s = NULL;\n", 
                        e->type->cppTypeRefInfo->fieldName);
            }
        }

        fprintf(hdr,"      }\n\n");
    }
    else
        PrintNoArgConstructor(hdr, r, td);


    /* write proto of friend for ostream printing */
    if (printPrintersG)
        fprintf(hdr,"      void Print(ostream& os);\n");

    /* print clone routine for ANY mgmt */
    PrintCloneMethod(hdr, td);

    /* print Methods prototypes/inlines */

    /* do BerEncode inline */
    if (printEncodersG)
    {
        fprintf(hdr,"      %s B%s(%s b)\n", lenTypeNameG, 
                r->encodeBaseName, bufTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s l;\n", lenTypeNameG);
        fprintf(hdr,"          l = B%s(b);\n",r->encodeContentBaseName);
        
        /* encode each tag/len pair if any */
        FOR_EACH_LIST_ELMT_RVS(tag, set->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* set's are constructed */
            tagLen = TagByteLen(tag->code);
            
            fprintf(hdr,"          l += BEncConsLen(b, l);\n");
            
            if (tag->class == UNIV)
                fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %s);\n",
                        tagLen, classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %d);\n",
                        tagLen, classStr, formStr, tag->code);
        }
        fprintf(hdr,"          return(l);\n");
        fprintf(hdr,"      }\n\n");
    }
    /* end of BerEncode inline */


    /* Do BerDecode inline */
    if (printDecodersG)
    {
        fprintf(hdr,"      void B%s(%s b, %s& bytesDecoded, %s env)\n", 
                r->decodeBaseName, bufTypeNameG, lenTypeNameG, envTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s tag;\n", tagTypeNameG);
        
        /* print extra locals for redundant lengths */
        for (i = 1; (set->tags != NULL) && (i <= LIST_COUNT(set->tags)); i++)
        {
            fprintf(hdr,"          %s elmtLen%d;\n", lenTypeNameG, i);
        }
        fprintf(hdr,"\n");
        
        /*  decode tag/length pair(s) */
        elmtLevel = 0;
        FOR_EACH_LIST_ELMT(tag, set->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* sets are constructed */
            
            fprintf(hdr,"          if ( (tag = BDecTag(b, bytesDecoded, env)) !=\n");
            
            if (tag->class == UNIV)
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %s))\n", classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %d))\n", classStr, formStr, tag->code);
            fprintf(hdr,"          {\n");
            fprintf(hdr,"              Asn1Error(\"%s::B%s: ERROR - wrong tag\\n\");\n", td->cppTypeDefInfo->className, r->decodeBaseName);
            fprintf(hdr,"              longjmp(env, %d);\n", longJmpValG--);
            fprintf(hdr,"          }\n");
            
            fprintf(hdr,"          elmtLen%d = BDecLen(b, bytesDecoded, env);\n", ++elmtLevel);
        }
        
        fprintf(hdr,"          B%s(b, tag, elmtLen%d, bytesDecoded, env);\n", 
                r->decodeContentBaseName, i-1);
        
        /* grab any EOCs that match redundant, indef lengths */
        for (i = elmtLevel-1; i > 0; i--)
        {
            fprintf(hdr,"          if (elmtLen%d == INDEFINITE_LEN)\n", i);
            fprintf(hdr,"              BDecEoc(b, bytesDecoded, env);\n");
        }
        
        fprintf(hdr,"      }\n\n");
    }
    /* end of BerDecode inline */



    /* print content enc/dec protos */
    if (printEncodersG)
        fprintf(hdr,"      %s B%s(%s b);\n", lenTypeNameG, 
                r->encodeContentBaseName,bufTypeNameG);

    if (printDecodersG)
        fprintf(hdr,"      void   B%s(%s b, %s tag, %s elmtLen, %s& bytesDecoded, %s env);\n\n", r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG );


    PrintPduMemberFcns(src, hdr, r);

    /* close class definition */
    fprintf(hdr,"};\n\n\n");


    /* now write member function definitions to the src file */
    /* The member fcns that need defining are BerEncode/DecodeContent */

    /* BerEncode */
    if (printEncodersG)
    {
        fprintf(src,"%s\n", lenTypeNameG);
        fprintf(src,"%s::B%s(%s b)\n", td->cppTypeDefInfo->className,
                r->encodeContentBaseName, bufTypeNameG);
        
        fprintf(src,"{\n");
        
        /* print local vars */
        fprintf(src,"    %s totalLen = 0;\n", lenTypeNameG);
        fprintf(src,"    %s l;\n\n", lenTypeNameG);
        
        FOR_EACH_LIST_ELMT_RVS(e, set->basicType->a.set)
        {
            cpptri =  e->type->cppTypeRefInfo;
            
            varName = cpptri->fieldName;
            
            /* print optional test if nec*/
            if (e->type->optional || (e->type->defaultVal != NULL))
                fprintf(src, "    if (%s(%s))\n    {\n", cpptri->optTestRoutineName, varName);         
            
            /* encode Eoc(s) if nec */
            PrintCppEocEncoders(src, td, e->type, "b");
            
            /* encode content */
            tmpTypeId = GetBuiltinType(e->type);
            if (tmpTypeId == BASICTYPE_ANYDEFINEDBY)
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                defByNamedType = e->type->basicType->a.anyDefinedBy->link;
                if (GetBuiltinType(defByNamedType->type) == BASICTYPE_OID)
                {
                    fprintf(src,"SetTypeByOid(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }
                else
                {
                    fprintf(src,"SetTypeByInt(");
                    if (defByNamedType->type->cppTypeRefInfo->isPtr)
                        fprintf(src,"*");
                    fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                }

                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b);\n", r->encodeBaseName);
            }
            else if (tmpTypeId == BASICTYPE_ANY)
            {
                fprintf(src,"        %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"SetTypeBy???(???);\n");

                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");
                fprintf(src,"B%s(b);\n", r->encodeBaseName);
            }
            else
            {
                fprintf(src,"    l = %s", varName);
                if (cpptri->isPtr)
                    fprintf(src,"->");
                else
                    fprintf(src,".");

                fprintf(src,"B%s(b);\n", r->encodeContentBaseName);
            }
            
            /* encode tag(s) & len(s) */
            PrintCppTagAndLenEncodingCode(src, td, e->type, "l", "b");
            
            fprintf(src,"    totalLen += l;\n");
            
            /* close optional test if nec */
            if (e->type->optional || (e->type->defaultVal != NULL))
                fprintf(src, "    }\n\n");
            else
                fprintf(src, "\n");
        }
        fprintf(src,"    return(totalLen);\n");
        fprintf(src,"} /* %s::B%s */\n\n\n", td->cppTypeDefInfo->className,
                r->encodeContentBaseName);
    }
    /* end of BerEncodeContent */



    /* write BerDecodeContent to src */
    if (printDecodersG)
    {
        fprintf(src,"void\n");
        fprintf(src,"%s::B%s(%s b, %s tag0, %s elmtLen0, %s& bytesDecoded, %s env)\n", td->cppTypeDefInfo->className, r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG);
        
        fprintf(src,"{\n");
        
        /* print local vars */
        fprintf(src,"    %s tag1;\n", tagTypeNameG);
        fprintf(src,"    %s setBytesDecoded = 0;\n", lenTypeNameG);
        fprintf(src,"    unsigned int mandatoryElmtsDecoded = 0;\n");
        /* count max number of extra length var nec */
        varCount = 0;
        FOR_EACH_LIST_ELMT(e, set->basicType->a.set)
        {
            tmpVarCount = CppCountVariableLevels(e->type);
            if (tmpVarCount > varCount)
                varCount = tmpVarCount;
        }
        /* write extra length vars */
        for (i = 1; i <= varCount; i++)
        {
            fprintf(src,"    %s elmtLen%d;\n", lenTypeNameG, i);
        }
        fprintf(src,"\n");
        
        /* handle empty set */ 
        if ((set->basicType->a.set == NULL) || LIST_EMPTY(set->basicType->a.set))
        {
            fprintf(src,"    if (elmtLen0 == INDEFINITE_LEN)\n");
            fprintf(src,"        BDecEoc(b, bytesDecoded, env);\n");
            fprintf(src,"    else if (elmtLen0 != 0)\n");
            fprintf(src,"    {\n");
            fprintf(src,"         Asn1Error(\"Expected an empty sequence\\n\");\n");
            fprintf(src,"         longjmp(env, %d);\n",longJmpValG--);
            fprintf(src,"    }\n");

/*   forget about potential extension types for now 
            fprintf(src,"    if (elmtLen0 == INDEFINITE_LEN)\n");
            fprintf(src,"    {\n");
            fprintf(src,"        tag1 = BDecTag(b, bytesDecoded, env);\n\n");
            fprintf(src,"        if ( tag1 == EOC_TAG_ID)\n");
            fprintf(src,"            BDEC_2ND_EOC_OCTET(b, bytesDecoded, env)\n");
            fprintf(src,"        else\n");
            fprintf(src,"            BerDiscardElmt(b, bytesDecoded, env);\n\n");
            fprintf(src,"    }\n");
            fprintf(src,"    else\n");
            fprintf(src,"    {\n");
            fprintf(src,"        BufSkip(b, elmtLen0);\n");
            fprintf(src,"        bytesDecoded += elmtLen0;\n");
            fprintf(src,"    }\n");
*/
            
        }
        else
        {
            
            fprintf(src,"    for( ; (setBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)\n");
            fprintf(src,"    {\n");
            fprintf(src,"        tag1 = BDecTag(b, setBytesDecoded, env);\n\n");
            fprintf(src,"        if ((elmtLen0 == INDEFINITE_LEN) && (tag1 == EOC_TAG_ID))\n");
            fprintf(src,"        {\n");
            fprintf(src,"            BDEC_2ND_EOC_OCTET(b, setBytesDecoded, env)\n");
            fprintf(src,"            break; /* exit for loop */\n");
            fprintf(src,"        }\n");
            
            fprintf(src,"        elmtLen1 = BDecLen (b, setBytesDecoded, env);\n");        
            fprintf(src,"        switch(tag1)\n");
            fprintf(src,"        {\n");
            mandatoryElmtCount = 0;
            FOR_EACH_LIST_ELMT(e, set->basicType->a.set)
            {
                cpptri =  e->type->cppTypeRefInfo;
                
                tags = GetTags(e->type, &stoleChoiceTags);

                if (LIST_EMPTY(tags))
                {
                    fprintf(src,"          // ANY Type ?\n");
                    fprintf(src,"          case(MAKE_TAG_ID( ?, ?, ?)):\n");
                }
                else
                {
                    tag = (Tag*)FIRST_LIST_ELMT(tags);
                    classStr = Class2ClassStr(tag->class);
                    codeStr = Code2UnivCodeStr(tag->code);
                    formStr = Form2FormStr(tag->form);
                    
                    if ( tag->class == UNIV)
                    {
                        if (tag->form == ANY_FORM)
                        {
                            fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                    classStr , Form2FormStr(PRIM) , codeStr);
                            fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                    classStr , Form2FormStr(CONS) , codeStr);
                        }
                        else
                            fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                    classStr , formStr , codeStr);
                    }
                    else
                    {
                        if (tag->form == ANY_FORM)
                        {
                            fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                    classStr , Form2FormStr(PRIM) , tag->code);
                            fprintf(src,"           case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                    classStr , Form2FormStr(CONS) , tag->code);
                        }
                        else
                            fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                    classStr , formStr , tag->code);
                    }
                    
                    
                    /* now decode extra tags/length pairs */
                    GListFirst(tags);
                    GListNext(tags);
                    elmtLevel = 1;
                    if ( stoleChoiceTags)
                    {
                        FOR_REST_LIST_ELMT(tag, tags)
                        {
                            classStr = Class2ClassStr(tag->class);
                            codeStr = Code2UnivCodeStr(tag->code);
                            formStr = Form2FormStr(tag->form);
                            
                            if ( tag->class == UNIV)
                            {
                                if (tag->form == ANY_FORM)
                                {
                                    fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                            classStr , Form2FormStr(PRIM) , codeStr);
                                    fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                            classStr , Form2FormStr(CONS) , codeStr);
                                }
                                else
                                    fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %s)):\n",
                                            classStr , formStr , codeStr);
                            }
                            else
                            {
                                if (tag->form == ANY_FORM)
                                {
                                    fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                            classStr , Form2FormStr(PRIM) , tag->code);
                                    fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                            classStr , Form2FormStr(CONS) , tag->code);
                                }
                                else
                                    fprintf(src,"          case(MAKE_TAG_ID( %s, %s, %d)):\n",
                                            classStr , formStr , tag->code);
                            }
                        }
                    }
                    else /* didn't steal nested choice's tags */
                    {
                        FOR_REST_LIST_ELMT(tag, tags)
                        {
                            classStr = Class2ClassStr(tag->class);
                            codeStr = Code2UnivCodeStr(tag->code);
                            formStr = Form2FormStr(tag->form);
                            
                            fprintf(src,"            tag1 = BDecTag(b, setBytesDecoded, env);\n");
                            if (tag->form == ANY_FORM)
                            {
                                if (tag->class == UNIV)
                                {
                                    fprintf(src,"            if ((tag1 != MAKE_TAG_ID( %s, %s, %s)) &&\n",  classStr, Form2FormStr(PRIM), codeStr);
                                    fprintf(src,"               (tag1 != MAKE_TAG_ID( %s, %s, %s)))\n", classStr, Form2FormStr(CONS), codeStr);
                                }
                                else
                                {
                                    fprintf(src,"            if ((tag1 != MAKE_TAG_ID( %s, %s, %d)) &&\n", classStr, Form2FormStr(PRIM), tag->code);
                                    fprintf(src,"               (tag1 != MAKE_TAG_ID( %s, %s, %d)))\n", classStr, Form2FormStr(CONS), tag->code);
                                }
                                
                            }
                            else
                            {
                                if ( tag->class == UNIV)
                                    fprintf(src,"            if (tag1 != MAKE_TAG_ID( %s, %s, %s))\n", classStr, formStr, codeStr);
                                else
                                    fprintf(src,"            if (tag1 != MAKE_TAG_ID( %s, %s, %d))\n", classStr, formStr, tag->code);
                            }
                            
                            fprintf(src,"            {\n");
                            fprintf(src,"                 Asn1Error(\"Unexpected Tag\\n\");\n");
                            fprintf(src,"                 longjmp(env, %d);\n", longJmpValG--);
                            fprintf(src,"            }\n\n");
                            
                            fprintf(src,"            elmtLen%d = BDecLen (b, setBytesDecoded, env);\n", ++elmtLevel);
                        }
                    }
                }
                /*
                 * if the choices element is another choice &&
                 * we didn't steal its tags then we must grab 
                 * the key tag out of the contained CHOICE
                 */
                if (!stoleChoiceTags && 
                    (GetBuiltinType(e->type) == BASICTYPE_CHOICE))
                {
                    fprintf(src,"        tag1 = BDecTag(b, setBytesDecoded, env);\n");
                    fprintf(src,"        elmtLen%d = BDecLen (b, setBytesDecoded, env);\n", ++elmtLevel);
                }

                
                varName = cpptri->fieldName;

                /* decode content */
                if (cpptri->isPtr)
                    fprintf(src,"            %s = new %s;\n", varName, cpptri->className);


                /* decode content */
                tmpTypeId = GetBuiltinType(e->type);
                if (tmpTypeId == BASICTYPE_ANYDEFINEDBY)
                {
                    /*
                     * must check for another EOC for ANYs
                     * since the any decode routines decode
                     * their own first tag/len pair
                     */
                    elmtLevel++;

                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    
                    defByNamedType = e->type->basicType->a.anyDefinedBy->link;
                    if (GetBuiltinType(defByNamedType->type) == BASICTYPE_OID)
                    {
                        fprintf(src,"SetTypeByOid(");
                        if (defByNamedType->type->cppTypeRefInfo->isPtr)
                            fprintf(src,"*");
                        fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                    }
                    else
                    {
                        fprintf(src,"SetTypeByInt(");
                        if (defByNamedType->type->cppTypeRefInfo->isPtr)
                            fprintf(src,"*");
                        fprintf(src,"%s);\n",defByNamedType->type->cppTypeRefInfo->fieldName);
                    }
                    
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    fprintf(src,"B%s(b, setBytesDecoded, env);\n",  r->decodeBaseName);
                }
                else if (tmpTypeId == BASICTYPE_ANY)
                {
                    /*
                     * must check for another EOC for ANYs
                     * since the any decode routines decode
                     * their own first tag/len pair
                     */
                    elmtLevel++;

                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    fprintf(src,"SetTypeBy???(???);\n");
                    
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    fprintf(src,"B%s(b, setBytesDecoded, env);\n",  r->decodeBaseName);
                }
                else
                {
                    fprintf(src,"        %s", varName);
                    if (cpptri->isPtr)
                        fprintf(src,"->");
                    else
                        fprintf(src,".");
                    
                    fprintf(src,"B%s(b, tag1, elmtLen%d, setBytesDecoded, env);\n",  r->decodeContentBaseName, elmtLevel);
                }

                /* decode Eoc(s) */
                for (i = elmtLevel-1; i >= 1; i--)
                {
                    fprintf(src,"            if (elmtLen%d == INDEFINITE_LEN)\n", i);
                    fprintf(src,"                BDecEoc(b, setBytesDecoded, env);\n\n");
                }
                
                /* keep track of decoded non-optional elmts */
                if (!e->type->optional && (e->type->defaultVal == NULL))
                {
                    mandatoryElmtCount++;
                    fprintf(src,"            mandatoryElmtsDecoded++;\n");
                }
                fprintf(src,"            break;\n\n");

                FreeTags(tags);
            }  /* for each elmt */
            fprintf(src,"           default:\n");
            fprintf(src,"             Asn1Error(\"Unexpected Tag on SET elmt.\\n\");\n");
            fprintf(src,"             longjmp(env, %d);\n", longJmpValG--);
            fprintf(src,"        }  /* end switch */\n");
            fprintf(src,"    }  /* end for loop */\n");
            fprintf(src,"    bytesDecoded += setBytesDecoded;\n");
            fprintf(src,"    if (mandatoryElmtsDecoded != %d)\n", mandatoryElmtCount);
            fprintf(src,"    {\n");
            fprintf(src,"         Asn1Error(\"ERROR - non-optional SET element missing.\\n\");\n");
            fprintf(src,"         longjmp(env, %d);\n", longJmpValG--);
            fprintf(src,"    }\n");

        } /* if not empty set clause */
        
        
        fprintf(src,"} /* %s::B%s */\n\n", td->cppTypeDefInfo->className,
                r->decodeContentBaseName);  
    }
    /* end of decode content method code */


    /* write code for printing */
    if (printPrintersG)
    {
        fprintf(src,"void\n%s::Print(ostream& os)\n",
                td->cppTypeDefInfo->className);
        fprintf(src,"{\n");
        allOpt = AllElmtsOptional(set->basicType->a.set);
        if (allOpt)
            fprintf(src,"    int nonePrinted = TRUE;\n");

        fprintf(src,"    os << \"{  -- SET --\" << endl;\n");
        fprintf(src,"    indentG += stdIndentG;\n");
        FOR_EACH_LIST_ELMT(e, set->basicType->a.set)
        {
            inTailOptElmts = IsTailOptional(set->basicType->a.set);

            if (e->type->optional || (e->type->defaultVal != NULL))
            {
                fprintf(src,"    if (%s(%s))\n", cpptri->optTestRoutineName,
                        e->type->cppTypeRefInfo->fieldName);
                fprintf(src,"    {\n");
            }

            if (allOpt)
            {
                if (e != FIRST_LIST_ELMT(set->basicType->a.set))
                {
                    fprintf(src, "    if (!nonePrinted)\n");
                    fprintf(src, "        os << \",\" << endl;\n");
                }
                fprintf(src, "    nonePrinted = FALSE;\n");
            }
            else if (inTailOptElmts) /* cannot be first elmt ow allOpt is true */
                fprintf(src, "    os << \",\"<< endl;\n");

            
            fprintf(src,"    Indent(os, indentG);\n");
            
            if (e->fieldName != NULL)
                fprintf(src,"    os << \"%s \";\n", e->fieldName);
            
            if (e->type->cppTypeRefInfo->isPtr)
                fprintf(src,"    os <<  *%s;\n",
                        e->type->cppTypeRefInfo->fieldName);
            else
                fprintf(src,"    os << %s;\n",
                        e->type->cppTypeRefInfo->fieldName);
  
            if ((e != LAST_LIST_ELMT(set->basicType->a.set)) &&
                (!inTailOptElmts) &&
                (!NextIsTailOptional(set->basicType->a.set)))
                fprintf(src,"    os << \",\" << endl;\n");

            if (e->type->optional || (e->type->defaultVal != NULL))
            {
                fprintf(src,"    }\n");
            }

            if (e == LAST_LIST_ELMT(set->basicType->a.set))
                fprintf(src,"    os << endl;\n");          
        }
        fprintf(src,"    indentG -= stdIndentG;\n");
        fprintf(src,"    Indent(os, indentG);\n");
        fprintf(src,"    os << \"}\";\n") ;
        fprintf(src,"}  /* %s - operator<< */\n\n\n", td->cppTypeDefInfo->className);
    }
    /* end of print method code */

} /* PrintCppSetDefCode */



static void
PrintCppSetOfDefCode PARAMS((src, hdr, mods, m, r, td, parent, setOf),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* setOf)
{
    /* do class */
    PrintCppListClass(src, hdr, mods, m, r, td, parent, setOf);

    /* do methods */
    PrintCppListMethods(src, hdr, mods, m, r, td, parent, setOf);

}  /* PrintCppSetOfDefCode */

static void
PrintCppType PARAMS((src, hdr, mods, m, r, td, parent, t ),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* t)
{
    fprintf(hdr, "%s", t->cppTypeRefInfo->className);

    if (t->cppTypeRefInfo->isPtr)
        fprintf(hdr, "*");    

}  /* PrintCppType */


static void
PrintPduMemberFcns PARAMS((src, hdr, r),
FILE* src _AND_
FILE* hdr _AND_
CppRules* r)
{
    if (printEncodersG)
    {
        fprintf(hdr, "      int B%s( %s b, %s& bytesEncoded)\n",
                r->encodePduBaseName, bufTypeNameG, lenTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"           bytesEncoded = B%s(b);\n",r->encodeBaseName);
        fprintf(hdr,"           return(!b.WriteError());\n");
        fprintf(hdr,"      }\n\n");
    }

    if (printDecodersG)
    {
        fprintf(hdr,"      int B%s( %s b, %s& bytesDecoded)\n",
                r->decodePduBaseName, bufTypeNameG, lenTypeNameG);
        fprintf(hdr,"      {\n");
        fprintf(hdr,"          %s env;\n", envTypeNameG);
        fprintf(hdr,"          int val;\n\n");
        fprintf(hdr,"          bytesDecoded = 0;\n");
        fprintf(hdr,"          if ((val = setjmp(env)) == 0 )\n");
        fprintf(hdr,"          {\n");
        fprintf(hdr,"               BDec(b, bytesDecoded, env);\n");
        fprintf(hdr,"               return(!b.ReadError());\n");
        fprintf(hdr,"          }\n");
        fprintf(hdr,"          else\n");
        fprintf(hdr,"              return(FALSE);\n");
/*
        fprintf(hdr,"          { cerr << \"longjmp return value is \" << val << endl;\n");
        fprintf(hdr,"              return(FALSE);}\n");
*/
        fprintf(hdr,"      }\n\n");
    }
}  /* PrintPduMemberFcns */


static void
PrintForwardTypeDecl PARAMS((f, td),
FILE* f _AND_
TypeDef* td)
{
    switch(td->type->basicType->choiceId)
    {
        case(BASICTYPE_COMPONENTSOF):
        case(BASICTYPE_SELECTION):
        case(BASICTYPE_UNKNOWN):
        case(BASICTYPE_MACRODEF):
        case(BASICTYPE_MACROTYPE):
            return; /* do nothing */

        default:
            if (IsNewType(td->type))
                fprintf(f,"class %s;\n", td->cppTypeDefInfo->className);
    }

} /* PrintForwardTypeDecl */



static void
PrintCppEocEncoders PARAMS((src, td, t, bufVarName),
FILE* src _AND_
TypeDef* td _AND_
Type* t _AND_
char* bufVarName)
{
    TagList* tl;
    Tag* tag;
    int stoleChoiceTags;

    /*
     * get all the tags on this type 
     */
    tl = (TagList*) GetTags(t, &stoleChoiceTags);
    
    /*
     * leave choice elmt tag enc to encoding routine
     */
    if (!stoleChoiceTags)
    {
        FOR_EACH_LIST_ELMT(tag, tl)
        {
            if (tag->form == CONS)
                fprintf(src,"    BEncEocIfNec(b);\n");
        }
    }

    FreeTags(tl);

}  /* PrintCppEocEncoders */


/*
 *  Recursively walks through tags, printing lower lvl tags
 *  first (since encoding is done backwards).  
 *
 */
static void
PrintCppTagAndLenEncodingCode PARAMS((src, td, t, lenVarName, bufVarName),
FILE* src _AND_
TypeDef* td _AND_
Type* t _AND_
char* lenVarName _AND_
char* bufVarName)
{
    TagList* tl;
    int stoleChoiceTags;

    /*
     * get all the tags on this type 
     */
    tl = (TagList*) GetTags(t, &stoleChoiceTags);
    
    /*
     * leave choice elmt tag enc to encoding routine
     */
    if (!stoleChoiceTags)
        PrintCppTagAndLenList(src, t, tl, lenVarName, bufVarName);

    FreeTags(tl);

}  /* PrintCppTagAndLenEncodingCode */


static int
HasShortLen PARAMS((t),
Type* t)
{
    enum BasicTypeChoiceId typesType;
    /*
     * efficiency hack - use simple length (1 byte)
     * encoded for type (almost) guaranteed to have
     * encoded lengths of 0 <= len <= 127
     */
    typesType = GetBuiltinType(t);
    if ((typesType == BASICTYPE_BOOLEAN) ||
        (typesType == BASICTYPE_INTEGER) ||
        (typesType == BASICTYPE_NULL) ||
        (typesType == BASICTYPE_REAL) ||
        (typesType == BASICTYPE_ENUMERATED))
        return (1);
    else
        return(0);
}  /* HasShortLen */


/*
 * prints last tag's encoding code first
 */
static void
PrintCppTagAndLenList PARAMS((src, t, tagList, lenVarName, bufVarName),
FILE* src _AND_
Type* t _AND_
TagList* tagList _AND_
char* lenVarName _AND_
char* bufVarName)
{
    char* classStr;
    char* formStr;
    char* codeStr;
    Tag* tg;
    Tag* last;
    int tagLen;
    enum BasicTypeChoiceId typesType;
    int isShort;

    if ((tagList == NULL) || LIST_EMPTY(tagList))
        return;

    /*
     * efficiency hack - use simple length (1 byte)
     * encoded for type (almost) guaranteed to have
     * encoded lengths of 0 <= len <= 127
     */
    isShort = HasShortLen(t);

    /*
     * since encoding backward encode tags backwards
     */
    last = (Tag*)LAST_LIST_ELMT(tagList);
    FOR_EACH_LIST_ELMT_RVS(tg, tagList)
    {
        classStr = Class2ClassStr(tg->class);

        if (tg->form == CONS)
        {
            formStr = Form2FormStr(CONS);
            PrintCppLenEncodingCode(src, TRUE, isShort, lenVarName, bufVarName); 
        }
        else /* PRIM or ANY_FORM */
        {
            formStr = Form2FormStr(PRIM);
            PrintCppLenEncodingCode(src, FALSE, isShort, lenVarName, bufVarName);
        }


/*      GetTags sets the form properly now         
        if (IsPrimitiveByDefOrRef(t) && (tg == last))
        {
            formStr = Form2FormStr(PRIM);
            PrintCppLenEncodingCode(src, FALSE, isShort, lenVarName, bufVarName);
        }
        else
        {
            formStr = Form2FormStr(CONS);
            PrintCppLenEncodingCode(src, TRUE, isShort, lenVarName, bufVarName); 
        }
*/        
        
        fprintf(src,"\n");

        tagLen = TagByteLen(tg->code);
        
        if (tg->class == UNIV)
            fprintf(src,"    %s += BEncTag%d(%s, %s, %s, %s);\n",
                lenVarName, tagLen, bufVarName, classStr, formStr,
                    Code2UnivCodeStr(tg->code));
        else
            fprintf(src,"    %s += BEncTag%d(%s, %s, %s, %d);\n",
                lenVarName, tagLen, bufVarName, classStr, formStr, tg->code);
    }

}  /* PrintCppTagAndLenList */



/*
 * prints length encoding code.  Primitives always use
 * definite length and constructors get "ConsLen"
 * which can be configured at compile to to be indefinite
 * or definite.  Primitives can also be "short" (isShort is true)
 * in which case a fast macro is used to write the length.
 * Types for which isShort apply are: boolean, null and 
 * (almost always) integer and reals
 */
static void
PrintCppLenEncodingCode PARAMS((f, isCons, isShort, lenVarName, bufVarName),
FILE* f _AND_
int isCons _AND_
int isShort _AND_
char* lenVarName _AND_
char* bufVarName)
{
    if (isCons)
        fprintf(f, "    %s += BEncConsLen( %s, %s);", lenVarName,
                bufVarName, lenVarName);
    else
    {
        if (isShort)
        {
            fprintf(f, "    BEncDefLenTo127( %s, %s);\n", bufVarName, 
                    lenVarName);
            fprintf(f, "    %s++;", lenVarName);
        }
        else
            fprintf(f, "    %s += BEncDefLen( %s, %s);", lenVarName, 
                    bufVarName, lenVarName);
    }
}  /* PrintCppLenEncodingCode */



/*
 * used to figure out local variables to declare
 * for decoding tags/len pairs on type t
 */
static int
CppCountVariableLevels PARAMS((t),
Type* t)
{
    if (GetBuiltinType(t) == BASICTYPE_CHOICE)
    {
        return(CountTags(t) +1); /* since must decode 1 internal tag type */
    }
    else
        return( CountTags(t));

}  /* CppCountVariableLevels */


/*
 * prints typedef or new class given an ASN.1  type def of a primitive type
 * or typeref.  Uses inheritance to cover re-tagging and named elmts.
 */
static void 
PrintCppSimpleDef PARAMS((hdr, src, r, td),
FILE* hdr _AND_
FILE* src _AND_
CppRules* r _AND_
TypeDef* td)
{
    Tag* tag;
    TagList* tags;
    char* formStr;
    char* classStr;
    int tagLen;
    int i;
    CNamedElmt* n;
    int stoleChoiceTags;
    int elmtLevel;
    enum BasicTypeChoiceId typeId;


    /* check if has been re-tagged 
     *   eg Foo ::= [APPLICATION 2] IMPLICIT REAL 
     * or if it has named elmts in which case a new class must 
     * be defined
     *  eg Foo ::= INTEGER { one(1), two(2), three(3) }
     */

    if (IsNewType(td->type))
    {
        fprintf(hdr," /* ");
        SpecialPrintType(hdr, td, td->type);
        fprintf(hdr," */\n");
        fprintf(hdr, "class %s : public %s\n", td->cppTypeDefInfo->className,
                td->type->cppTypeRefInfo->className);

        fprintf(hdr, "{\n");
        fprintf(hdr, "    public:\n");

        /*
         * must explicitly call constructors for base class
         */
        PrintDerivedConstructors(hdr, r, td);

        /* do named elmts enum if any */
        /* for types with named elements, inherit from the base
         * class and define and enum eg:
         * Foo ::= INTEGER { one(1), two(2), five(5) }
         *  ->
         * class Foo : public AsnInt
         * {
         *    public:
         *       Foo() : AsnInt() {}
         *       Foo(int val) : AsnInt(int val) {}
         *    enum { one =1, two =2 , five = 5};
         * };
         * or
         * Foo2 ::= [APPLICATION 2] INTEGER
         * -->
         * class Foo : public AsnInt
         * {
         *    public:
         *       Foo() : AsnInt() {}
         *       Foo(int val) : AsnInt(int val) {}
         *       AsnLen BEnc { ....... } <-- holds new tag enc/dec
         *       void BDec { ....... }   <--/
         *       int BEncPdu { ....... }
         *       int BDecPdu { ....... }
         * };
         *  (must 'inherit' constructors explicitly)
         */

        if (HasNamedElmts(td->type))
        {
            fprintf(hdr,"       enum\n");
            fprintf(hdr,"       {\n");
            FOR_EACH_LIST_ELMT(n, td->type->cppTypeRefInfo->namedElmts)
            {
                fprintf(hdr,"           %s = %d", n->name, n->value);
                if (n != (CNamedElmt*)LAST_LIST_ELMT(td->type->cppTypeRefInfo->namedElmts))
                    fprintf(hdr,",\n");
                else
                    fprintf(hdr,"\n");
            }
            fprintf(hdr,"       };\n");
        }

        /*
         * Re-do BerEncode, BerDeocode, BerDecodePdu and BerDecodePdu
         * if this type has been re-tagged 
         */
        if ( (IsDefinedByLibraryType(td->type) && 
              !HasDefaultTag(td->type)) ||
            (IsTypeRef(td->type) && 
             ((td->type->tags != NULL) && !LIST_EMPTY(td->type->tags))))
        {
            /* only BerEn/Decode BerEn/DeodePdu need to be re-done
             * if tags are different 
             */

            /* print clone routine for ANY mgmt */
            PrintCloneMethod(hdr, td);

            tags = GetTags(td->type, &stoleChoiceTags);
            typeId = GetBuiltinType(td->type);

            /* do BerEncode inline */
            if (printEncodersG)
            {
                fprintf(hdr,"      %s B%s(%s b)\n", lenTypeNameG, 
                        r->encodeBaseName, bufTypeNameG);
                fprintf(hdr,"      {\n");
                fprintf(hdr,"          %s l;\n", lenTypeNameG);

                PrintCppEocEncoders(hdr, td, td->type, "b");

                fprintf(hdr,"          l = BEncContent(b);\n");
                
                /* encode each tag/len pair if any */
                if (!stoleChoiceTags)
                {
                    FOR_EACH_LIST_ELMT_RVS(tag, tags)
                    {
                        classStr = Class2ClassStr(tag->class);

                        if (tag->form == ANY_FORM)
                        {
                            formStr = Form2FormStr(PRIM);
                            PrintCppLenEncodingCode (hdr, FALSE, HasShortLen(td->type), "l", "b");
                        }
                        else
                        {
                            formStr = Form2FormStr(tag->form);  
                            PrintCppLenEncodingCode (hdr, TRUE, HasShortLen(td->type), "l", "b");
                        }
                        
                        fprintf(hdr,"\n");
                        tagLen = TagByteLen(tag->code);

                        if (tag->class == UNIV)
                            fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %s);\n",
                                    tagLen, classStr, formStr, Code2UnivCodeStr(tag->code));
                        else
                            fprintf(hdr,"          l += BEncTag%d(b, %s, %s, %d);\n",
                                    tagLen, classStr, formStr, tag->code);
                    }
                }
                fprintf(hdr,"          return(l);\n");
                fprintf(hdr,"      }\n\n");
            }
            /* end of BEnc inline */
            
            
            /* Do BDec inline */
            if (printDecodersG)
            {
                fprintf(hdr,"      void B%s(%s b, %s& bytesDecoded, %s env)\n", 
                        r->decodeBaseName, bufTypeNameG, lenTypeNameG, envTypeNameG);
                fprintf(hdr,"      {\n");
                fprintf(hdr,"          %s tag;\n", tagTypeNameG);
                
                /* print extra locals for redundant lengths */
                for (i = 1; (tags != NULL) && (i <= LIST_COUNT(tags)); i++)
                {
                    fprintf(hdr,"          %s elmtLen%d;\n", lenTypeNameG, i);
                }
                if (typeId == BASICTYPE_CHOICE)
                {
                    fprintf(hdr,"          %s elmtLen%d;\n", lenTypeNameG, i++);
                }
                fprintf(hdr,"\n");
                
                /*  decode tag/length pair(s) */
                elmtLevel = 0;
                if (!stoleChoiceTags)
                {
                    FOR_EACH_LIST_ELMT(tag, tags)
                    {
                        classStr = Class2ClassStr(tag->class);

                        if (tag->form == ANY_FORM)
                            formStr = Form2FormStr(PRIM);
                        else
                            formStr = Form2FormStr(tag->form);
                        
                        fprintf(hdr,"          if ( ((tag = BDecTag(b, bytesDecoded, env)) != \n");
                        
                        if (tag->class == UNIV)
                        {
                            fprintf(hdr,"MAKE_TAG_ID(%s, %s, %s))", classStr, formStr, Code2UnivCodeStr(tag->code));
                            if (tag->form == ANY_FORM)
                                fprintf(hdr,"&&\n         (tag != MAKE_TAG_ID(%s, %s, %s)))\n", classStr, Form2FormStr(CONS), Code2UnivCodeStr(tag->code));
                            else
                                fprintf(hdr,")\n");
                        }
                        else
                        {
                            fprintf(hdr,"MAKE_TAG_ID(%s, %s, %d))", classStr, formStr, tag->code);
                            if (tag->form == ANY_FORM)
                                fprintf(hdr,"&&\n         (tag != MAKE_TAG_ID(%s, %s, %d)))\n", classStr, Form2FormStr(CONS), tag->code);
                            else
                                fprintf(hdr,")\n");
                        }
                        fprintf(hdr,"          {\n");
                        fprintf(hdr,"              Asn1Error(\"%s::B%s: ERROR - wrong tag\\n\");\n", td->cppTypeDefInfo->className, r->decodeBaseName);
                        fprintf(hdr,"              longjmp(env, %d);\n", longJmpValG--);
                        fprintf(hdr,"          }\n");
                        
                        fprintf(hdr,"          elmtLen%d = BDecLen(b, bytesDecoded, env);\n", ++elmtLevel);
                    }
                }

                /* decode first tag from CHOICE's content */
                if (typeId == BASICTYPE_CHOICE)
                {
                    fprintf(hdr,"          tag = BDecTag(b, bytesDecoded, env);\n");
                    fprintf(hdr,"          elmtLen%d = BDecLen(b, bytesDecoded, env);\n", ++elmtLevel);
                }

                fprintf(hdr,"          B%s(b, tag, elmtLen%d, bytesDecoded, env);\n", r->decodeContentBaseName, i-1);
                
                /* grab any EOCs that match redundant, indef lengths */
                for (i = elmtLevel-1; i > 0; i--)
                {
                    fprintf(hdr,"          if (elmtLen%d == INDEFINITE_LEN)\n", i);
                    fprintf(hdr,"              BDecEoc(b, bytesDecoded, env);\n");
                }
                
                fprintf(hdr,"      }\n\n");
            }
            /* end of BDec inline */
            
            PrintPduMemberFcns(src, hdr, r);

            FreeTags(tags);
        }
        /* close class def */
        fprintf(hdr, "};\n\n\n");

    }
    else  /* isomorphic with referenced type, so just to a typedef */
    {
        fprintf(hdr," /* ");
        SpecialPrintType(hdr, td, td->type);
        fprintf(hdr," */\n");
        fprintf(hdr,"typedef %s %s;\n\n", 
                td->type->cppTypeRefInfo->className, 
                td->cppTypeDefInfo->className);

    }
} /* PrintCppSimpleDef */




/*
 * returns true if elmts curr following
 *  onward are all optional ow. false
 */
static int
RestAreTailOptional PARAMS((e),
NamedTypeList* e)
{
    NamedType* elmt;
    void* tmp;
    int retVal;

    if (e == NULL)
        return(TRUE);

    tmp = (void*)CURR_LIST_NODE(e);
    retVal = TRUE;
    GListNext(e);
    FOR_REST_LIST_ELMT(elmt, e)
    {
        if ((!elmt->type->optional) && (elmt->type->defaultVal == NULL))
        {
            retVal = FALSE;
            break;
        }
    }
    SET_CURR_LIST_NODE(e, tmp); /* reset list to orig loc */
    return(retVal);
}


/*
 * This major Bogosity results from gcc2.2.2 inability to handle
 * template properly
 */
static void
PrintCppListClass PARAMS((src, hdr, mods, m, r, td, parent, lst),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* lst)
{
    char* lcn; /* list class name */
    char* ecn; /* (list) elmt class name */
    char* classStr;
    char* formStr;
    int tagLen;
    Tag* tag;
    int i, elmtLevel;


    lcn = td->cppTypeDefInfo->className;
    ecn = lst->basicType->a.setOf->cppTypeRefInfo->className;

    fprintf(hdr,"class %s %s\n", lcn, baseClassesG);
    fprintf(hdr,"{\n");
    fprintf(hdr,"  protected:\n");
    
    fprintf(hdr,"    unsigned long int count;\n");
    fprintf(hdr,"    struct AsnListElmt\n");
    fprintf(hdr,"    {\n");
    fprintf(hdr,"        struct AsnListElmt* next;\n");
    fprintf(hdr,"        struct AsnListElmt* prev;\n");
    fprintf(hdr,"        %s* elmt;\n",ecn);
    fprintf(hdr,"    } *first, *curr, *last;\n\n");
    
    fprintf(hdr,"  public:\n");

    if (printPrintersG)
        fprintf(hdr,"    void Print(ostream& os);\n");

    /* print clone routine for ANY mgmt */
    PrintCloneMethod(hdr, td);
    
    fprintf(hdr,"    %s () { count = 0; first = curr = last = NULL; }\n",lcn);
    
    
    fprintf(hdr,"    void SetCurrElmt(unsigned long int index);\n");
    fprintf(hdr,"    unsigned long int GetCurrElmtIndex();\n");
    fprintf(hdr,"    void SetCurrToFirst() { curr = first; }\n");
    fprintf(hdr,"    void SetCurrToLast()  { curr = last; }\n");
    
    fprintf(hdr,"    // reading member fcns\n");
    fprintf(hdr,"    int Count() { return count; }\n");
    fprintf(hdr,"    %s* First() { if (count > 0) return(first->elmt) ; else return(NULL); }\n",ecn);
    fprintf(hdr,"    %s* Last()  { if (count > 0) return(last->elmt) ; else return(NULL); }\n",ecn);
    fprintf(hdr,"    %s* Curr()  { if (curr != NULL) return(curr->elmt) ; else return(NULL); }\n",ecn);
    fprintf(hdr,"    %s* Next()  { if ((curr != NULL)&& (curr->next != NULL)) return(curr->next->elmt) ; else return(NULL); }\n",ecn);
    fprintf(hdr,"    %s* Prev()  { if ((curr != NULL)&& (curr->prev != NULL)) return(curr->prev->elmt) ; else return(NULL); }\n\n",ecn);
    
    fprintf(hdr,"    // routines that move the curr elmt\n");
    fprintf(hdr,"    %s* GoNext() { if (curr != NULL) curr = curr->next; return(Curr()); }\n",ecn);
    fprintf(hdr,"    %s* GoPrev() { if (curr != NULL) curr = curr->prev; return(Curr()); }\n\n",ecn);
    
    fprintf(hdr,"    // write & alloc fcns - returns new elmt\n");
    fprintf(hdr,"    %s* Append();  // add elmt to end of list\n",ecn);
    fprintf(hdr,"    %s* Prepend(); // add elmt to beginning of list\n",ecn);
    fprintf(hdr,"    %s* InsertBefore(); //insert elmt before current elmt\n",ecn);
    fprintf(hdr,"    %s* InsertAfter(); //insert elmt after current elmt\n\n",ecn);
    
    fprintf(hdr,"    // write & alloc & copy - returns list after copying elmt\n");
    fprintf(hdr,"    %s& AppendCopy( %s& elmt);  // add elmt to end of list\n",lcn,ecn);
    fprintf(hdr,"    %s& PrependCopy( %s& elmt); // add elmt to beginning of list\n",lcn,ecn);
    fprintf(hdr,"    %s& InsertBeforeAndCopy( %s& elmt); //insert elmt before current elmt\n",lcn,ecn);
    fprintf(hdr,"    %s& InsertAfterAndCopy( %s& elmt); //insert elmt after current elmt\n\n",lcn,ecn);
    
    fprintf(hdr,"    // encode and decode routines    \n");

    /* print PDU oriented encode routine */
    if (printEncodersG)
    {
        fprintf(hdr,"    %s B%s(%s b)\n", lenTypeNameG, 
                r->encodeBaseName, bufTypeNameG);
        fprintf(hdr,"    {\n");
        fprintf(hdr,"        %s l;\n", lenTypeNameG);

        /* encode the list content */
        fprintf(hdr,"        l = B%s(b);\n",r->encodeContentBaseName);
        
        /* encode each tag/len pair if any */
        FOR_EACH_LIST_ELMT_RVS(tag, lst->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* choices are constructed */
            tagLen = TagByteLen(tag->code);
            
            /* always constructed lengths for list */
            fprintf(hdr,"        l += BEncConsLen(b, l);\n");
            
            if (tag->class == UNIV)
                fprintf(hdr,"        l += BEncTag%d(b, %s, %s, %s);\n",
                        tagLen, classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"        l += BEncTag%d(b, %s, %s, %d);\n",
                        tagLen, classStr, formStr, tag->code);
        }
        fprintf(hdr,"        return(l);\n");
        fprintf(hdr,"    }\n\n");
    }
    /* end of ber encode inline */

    /* do BerDecode inline */
    if (printDecodersG)
    {
        fprintf(hdr,"    void B%s(%s b, %s& bytesDecoded, %s env)\n", 
                r->decodeBaseName, bufTypeNameG, lenTypeNameG, envTypeNameG);
        fprintf(hdr,"    {\n");
        fprintf(hdr,"        %s tag;\n", tagTypeNameG);
        
        /* print extra locals for redundant lengths */
        for (i = 1; (lst->tags != NULL) && (i <= LIST_COUNT(lst->tags)); i++)
        {
            fprintf(hdr,"        %s elmtLen%d;\n", lenTypeNameG, i);
        }
        fprintf(hdr,"\n");
        
        /*  decode tag/length pair(s) */
        elmtLevel = 0;
        FOR_EACH_LIST_ELMT(tag, lst->tags)
        {
            classStr = Class2ClassStr(tag->class);
            formStr = Form2FormStr(CONS);  /* lists are constructed */
            
            fprintf(hdr,"        if ( (tag = BDecTag(b, bytesDecoded, env)) != ");
            
            if (tag->class == UNIV)
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %s))\n", classStr, formStr, Code2UnivCodeStr(tag->code));
            else
                fprintf(hdr,"MAKE_TAG_ID(%s, %s, %d))\n", classStr, formStr, tag->code);
            fprintf(hdr,"       {\n");
            fprintf(hdr,"           Asn1Error(\"%s::B%s: ERROR - wrong tag\\n\");\n", td->cppTypeDefInfo->className, r->decodeBaseName);
            fprintf(hdr,"           longjmp(env, %d);\n", longJmpValG--);
            fprintf(hdr,"       }\n");
            
            fprintf(hdr,"       elmtLen%d = BDecLen(b, bytesDecoded, env);\n", ++elmtLevel);
        }
        
        fprintf(hdr,"        B%s(b, tag, elmtLen%d, bytesDecoded, env);\n", 
                r->decodeContentBaseName, elmtLevel);
        
        /* grab any EOCs that match redundant, indef lengths */
        for (i = elmtLevel-1; i > 0; i--)
        {
            fprintf(hdr,"         if (elmtLen%d == INDEFINITE_LEN)\n", i);
            fprintf(hdr,"             BDecEoc(b, bytesDecoded, env);\n");
        }
        
        fprintf(hdr,"    }\n\n");
    }
    /* end of BDec inline */



    if (printEncodersG)
        fprintf(hdr,"    %s B%s(%s b);\n", lenTypeNameG, 
                r->encodeContentBaseName,bufTypeNameG);    

    if (printDecodersG)
        fprintf(hdr,"    void   B%s(%s b, %s tag, %s elmtLen, %s& bytesDecoded, %s env);\n\n", r->decodeContentBaseName, bufTypeNameG, tagTypeNameG, lenTypeNameG, lenTypeNameG, envTypeNameG );    

    fprintf(hdr,"    PDU_MEMBER_MACROS\n");
    fprintf(hdr,"};\n\n\n");

}  /* PrintCppListClass */


/*
 * This major Bogosity results from gcc2.2.2 inability to handle
 * templates properly
 */
static void
PrintCppListMethods PARAMS((src, hdr, mods, m, r, td, parent, lst),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* lst)
{
    char* lcn; /* list class name */
    char* ecn; /* (list) elmt class name */
    int elmtLevel;
    int i;
    enum BasicTypeChoiceId tmpTypeId;
    Tag* tag;
    char* classStr;
    char* formStr;
    int tagLen;

    lcn = td->cppTypeDefInfo->className;
    ecn = lst->basicType->a.setOf->cppTypeRefInfo->className;

    if (printPrintersG)
    {
        fprintf(src,"void %s::Print(ostream& os)\n",
                td->cppTypeDefInfo->className);
        fprintf(src,"{\n");
        fprintf(src,"    os << \"{ -- SEQUENCE/SET OF -- \" << endl;\n");
        fprintf(src,"    indentG += stdIndentG;\n");
        
        fprintf(src,"    SetCurrToFirst();\n");
        fprintf(src,"    for (; Curr() != NULL; GoNext())\n");
        fprintf(src,"    {\n");
        fprintf(src,"        Indent(os, indentG);\n");
        fprintf(src,"        os << *Curr();\n");
        fprintf(src,"        if ( Curr() != Last())\n");
        fprintf(src,"            os << \",\";\n");
        fprintf(src,"        os << endl;\n");
        fprintf(src,"    }\n");
        
        fprintf(src,"    indentG -= stdIndentG;\n");
        fprintf(src,"    Indent(os, indentG);\n");
        fprintf(src,"    os << \"}\";\n");
        
        fprintf(src,"}   /* Print */\n\n\n");
    }

    fprintf(src,"void  %s::SetCurrElmt(unsigned long int index)\n", lcn);
    fprintf(src,"{\n");
    fprintf(src,"    unsigned long int i;\n");
    fprintf(src,"    curr = first;\n");
    fprintf(src,"    for( i = 0; (i < (count-1)) && (i < index); i++)\n");
    fprintf(src,"    {\n");
    fprintf(src,"        curr = curr->next;\n");
    fprintf(src,"    }\n");
    fprintf(src,"}  /*  %s::SetCurrElmt */\n\n\n",lcn);


    fprintf(src,"unsigned long int  %s::GetCurrElmtIndex()\n",lcn);
    fprintf(src,"{\n");
    fprintf(src,"    unsigned long int i;\n");
    fprintf(src,"    struct AsnListElmt* tmp;\n");
    fprintf(src,"    if (curr != NULL)\n");
    fprintf(src,"    {\n");
    fprintf(src,"        for( i = 0, tmp = first; tmp != NULL; i++)\n");
    fprintf(src,"        {\n");
    fprintf(src,"            if (tmp == curr)\n");
    fprintf(src,"                return(i);\n");
    fprintf(src,"            else\n");
    fprintf(src,"                tmp = tmp->next;\n");
    fprintf(src,"        }\n");
    fprintf(src,"    }\n");
    fprintf(src,"    return(count);\n");
    fprintf(src,"}  /*  %s::GetCurrElmtIndex */\n\n\n",lcn);



    fprintf(src,"// alloc new list elmt, put at end of list\n");
    fprintf(src,"//  and return the component type\n");
    fprintf(src,"%s* %s::Append()\n",ecn,lcn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt  = new %s;\n",ecn);
    fprintf(src,"    newElmt->next = NULL;\n");
    fprintf(src,"    if( last == NULL )\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->prev = NULL;\n");
    fprintf(src,"	first = last  = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->prev = last;\n");
    fprintf(src,"        last->next    = newElmt;\n");
    fprintf(src,"	last          = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return( newElmt->elmt );\n");
    fprintf(src,"} /*  %s::Append */\n\n\n",lcn);


    fprintf(src,"// alloc new list elmt, put at begining of list\n");
    fprintf(src,"//  and return the component type\n");
    fprintf(src,"%s*  %s::Prepend()\n",ecn,lcn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n",ecn);
    fprintf(src,"    newElmt->prev = NULL;\n");
    fprintf(src,"    if( first == NULL )\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->next = NULL;\n");
    fprintf(src,"	first = last  = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->next = first;\n");
    fprintf(src,"        first->prev   = newElmt;\n");
    fprintf(src,"	first         = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return( newElmt->elmt );\n");
    fprintf(src,"} /*  %s::Prepend */\n\n\n",lcn);



    fprintf(src,"// alloc new list elmt, insert it before the\n");
    fprintf(src,"// current element and return the component type\n");
    fprintf(src,"// if the current element is null, the new element\n");
    fprintf(src,"// is placed at the beginning of the list.\n");
    fprintf(src,"%s*  %s::InsertBefore()\n", ecn, lcn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n",ecn);
    fprintf(src,"    if (curr == NULL)\n");
    fprintf(src,"    {\n");
    fprintf(src,"        newElmt->next = first;\n");
    fprintf(src,"        newElmt->prev = NULL;\n");
    fprintf(src,"        first = newElmt;\n");
    fprintf(src,"        if (last == NULL)\n");
    fprintf(src,"            last = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->next = curr;\n");
    fprintf(src,"        newElmt->prev = curr->prev;\n");
    fprintf(src,"        curr->prev = newElmt;\n");
    fprintf(src,"        if (curr == first)\n");
    fprintf(src,"            first = newElmt;\n");
    fprintf(src,"        else\n");
    fprintf(src,"            newElmt->prev->next = curr;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return( newElmt->elmt );\n");
    fprintf(src,"} /*  %s::InsertBefore */\n\n\n",lcn);
    
    
    fprintf(src,"// alloc new list elmt, insert it after the\n");
    fprintf(src,"// current element and return the component type\n");
    fprintf(src,"// if the current element is null, the new element\n");
    fprintf(src,"// is placed at the end of the list.\n");
    fprintf(src,"%s* %s::InsertAfter()\n", ecn, lcn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n", ecn);
    fprintf(src,"    if (curr == NULL)\n");
    fprintf(src,"    {\n");
    fprintf(src,"        newElmt->prev = last;\n");
    fprintf(src,"        newElmt->next = NULL;\n");
    fprintf(src,"        last = newElmt;\n");
    fprintf(src,"        if (first == NULL)\n");
    fprintf(src,"            first = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->prev = curr;\n");
    fprintf(src,"        newElmt->next = curr->next;\n");
    fprintf(src,"        curr->next = newElmt;\n");
    fprintf(src,"        if (curr == last)\n");
    fprintf(src,"            last = newElmt;\n");
    fprintf(src,"        else\n");
    fprintf(src,"            curr->next->prev = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return( newElmt->elmt );\n");
    fprintf(src,"} /*  %s::InsertAfter */\n",lcn);



    fprintf(src,"%s&  %s::AppendCopy( %s& elmt)\n",lcn,lcn,ecn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n",ecn);
    fprintf(src,"    *newElmt->elmt = elmt;\n");
    fprintf(src,"    newElmt->next = NULL;\n");
    fprintf(src,"    if( last == NULL )\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->prev = NULL;\n");
    fprintf(src,"	first = last  = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	 newElmt->prev = last;\n");
    fprintf(src,"        last->next    = newElmt;\n");
    fprintf(src,"	 last          = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return(*this);\n");
    fprintf(src,"} /* AppendCopy */\n\n\n");


    fprintf(src," %s&  %s::PrependCopy( %s& elmt)\n",lcn,lcn,ecn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n",ecn);
    fprintf(src,"    *newElmt->elmt = elmt;\n");
    fprintf(src,"    newElmt->prev = NULL;\n");
    fprintf(src,"    if( first == NULL )\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->next = NULL;\n");
    fprintf(src,"	first = last  = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->next = first;\n");
    fprintf(src,"        first->prev   = newElmt;\n");
    fprintf(src,"	first         = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return(*this);\n");
    fprintf(src,"} /*  %s::PrependCopy */\n\n\n",lcn);
    
    
    
    fprintf(src,"// alloc new list elmt, insert it before the\n");
    fprintf(src,"// current element, copy the given elmt into the new elmt\n");
    fprintf(src,"// and return the component type.\n");
    fprintf(src,"// if the current element is null, the new element\n");
    fprintf(src,"// is placed at the beginning of the list.\n");
    fprintf(src,"%s&  %s::InsertBeforeAndCopy(%s& elmt)\n",lcn,lcn,ecn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n",ecn);
    fprintf(src,"    *newElmt->elmt = elmt;\n");
    fprintf(src,"\n");
    fprintf(src,"    if (curr == NULL)\n");
    fprintf(src,"    {\n");
    fprintf(src,"        newElmt->next = first;\n");
    fprintf(src,"        newElmt->prev = NULL;\n");
    fprintf(src,"        first = newElmt;\n");
    fprintf(src,"        if (last == NULL)\n");
    fprintf(src,"            last = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->next = curr;\n");
    fprintf(src,"        newElmt->prev = curr->prev;\n");
    fprintf(src,"        curr->prev = newElmt;\n");
    fprintf(src,"        if (curr == first)\n");
    fprintf(src,"            first = newElmt;\n");
    fprintf(src,"        else\n");
    fprintf(src,"            newElmt->prev->next = curr;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return( *this );\n");
    fprintf(src,"} /* %s::InsertBeforeAndCopy */\n",lcn);
    

    fprintf(src,"// alloc new list elmt, insert it after the\n");
    fprintf(src,"// current element, copy given elmt in to new elmt\n");
    fprintf(src,"//  and return the component type\n");
    fprintf(src,"// if the current element is null, the new element\n");
    fprintf(src,"// is placed at the end of the list.\n");
    fprintf(src,"%s&  %s::InsertAfterAndCopy(%s& elmt)\n",lcn,lcn,ecn);
    fprintf(src,"{\n");
    fprintf(src,"    struct AsnListElmt* newElmt;\n");
    fprintf(src,"\n");
    fprintf(src,"    newElmt  = new struct AsnListElmt;\n");
    fprintf(src,"    newElmt->elmt = new %s;\n",ecn);
    fprintf(src,"    *newElmt->elmt = elmt;\n");
    fprintf(src,"    if (curr == NULL)\n");
    fprintf(src,"    {\n");
    fprintf(src,"        newElmt->prev = last;\n");
    fprintf(src,"        newElmt->next = NULL;\n");
    fprintf(src,"        last = newElmt;\n");
    fprintf(src,"        if (first == NULL)\n");
    fprintf(src,"            first = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    else\n");
    fprintf(src,"    {\n");
    fprintf(src,"	newElmt->prev = curr;\n");
    fprintf(src,"        newElmt->next = curr->next;\n");
    fprintf(src,"        curr->next = newElmt;\n");
    fprintf(src,"        if (curr == last)\n");
    fprintf(src,"            last = newElmt;\n");
    fprintf(src,"        else\n");
    fprintf(src,"            curr->next->prev = newElmt;\n");
    fprintf(src,"    }\n");
    fprintf(src,"    count++;\n");
    fprintf(src,"    return( *this );\n");
    fprintf(src,"} /*  %s::InsertAfterAndCopy */\n",lcn);



    if (printEncodersG)
    {
        fprintf(src,"%s %s::B%s(%s b)\n",lenTypeNameG, lcn, 
                r->encodeContentBaseName, bufTypeNameG);
        fprintf(src,"{\n");
        fprintf(src,"    struct AsnListElmt* currElmt;\n");
        fprintf(src,"    %s elmtLen;\n",lenTypeNameG);
        fprintf(src,"    %s totalLen = 0;\n",lenTypeNameG);
        
        fprintf(src,"    for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)\n");
        fprintf(src,"    {\n");
        /* encode Eoc(s) if nec */
        PrintCppEocEncoders(src, td, lst->basicType->a.setOf, "b");

        tmpTypeId = GetBuiltinType(lst->basicType->a.setOf);
        /* list element types cannot by ANY DEFINED BY */
        if (tmpTypeId == BASICTYPE_ANY)
        {
            fprintf(src,"        currElmt->elmt->SetTypeBy???(???);\n");
            fprintf(src,"        elmtLen = currElmt->elmt->B%s(b);\n", r->encodeBaseName);
        }
        else
        {
            fprintf(src,"        elmtLen = currElmt->elmt->B%s(b);\n", r->encodeContentBaseName);
        }

        /* encode list elmt tag/len pairs here */
        PrintCppTagAndLenEncodingCode(src, td, lst->basicType->a.setOf, "elmtLen", "b");

        fprintf(src,"        totalLen += elmtLen;\n");
        fprintf(src,"    }\n");
        
        fprintf(src,"    return(totalLen);\n");
        fprintf(src,"} /* %s::B%s */\n\n\n", lcn, r->encodeContentBaseName);
    }

    if (printDecodersG)
    {
        fprintf(src,"void  %s::B%s( %s b, %s tag0, %s elmtLen0,\n",lcn,
                r->decodeContentBaseName, bufTypeNameG, tagTypeNameG,
                lenTypeNameG);
        fprintf(src,"                                  %s& bytesDecoded, %s env)\n",lenTypeNameG, envTypeNameG);
        fprintf(src,"{\n");
        fprintf(src,"    %s* listElmt;\n",ecn);
        fprintf(src,"    %s tag1;\n", tagTypeNameG);
        fprintf(src,"    %s listBytesDecoded = 0;\n",lenTypeNameG);
        
        /* print local vars elmtLen for decoding list component */
        elmtLevel = CppCountVariableLevels(lst->basicType->a.setOf);
        
        for (i = 1; i <= elmtLevel; i++)
            fprintf(src,"    %s elmtLen%d;\n", lenTypeNameG, i);

        fprintf(src,"\n");
        
        
        fprintf(src,"    while ((listBytesDecoded < elmtLen0) || (elmtLen0 == INDEFINITE_LEN))\n");
        fprintf(src,"    {\n");
        fprintf(src,"        tag1 = BDecTag(b, listBytesDecoded, env);\n");
        
        fprintf(src,"        if ((tag1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))\n");
        fprintf(src,"        {\n");
        fprintf(src,"            BDEC_2ND_EOC_OCTET(b, listBytesDecoded, env);\n");
        fprintf(src,"            break;\n");
        fprintf(src,"        }\n");
        
        PrintCppListTagAndLenDecCode(src, td, lst->basicType->a.setOf);
        
        fprintf(src,"        listElmt = Append();\n");

        /* decode content */
        tmpTypeId = GetBuiltinType(lst->basicType->a.setOf);
        /* note: cannot be ANY DEFINED BY as SET OF/SEQ OF ELMT */
        if (tmpTypeId == BASICTYPE_ANY)
        {
            fprintf(src,"        listElmt->SetTypeBy???(???);\n");
            
            fprintf(src,"        listElmt->B%s(b, listBytesDecoded, env);\n", r->decodeBaseName, elmtLevel);
        }
        else
        {
            fprintf(src,"        listElmt->B%s(b, tag1, elmtLen%d, listBytesDecoded, env);\n", r->decodeContentBaseName, elmtLevel);
        }
        
        /* grab any EOCs that match redundant, indef lengths */
        for (i = elmtLevel-1; i > 0; i--)
        {
            fprintf(src,"        if (elmtLen%d == INDEFINITE_LEN)\n", i);
            fprintf(src,"            BDecEoc(b, listBytesDecoded, env);\n");
        }


        fprintf(src,"    }\n\n"); /* end of while */
     
        fprintf(src,"    bytesDecoded += listBytesDecoded;\n");
        
        fprintf(src,"}  /*  %s::B%s */\n\n\n",lcn, r->decodeContentBaseName);
    }

}  /* PrintCppListMethods */


static void
PrintCppAnyDefCode PARAMS((src, hdr, mods, m, r, td, parent, any),
FILE* src _AND_
FILE* hdr _AND_
ModuleList* mods _AND_
Module* m _AND_
CppRules* r _AND_
TypeDef* td _AND_
Type* parent _AND_
Type* any)
{
    fprintf(hdr," /* ");
    SpecialPrintType(hdr, td, td->type);
    fprintf(hdr," */\n");
    fprintf(hdr,"typedef %s %s;\n\n", 
            td->type->cppTypeRefInfo->className, 
            td->cppTypeDefInfo->className);
}  /* PrintCppAnyDefCode */



/*
 * Prints code to decode and check tags and lengths for a 
 * SEQ OF/SET OF element.
 *
 * as usual, assumes:
 *  b for buf var name
 *  elmtLen for elmts len var name
 *  env for environment var name
 *  listBytesDecoded for the runing total bytes decoded
 *  tag1 for tag
 *  
 *  Assumes first tag has been decoded and is in 'tag1' var
 */
static void
PrintCppListTagAndLenDecCode PARAMS((src, td, t),
FILE* src _AND_
TypeDef* td _AND_
Type* t)
{
    TagList* tags;
    Tag* tag;
    int elmtLevel;
    int stoleChoiceTags;

    elmtLevel = 0;
    
    tags = GetTags(t, &stoleChoiceTags);
    if (stoleChoiceTags)
    {
        fprintf(src,"        if (!( ");
        FOR_EACH_LIST_ELMT(tag, tags)
        {
            fprintf(src,"(tag1 == ");
            PrintMakeTag(src, tag);
            if (tag->form == ANY_FORM)    
            {
                fprintf(src,") ||\n            (tag1 == ");
                tag->form = CONS;
                PrintMakeTag(src, tag);
                fprintf(src,")\n");
            }
            else
                fprintf(src,")");

            if (tag != (Tag*)LAST_LIST_ELMT(tags))
                fprintf(src," ||\n         ");
        }
        fprintf(src,"))\n");
        fprintf(src,"        {\n");
        fprintf(src,"            Asn1Error(\"Unexpected Tag\\n\");\n");
        fprintf(src,"            longjmp(env, %d);\n",longJmpValG--);
        fprintf(src,"        }\n\n");
        fprintf(src,"        elmtLen%d = BDecLen (b, listBytesDecoded, env);\n", ++elmtLevel);
    }
    
    else /* didn't steal nested choice's tags */
    {
        
        GListFirst(tags);

        FOR_EACH_LIST_ELMT(tag, tags)
        {

            fprintf(src,"        if ((tag1 != ");
            PrintMakeTag(src, tag);
            if (tag->form == ANY_FORM)    
            {
                fprintf(src,") &&\n         (tag1 != ");
                tag->form = CONS;
                PrintMakeTag(src, tag);
                fprintf(src,"))\n");
            }
            else
                fprintf(src,"))\n");

            fprintf(src,"        {\n");
            fprintf(src,"            Asn1Error(\"Unexpected Tag\\n\");\n");
            fprintf(src,"            longjmp(env, %d);\n",longJmpValG--);
            fprintf(src,"        }\n\n");
            fprintf(src,"        elmtLen%d = BDecLen (b, listBytesDecoded, env);\n", ++elmtLevel);

            if (tag != (Tag*)LAST_LIST_ELMT(tags))
                fprintf(src, "        tag1 = BDecTag(b, listBytesDecoded, env);\n\n");

        }
        
        /*
         * if this seq element is CHOICE &&
         * we didn't steal its tags then we must grab 
         * the key tag out of the contained CHOICE
         */
        if (GetBuiltinType(t) == BASICTYPE_CHOICE)
        {
            fprintf(src,"        tag1 = BDecTag(b, listBytesDecoded, env);\n");
            fprintf(src,"        elmtLen%d = BDecLen (b, listBytesDecoded, env);\n", ++elmtLevel);
        }
    }
    FreeTags(tags);
} /* PrintCppListTagAndLenDecCode */


void
PrintMakeTag PARAMS((f, tag),
FILE* f _AND_
Tag* tag)
{
    char* classStr;
    char* formStr;

    classStr = Class2ClassStr(tag->class);

    if (tag->form == ANY_FORM)  /* default to PRIM for dual form tags */
        formStr = Form2FormStr(PRIM);
    else
        formStr = Form2FormStr(tag->form);
    
    fprintf(f,"MAKE_TAG_ID( %s, %s, ", classStr , formStr);
    if ( tag->class == UNIV)
        fprintf(f,"%s)", Code2UnivCodeStr(tag->code));
    else
        fprintf(f,"%d)", tag->code);

} /* PrintMakeTag */



void
PrintCloneMethod PARAMS((f, td),
FILE* f _AND_
TypeDef* td)
{
    fprintf(f,"      AsnType* Clone() { return new %s; }\n", 
            td->cppTypeDefInfo->className);
}  /* PrintCloneMethod */
 


/* 
 * prints inline declaration of constructors if this class is
 * derived from a library class.
 * assumes FILE* f is positioned in the derived class definition (.h)
 *
 * 12/92 MS - added overloaded "=" ops for string types.
 */
void
PrintDerivedConstructors PARAMS((f, r, td),
FILE* f _AND_
CppRules* r _AND_
TypeDef* td)
{
    enum BasicTypeChoiceId typeId;
    char* derivedClassName;
    char* baseClassName;

    typeId = GetBuiltinType(td->type);
    derivedClassName = td->cppTypeDefInfo->className;
    baseClassName = td->type->cppTypeRefInfo->className;

    /* every class gets the no-arg constructor */
    fprintf(f,"      %s(): %s() {}\n", derivedClassName, baseClassName);
    switch(typeId)
    {
        case(BASICTYPE_ENUMERATED):
        case(BASICTYPE_INTEGER):
        case(BASICTYPE_BOOLEAN):
            fprintf(f,"      %s(int i): %s(i) {}\n", derivedClassName,
                    baseClassName);
            break;

        case(BASICTYPE_REAL):
            fprintf(f,"      %s(double d): %s(d) {}\n", derivedClassName,
                    baseClassName);
            break;

      case(BASICTYPE_OCTETSTRING):
            fprintf(f,"      %s(const char* str): %s(str) {}\n", 
                    derivedClassName, baseClassName);

            fprintf(f,"      %s(const char* str, const unsigned long int len): %s(str,len) {}\n", derivedClassName, baseClassName);

            fprintf(f,"      %s(const %s& o): %s(o) {}\n", derivedClassName, baseClassName, baseClassName);

            /* include overloading of = op. MS 12/92 */
            fprintf(f,"      %s& operator=(const %s& o) {ReSet(o); return *this;}\n", derivedClassName, derivedClassName);
            fprintf(f,"      %s& operator=(const char* str) {ReSet(str); return *this;}\n", derivedClassName);
            break;

        case(BASICTYPE_BITSTRING):
            fprintf(f,"      %s(const unsigned long int bits): %s(bits) {}\n", 
                    derivedClassName, baseClassName);

            fprintf(f,"      %s(const char* str, const unsigned long int bitLen): %s(str, bitLen) {}\n", derivedClassName, baseClassName);

            fprintf(f,"      %s(const %s& b): %s(b) {}\n",  derivedClassName, baseClassName, baseClassName);
            break;

            /* include overloading of = op. MS 12/92 */
            fprintf(f,"      %s& operator=(const %s& b) {ReSet(b); return *this;}\n", derivedClassName, derivedClassName);

        case(BASICTYPE_OID):
            fprintf(f,"      %s(const char* encOid, unsigned long int len): %s(encOid,len) {}\n", derivedClassName, baseClassName);

            fprintf(f,"      %s(const %s& o): %s(o) {}\n", derivedClassName, baseClassName, baseClassName);

            fprintf(f,"      %s(unsigned long int a1, unsigned long int a2, long int a3=-1, long int a4=-1, long int a5=-1, long int a6=-1, long int a7=-1, long int a8=-1, long int a9=-1, long int a10=-1, long int a11=-1): %s(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11) {}\n", baseClassName, derivedClassName, baseClassName);
            
            /* include overloading of = op. MS 12/92 */
            fprintf(f,"      %s& operator=(const %s& o) {ReSet(o); return *this;}\n", derivedClassName, derivedClassName);

            break;


        default:
            /* do nothing */
            break;
    }

}  /* PrintDerivedConstructors */




/*
 *  Prints a Constructor that takes no args.
 *  Assumes file f is positioned inside a class definition
 *  All Classes get this because:
 *     1. All classes have a Clone routine (for ANY)
 *     2. The Clone routine calls new <ClassName> with no args
 *     3. When a derived type explicitly calls the other
 *        constructors that have args, the implicit no arg
 *        constructor is not defined. Thus the Clone method src
 *        causes compile errors if the class is derived
 *        and has multi arg constructors overiding the implicit one.
 */
void
PrintNoArgConstructor PARAMS((f, r, td),
FILE* f _AND_
CppRules* r _AND_
TypeDef* td)

{
    fprintf(f,"      %s() {}\n",td->cppTypeDefInfo->className); 
} 
