/*
 * cpp_rules.h
 * Copyright (C) 1991, 1992 Michael Sample 
 *           and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

/* see asn1module.h for CppTDI (C++ type def info) */

typedef struct CppRules
{
    int  maxDigitsToAppend;  
    char* choiceIdFieldName;   /* name of choiceId field */
    char* choiceIdEnumName;  /* name (tag) for choiceId enum def name */
    char* choiceUnionFieldName; /* what the name of the choice's union is */
    char* choiceUnionName;  /* name (tag) for choice union def name */
    int   capitalizeNamedElmts;
    char* encodeBaseName;
    char* decodeBaseName;
    char* encodeContentBaseName;
    char* decodeContentBaseName;
    char* encodePduBaseName;
    char* decodePduBaseName;
    CppTDI typeConvTbl[BASICTYPE_MACRODEF + 1];
}  CppRules;

extern CppRules cppRulesG;







