/*
 * rules.c - initialized c rule structure
 *           inits a table that contains info about
 *           converting each ASN.1 type to a C++ class
 * Copyright (C) 1991, 1992 Michael Sample 
 *           and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include "snacc_config.h"
#include "list.h"
#include "basetypes.h"
#include "ber.h"
#include "asn1module.h"
#include "cpp_rules.h"


CppRules cppRulesG = 
{
    4,
    "choiceId", 
    "ChoiceIdEnum", 
    "a",
    "ChoiceUnion",
    FALSE,
    "Enc",
    "Dec",
    "EncContent",
    "DecContent",
    "EncPdu",
    "DecPdu",
    {
        {
            BASICTYPE_UNKNOWN,
            "???",
            FALSE,
            FALSE,
            FALSE,
            TRUE,
            TRUE,
            TRUE,
            TRUE,
            "NOT_NULL",
            "unknown"
        },
        {
            BASICTYPE_BOOLEAN,
            "AsnBool",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "bool"
        },
        {
            BASICTYPE_INTEGER,
            "AsnInt",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "integer"
        },
        {
            BASICTYPE_BITSTRING,
            "AsnBits",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "bits"
        },
        {
            BASICTYPE_OCTETSTRING,
            "AsnOcts",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "octs"
        },
        {
            BASICTYPE_NULL,
            "AsnNull",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "null"
        },
        {
            BASICTYPE_OID,
            "AsnOid",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "oid"
        },
        {
            BASICTYPE_REAL,
            "AsnReal",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "real"
        },
        {
            BASICTYPE_ENUMERATED,
            "AsnEnum",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "enumeration"
        },
        {
            BASICTYPE_SEQUENCE,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            TRUE,
            TRUE,
            "NOT_NULL",
            "seq"
        },
        {
            BASICTYPE_SEQUENCEOF,
            "AsnList",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "seqOf"
        },
        {
            BASICTYPE_SET,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            TRUE,
            FALSE,
            "NOT_NULL",
            "set"
        },
        {
            BASICTYPE_SETOF,
            "AsnList",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "setOf"
        },
        {
            BASICTYPE_CHOICE,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            TRUE,
            FALSE,
            "NOT_NULL",
            "choice"
        },
        {
            BASICTYPE_SELECTION,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "foo"
        },
        {
            BASICTYPE_COMPONENTSOF,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "bar"
        },
        {
            BASICTYPE_ANY,
            "AsnAny",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "any"
        },
        {
            BASICTYPE_ANYDEFINEDBY,
            "AsnAnyDefinedBy",
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "anyDefBy"
        },
        {
            BASICTYPE_LOCALTYPEREF,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "foo"
        },
        {
            BASICTYPE_IMPORTTYPEREF,
            NULL,
            FALSE,
            TRUE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "bar"
        },
        {
            BASICTYPE_MACROTYPE,
            NULL,
            FALSE,
            FALSE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "foo"
        },
        {
            BASICTYPE_MACRODEF,
            NULL,
            FALSE,
            FALSE,
            FALSE,
            TRUE,
            TRUE,
            FALSE,
            TRUE,
            "NOT_NULL",
            "foo"
        }
    }
};




