/*
 * expbuf_ex.c - an example of how to call C ASN.1-BER 
 *              encoders and decoders generated by snacc
 *              with the ExpBuf buffer.
 *
 * AUTHOR: Mike Sample
 * DATE:   Mar 92
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/stat.h>
#include "asn_incl.h"
#include "p_rec.h"


main PARAMS((argc, argv),
int argc _AND_
char* argv[])
{
    int fd;
    ExpBuf* buf;
    ExpBuf  b;
    ExpBuf* tmpBuf;
    AsnLen encodedLen;
    AsnLen decodedLen;
    int     val;
    PersonnelRecord pr;
    int      size;
    char*    origData;
    struct stat sbuf;
    jmp_buf env;
    int  decodeErr;
    AsnTag tag;
    

    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s <BER data file name>\n", argv[0]);
        fprintf(stderr, "   Decodes the given PersonnelRecord BER data file\n");
        fprintf(stderr, "   and re-encodes it to stdout\n");
        exit(1);
    }

    fd = open(argv[1], O_RDONLY, 0);
    if (fd < 0 )
    {
        perror("main: fopen");
        exit(1);
    }

    if (fstat(fd, &sbuf) < 0)
    {
        perror("main: fstat");
        exit(1);
    }

    size = sbuf.st_size;
    origData = (char*)malloc(size);
    if ( read(fd, origData, size) != size)
    {
        perror("main: read");
        exit(1);
    }

    close(fd);

    /*
     * the "1024" is the size in bytes of the data 
     * blk to allocate when writing to a buffer that
     * fills up.
     */
    ExpBufInit(1024);

    /*
     * the first argument (512) is the number of bytes to
     * initially allocate for the decoder to allocate from.
     * The second argument (512) is the size in bytes to
     * enlarge the nibble memory by when it fills up
     */
    InitNibbleMem(512, 512);

    /*
     * put the BER data read from the file
     * into buffer format, ready for reading from the
     * beginning
     */
    buf = &b;
    ExpBufInstallDataInBuf(buf, origData, size);

    decodedLen = 0;
    decodeErr = FALSE;
    if ((val = setjmp(env)) == 0)
    {
        BDecPersonnelRecord( &buf, &pr, &decodedLen, env);
    }
    else
    {
        decodeErr = TRUE;
        fprintf(stderr,"ERROR - Decode routines returned %d\n",val);
    }
    
    if (decodeErr)
        exit(1);

    fprintf(stderr,"decodedValue PersonnelRecord ::= ");
    PrintPersonnelRecord(stderr, &pr, 0);
    fprintf(stderr,"\n\n");

    /*
     * allocate a new buffer set up for writing to
     */
    buf = ExpBufAllocBufAndData();

    encodedLen =  BEncPersonnelRecord( &buf, &pr);

    /*
     * Alway check for a buffer write error after encoding
     */
    if (ExpBufWriteError(&buf))
    {
        fprintf(stderr,"ERROR - buffer write error during encoding\n");
        exit(1);
    }


    /*
     * free all of the decoded value since
     * it has been encoded into the buffer.
     * This is much more efficient than freeing
     * each compontent of the value individually
     */
    ResetNibbleMem();

    /*
     * go through buffer(s) and write encoded value
     * to stdout
     */
    buf->curr = buf->dataStart;
    for ( tmpBuf = buf ; tmpBuf != NULL; tmpBuf = tmpBuf->next)
    {
        fwrite(tmpBuf->dataStart, tmpBuf->dataEnd - tmpBuf->dataStart,
               1, stdout);
    }

    return(0);
}
