/*
 * example.c - an example of how to call C ASN.1-BER 
 *             encoders and decoders generated by snacc
 *
 * AUTHOR: Mike Sample
 * DATE:   Mar 92
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/stat.h>
#include "asn_incl.h"
#include "any_test.h"



main PARAMS((argc, argv),
int argc _AND_
char* argv[])
{
    int fd;
    SBuf  buf;
    SBuf  encBuf;
    char* encData;
    AsnLen encodedLen;
    AsnLen decodedLen;
    int     val;
    AnyTestType att;
    int      size;
    char*    origData;
    struct stat sbuf;
    jmp_buf env;

    if (argc != 2)
    {
        fprintf(stderr, "Usage: %s <BER data file name>\n", argv[0]);
        fprintf(stderr, "   Decodes the given PersonnelRecord BER data file\n");
        fprintf(stderr, "   and re-encodes it to stdout\n");
        exit(1);
    }

    fd = open(argv[1], O_RDONLY, 0);
    if (fd < 0 )
    {
        perror("main: fopen");
        exit(1);
    }

    if (fstat(fd, &sbuf) < 0)
    {
        perror("main: fstat");
        exit(1);
    }

    size = sbuf.st_size;
    origData = (char*)malloc(size);
    if ( read(fd, origData, size) != size)
    {
        perror("main: read");
        exit(1);
    }

    close(fd);

    /*
     * puts the given data 'origData' of 'size' bytes
     * into an SBuf and sets the SBuf up for reading
     * origData from the beginning
     */
    SBufInstallData(&buf, origData, size);

    /*
     * the first argument (512) is the number of bytes to
     * initially allocate for the decoder to allocate from.
     * The second argument (512) is the size in bytes to
     * enlarge the nibble memory by when it fills up
     */
    InitNibbleMem(512, 512);


    /*
     * initialize the hash table for the
     * the ANY type mappings.
     * This only needs to be done once per execution
     * (before any encoding or decoding is done)
     */
    InitAnyANY_TEST();

    decodedLen = 0;
    if ((val = setjmp(env)) == 0)
    {
        BDecAnyTestType( &buf, &att, &decodedLen, env);
    }
    else
    {
        fprintf(stderr,"ERROR - Decode routines returned %d\n",val);
        exit(1);
    }
    
    fprintf(stderr,"decodedValue AnyTestType ::= ");
    PrintAnyTestType(stderr, &att, 0);
    fprintf(stderr,"\n\n");

    /*
     * setup a new buffer set up for writing.
     * make sure size is big enough to hold the encoded
     * value (may be larger than decoded value if encoding
     * with indef lengths - so add 512 slush bytes)
     */
    encData = (char*) malloc(size + 512);
    SBufInit(&encBuf, encData, size + 512);
    SBufResetInWriteRvsMode(&encBuf);

    encodedLen =  BEncAnyTestType( &encBuf, &att);
    if ((encodedLen <= 0) || SBufWriteError(&encBuf))
    {
        fprintf(stderr,"ERROR - buffer to hold the encoded value was too small\n");
        exit(1);
    }

    /*
     * free all of the decoded value since
     * it has been encoded into the buffer.
     * This is much more efficient than freeing
     * each compontent of the value individually
     */
    ResetNibbleMem();

    /*
     * write encoded value from encBuf
     * to stdout
     */
    fwrite(SBufDataPtr(&encBuf), SBufDataLen(&encBuf), 1, stdout);

    return(0);
}


