/*
 * asn_tag.C -  ASN.1 tag manipulation routines
 * 
 * MS 92/06/18
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#include "asn_config.h"
#include "asn_len.h"
#include "asn_tag.h"

/*
 * Decode a BER Tag from the given buffer.  Error is 
 * flagged if the tag is too long or if a read error occurs.
 */
AsnTag
BDecTag ( BUF_TYPE  b, AsnLen& bytesDecoded, ENV_TYPE env)
{
    AsnTag tagId;
    AsnTag tmpTagId;
    int i;

    tagId = ((AsnTag) b.GetByte()) << ((sizeof(AsnTag)-1) *8);
    bytesDecoded++;

    /* check if long tag format (ie code > 31) */
    if ( (tagId & (((AsnTag) 0x1f) << ((sizeof(AsnTag)-1)*8))) == 
          (((AsnTag)0x1f) << ((sizeof(AsnTag)-1)*8)))
    {
        i = 2;
        do
        {
            tmpTagId = (AsnTag) b.GetByte();
            tagId |= (tmpTagId << ((sizeof(AsnTag)-i)*8));
            bytesDecoded++;
            i++;
        }
        while ((tmpTagId & (AsnTag)0x80) && (i < sizeof(AsnTag)));
        
        /*
         * check for too long a tag
         */
        if (i > (sizeof(AsnTag)+1))
        {
            Asn1Error("BDecTag: ERROR - tag value overflow\n");
            longjmp(env, -21);
        }
    }

    if (b.ReadError())
    {
        Asn1Error("BDecTag: ERROR - decoded past the end of data\n");
        longjmp(env, -22);
    }

    return(tagId);

} /* BDecTag */
