/*
 *  asn_list.C
 *  
 *  Mike Sample
 *  92/07/02
 *
 * *** NOTE - this is not tested and not used  ****
 *     snacc generates a new class for each list type, 
 *     methods and all.
 *       (gcc choked on templates)
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#include "asn_config.h"
#include "asn_len.h"
#include "asn_tag.h"
#include "asn_list.h"

template <class T>
void AsnList<T>::SetCurrElmt(unsigned long int index)
{
    unsigned long int i;
    curr = first;
    for( i = 0; (i < (count-1)) && (i < index); i++)
    {
        curr = curr->next;
    }
}


// print routine for lists
template <class T>
ostream& operator<<(ostream& os, AsnList<T>& l)
{
    os << "SEQUENCE OF { ";

    l.SetCurrToFirst();
    for (; l.Curr() != NULL; l.GoNext())
    {
        os << *l.Curr();
        if ( l.Curr() != l.Last())
            os << ", ";
    }
    
    os << " }";
    return(os);
}  



// alloc new list elmt, put at end of list
//  and return the component type
template <class T>
T& AsnList<T>::Append()
{
    AsnListElmt* newElmt;

    neElmt  = new AsnlistElmt;

    newElmt->next = NULL;

    if( last == NULL )
    {
	newElmt->prev = NULL;
	first = last  = newElmt;
    }
    else
    {
	newElmt->prev = last;
        last->next    = newElmt;
	last          = newElmt;
    }

    count++;

    return( newElmt->elmt );

} /* AsnList::Append */


// alloc new list elmt, put at beggining of list
//  and return the component type
template <class T>
T& AsnList<T>::Prepend()
{
    AsnListElmt* newElmt;

    newElmt  = new AsnlistElmt;

    newElmt->prev = NULL;

    if( first == NULL )
    {
	newElmt->next = NULL;
	first = last  = newElmt;
    }
    else
    {
	newElmt->next = first;
        first->prev   = newElmt;
	first         = newElmt;
    }

    count++;

    return( newElmt->elmt );

} /* AsnList::Prepend */

template <class T>
AsnList<T>& AsnList<T>::AppendAndCopy(T& elmt)
{
    AsnListElmt* newElmt;

    newElmt  = new AsnlistElmt;

    newElmt->elmt = elmt;

    newElmt->next = NULL;

    if( last == NULL )
    {
	newElmt->prev = NULL;
	first = last  = newElmt;
    }
    else
    {
	newElmt->prev = last;
        last->next    = newElmt;
	last          = newElmt;
    }

    count++;

    return( this);

} /* AppendAndCopy */

template <class T>
AsnList<T>& AsnList<T>::PrependAndCopy(T& elmt)
{
    AsnListElmt* newElmt;

    newElmt  = new AsnlistElmt;

    newElmt->elmt = elmt;

    newElmt->prev = NULL;

    if( first == NULL )
    {
	newElmt->next = NULL;
	first = last  = newElmt;
    }
    else
    {
	newElmt->next = first;
        first->prev   = newElmt;
	first         = newElmt;
    }

    count++;

    return(this);

} /* PrependAndCopy */


template <class T>
void AsnList<T>::BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                                  AsnLen& bytesDecoded, ENV_TYPE env)
{
    T listElmt;
    AsnTag listElmtTagId;
    AsnLen localBytesDecoded = 0;
    AsnLen listElmtLen = 0;


     while ((localBytesDecoded < elmtLen) || (elmtLen == INDEFINITE_LEN))
     {
         listElmtTagId = BDecTag(b, bytesDecoded, env);

         if ((listElmtTagId == EOC) && (elmtLen == INDEFINITE_LEN))
             break;


         listElmt = Append();
         listElmtLen = BDecLen(b, bytesDecoded, env);
         listElmt.BDecContent(b, listElmtTagId, listElmtLen, 
                                   localBytesDecoded, env);
     }
    bytesDecoded += localBytesDecoded;

}  /* AsnList<T>::BDecContent */


template <class T, class U>
int ListsEquiv(AsnList<T>& l1, AsnList<U>& l2)
{
    if (l1.Count() != l2.Count())
        return(FALSE);

    l1.SetCurrToFirst();
    l2.SetCurrToFirst();

    for ( ; l1.Curr() != NULL; l1.GoNext(), l2.GoNext() )
    {
        if (*l1.Curr() !=  *l2.Curr())
        {
            return(FALSE);
        }
    }
    return(TRUE);
}
