/*
 * asn_bool.C - methods for AsnBool (ASN.1 BOOLEAN) class
 *
 * MS 92/06/16
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */


#include "asn_config.h"
#include "asn_len.h"
#include "asn_tag.h"
#include "asn_type.h"
#include "asn_bool.h"

// Prints the BOOLEAN's value in ASN.1 value notation to the given ostream 
void AsnBool::Print(ostream& os)
{
    if (value)
        os << "TRUE";
    else
        os << "FALSE";
} /*  AsnBool::Print */

// Decodes the content of a BOOLEAN and sets this object's value
// to the decoded value. Flags an error if the length is wrong
// or a read error occurs.
void AsnBool::BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                               AsnLen& bytesDecoded, ENV_TYPE env)
{
    if (elmtLen != 1) 
    {
        Asn1Error("AsnBool::BDecContent: ERROR - boolean value too long.\n");
        longjmp(env, -5);
    }

    value = (b.GetByte() != 0);
    bytesDecoded++;
    
    if (b.ReadError())
    {
        Asn1Error( "AsnBool::BDecContent: ERROR - decoded past end of data \n");
        longjmp(env, -6);
    }
}


