/*
 * str_stk.h  - maintains a stack of the components of a bit string
 * or octet string so they can be copied into a single chunk
 *
 * MS 92/07/06
 *
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _str_stk_h_
#define _str_stk_h_

class StrStk
{
    public:
    struct Elmt 
    { 
        char* str;
        unsigned long int len;
    } *stk;
    unsigned long int size;
    unsigned long int growSize;
    unsigned long int nextFreeElmt;
    unsigned long int totalByteLen;
    
    StrStk(int stkSize, int growIncrement) 
    {
        stk = new struct Elmt[stkSize]; 
        size = stkSize;
        growSize = growIncrement;
    }

    void Reset()
    {
        nextFreeElmt = 0;
        totalByteLen = 0;
    }

    void Push(char* str, unsigned long int strLen)
    {
        if (nextFreeElmt >= size)
        {
            struct Elmt* tmpStk;
            /* alloc bigger stack and copy old elmts to it */
            tmpStk = new struct Elmt[size + growSize];
            for (int i = 0 ; i < size; i++)
                tmpStk[i] = stk[i];
            delete stk;
            stk = tmpStk;
            size += growSize;
        }
        totalByteLen += strLen;
        stk[nextFreeElmt].str = str;
        stk[nextFreeElmt++].len = strLen;
    }

    /*
     * copy string pieces (buffer refs) into single block.
     * assumes that the buf is at least totalByteLen byte long.
     */
    void Copy(char* buf)
    {
        unsigned long int curr;
        char* bufCurr;

        bufCurr = buf;
        for (curr = 0; curr < nextFreeElmt; curr++)
        {
            memcpy(bufCurr , stk[curr].str, stk[curr].len);
            bufCurr += stk[curr].len;
        }
    }

};


#endif /* conditional include */
