//
// asn_type.h  - Abstract class that all ASN.1 types are derived from
//               Design motivated by ANY type.
//
//               Runtime cost in speed and space for virtual fcns will
//               hopefully not be too bad
//               
//               If your ASN.1 code does not use ANY or ANY DEFIND BY 
//               types then you could  make the BEnc, BDec and Clone
//               non-virtual in the AsnType to improve performance.
//               (undef SUPPORT_ANY_TYPE)
//
//               NOTE: The virtual encode/decode/print etc fcns
//               could be purely virtual (= 0) creating an abstract class
//               but the ANY handling code needs to instantiate the AsnType
//               base class (via Cloning).   Also it allows for default
//               error reporting for ANY types that have not been 
//               instantiated properly.
//
// Copyright (C) 1992 Michael Sample and the University of British Columbia
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// MS 92

#ifndef _asn_type_h_
#define _asn_type_h_

#define SUPPORT_ANY_TYPE  

class AsnType
{
  public:

    virtual ~AsnType() {}

#ifdef SUPPORT_ANY_TYPE

    virtual void BDec(BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env)
    {
        Asn1Error("ERROR - Attempt to decode an improperly formed ANY type (programming error).\n");
        longjmp(env, -80);
    }

    virtual AsnLen BEnc(BUF_TYPE b)
    {
        Asn1Error("ERROR - Attempt to encode an improperly formed ANY type (programming error).\n");
        return 0;
    }

    virtual AsnType* Clone() { return NULL; }

#else
    void BDec(BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env) {}
    AsnLen BEnc(BUF_TYPE b) { return 0;}
#endif

    // a virtual Print routine allows 
    // << operator overloading to be done here for all ASN.1 types
    virtual void Print(ostream& os) 
    {
         os << "ERROR - Attempt to print an improperly formed ANY type (programming error)." << endl;
    }

};


#endif /* conditional include */





