/*
 * asn_len.h - handle ASN.1 length  encoding/decoding etc.
 * 
 * MS 92/06/18
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_len_h_
#define _asn_len_h_

typedef unsigned long int AsnLen;

#define INDEFINITE_LEN  ~0L /* max unsigned value used for indef rep */

#ifdef USE_INDEF_LEN

#define BEncEocIfNec(b)\
    BEncEoc(b); 

#define BEncConsLen(b, len)\
    2 + BEncIndefLen(b) /* include len for EOC */

#else  /*  default - use definite length - 
           usually faster (for snacc encoders)  and smaller encodings */

#define BEncEocIfNec(b)  /* do nothing */

#define BEncConsLen(b, len)\
    BEncDefLen(b, len)

#endif 

#define BEncIndefLen( b)\
    1;\
    b.PutByteRvs(0x80)

/*
 * use if you know the encoded length will be 0 >= len <= 127
 * Eg for booleans, nulls, any resonable integers and reals
 *
 * NOTE: this particular Encode Routine does NOT return the length
 * encoded (1).  The length counter must be explicity incremented
 */
#define BEncDefLenTo127(b, len)\
    b.PutByteRvs((unsigned char) len)


#define BDEC_2ND_EOC_OCTET(b, bytesDecoded, env)\
{\
    if ((b.GetByte() != 0) || b.ReadError()) {\
        Asn1Warning("Warning - second octet of EOC not zero\n");}\
     bytesDecoded++;\
}

AsnLen BDecLen( BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env);

AsnLen BEncDefLen ( BUF_TYPE b, AsnLen len);

AsnLen BEncEoc(BUF_TYPE b);

void  BDecEoc(BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env);



#endif /* conditional include */
