/*
 * asn_enum.h  - c++ version of ASN.1 ENUMERATED 
 *
 *              inherits from AsnInt but changes universal tag stuff
 * MS 92/06/15
 *
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_enum_h_
#define _asn_enum_h_

class AsnEnum : public AsnInt
{
  public:

    AsnEnum() : AsnInt() {}
    AsnEnum(int i) : AsnInt(i) {}

    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l = BEncContent(b); 
        BEncDefLenTo127(b, l);
        l++;
        l += BEncTag1(b, UNIV, PRIM, ENUM_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded,
                    ENV_TYPE env)
    {
        AsnLen elmtLen;
        if (BDecTag(b, bytesDecoded, env) != MAKE_TAG_ID(UNIV, PRIM, ENUM_TAG_CODE))
        {
            Asn1Error("AsnInt::BDec: ERROR tag on ENUMERATED is wrong.\n");
            longjmp(env,-52);
        }

        elmtLen = BDecLen(b, bytesDecoded, env);
        BDecContent(b, MAKE_TAG_ID(UNIV, PRIM, ENUM_TAG_CODE), elmtLen,
                         bytesDecoded, env);
    }


    PDU_MEMBER_MACROS
};


#endif /* conditional include */
