/*
 * asn_any.h - C++ class for any type
 *
 * MS 92
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_any_h_
#define _asn_any_h_

#include "hash.h"

/* this is put into the hash table with the int or oid as the key */
class AnyInfo
{
  public:
    int    anyId;  /* will be a value from the AnyId enum */
    AsnOid oid;    /* will be zero len/null if intId is valid */
    AsnInt intId;
    AsnType* typeToClone;
};



class AsnAny: public AsnType
{
  public:
    static Table* oidHashTbl;  // all AsnAny class instances
    static Table* intHashTbl;  // share these tables
    AnyInfo* ai; // points to entry in hash tbl for this type
    AsnType* value;

    AsnAny() { ai = NULL; value = NULL; }

    // class level methods
    static void InstallAnyByInt (AsnInt intId, int anyId, AsnType* type);
    static void InstallAnyByOid (AsnOid& oid,  int anyId, AsnType* type);
      
    int GetId() {return((ai)? ai->anyId: -1); }
    void SetTypeByInt(AsnInt id);
    void SetTypeByOid(AsnOid& id);

    AsnLen BEnc(BUF_TYPE b);

    void BDec(BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env);

    PDU_MEMBER_MACROS

    void Print(ostream& os) { value->Print(os); }

};



/* AnyDefinedBy is currently the same as AsnAny */
typedef AsnAny AsnAnyDefinedBy;


#endif /* conditional include */







