(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Created on Sep 15 1988 by Jorge Stolfi                      *)
(* Last modified on Wed Dec 22 17:07:37 PST 1993 by mhb        *)
(*      modified on Tue Jun 16 18:29:59 PDT 1992 by muller     *)
(*      modified on Fri Jan 12  9:36:04 PST 1990 by stolfi     *)

INTERFACE R4;

(* Real quadruples.

   This interface implements the 4-dimensional vector space R^4. 
   It defines the basic linear operations on real quadruples (arrays 
   with 4 REAL components).  See R4x4.i3 and R4IO.i3 for 
   additional operations.  
   
   Index: vectors; reals, vectors of; 
   points; geometry; linear algebra; numerical routines
   
*)

(********************************************************************)
(*                                                                  *)
(* WARNING: DO NOT EDIT THIS FILE.  IT WAS GENERATED MECHANICALLY.  *)
(* See the  Makefile for more details.                              *)
(*                                                                  *)
(********************************************************************)

TYPE
  INT = INTEGER;
  NAT = CARDINAL;
  BOOL = BOOLEAN;

TYPE
  Axis = [0..3];           (* Coordinate selectors *)
  Point = ARRAY Axis OF REAL;  (* A point of R4 *)
  T = Point;

VAR (* CONST *) 
  Origin: T; (* The point (0 0 0 0) *)
  Ones: T;   (* The point (1 1 1 1) *)

PROCEDURE FromCoords(x0, x1, x2, x3: REAL): T;
  (* The quadruple with given coordinates. *)

PROCEDURE Unit(i: Axis): T;
  (* The unit vector on the i-th axis. *)

PROCEDURE Equal(READONLY x, y: T): BOOL; 
  (* Equality *)

PROCEDURE IsZero(READONLY x: T): BOOL;
  (* TRUE if x = (0 0 0 0) *)

PROCEDURE Sum (READONLY x: T): REAL;
  (* Sum of the coordinates x[i]. *)

PROCEDURE Max(READONLY x: T): REAL;
  (* Maximum of the x[i]. *)

PROCEDURE Min(READONLY x: T): REAL;
  (* Minimum of the x[i]. *)

PROCEDURE SumSq(READONLY x: T): REAL;
  (* Sum of x[i]**2. *)

PROCEDURE L1Norm(READONLY x: T): REAL;
  (* Sum of ABS(x[i]). *)

PROCEDURE Length(READONLY x: T): REAL;
PROCEDURE L2Norm(READONLY x: T): REAL;
  (* Euclidean length (sqrt of sum of x[i]**2). *)

PROCEDURE LInfNorm(READONLY x: T): REAL;
  (* Maximum of ABS(READONLY x[i]). *)

PROCEDURE L1Dist(READONLY x, y: T): REAL;
  (* L1Norm(Sub(x,y)). *)

PROCEDURE Dist(READONLY x, y: T): REAL;
PROCEDURE L2Dist(READONLY x, y: T): REAL;
  (* L2Norm(Sub(x,y)). *)

PROCEDURE L2DistSq(READONLY x, y: T): REAL;
  (* SumSq(Sub(x,y)). *)

PROCEDURE LInfDist(READONLY x, y: T): REAL;
  (* LInfNorm(Sub(x,y)). *)

PROCEDURE RelDist(READONLY x, y: T; eps: REAL := 1.0e-37): REAL;
  (* Relative distance between two points, useful in convergence tests.
  The /eps/ parameter specifies the magnitude of the (additive) noise
  in each coordinate. 
  The value of RelDist is defined as   max_i rdist(x[i], y[i])  where 
|
|    rdist(u,v) =  max(|u-v|-eps, 0) / max(|u|, |v|, eps)
|
  The result is between 0.0 and 2.0. A result below 2.0e-7 means the vectors
  differ only at the roundoff error level. *)

PROCEDURE Dot (READONLY x, y: T): REAL;
  (* Dot product of vectors x and y. *)

PROCEDURE Cos (READONLY x, y: T): REAL;
  (* Co-sine of the angle between x and y. *)

PROCEDURE Det(READONLY p0, p1, p2, p3: T): REAL;
  (* Determinant of the matrix with given points as rows *)

PROCEDURE Add(READONLY x, y: T): T; 
  (* Vector sum x + y. *)

PROCEDURE Sub(READONLY x, y: T): T; 
  (* Vector difference x - y. *)

PROCEDURE Minus(READONLY x: T): T; 
  (* Negation of all coordinates. *)

PROCEDURE Scale(alpha: REAL; READONLY x: T): T; 
  (* Scalar multiplication alpha * x.  *)

PROCEDURE Shift(READONLY x: T; delta: REAL): T;
  (* Adds delta to every coordinate of x. *)

PROCEDURE Mix (READONLY x: T; alpha: REAL; READONLY y: T; beta: REAL): T;
  (* Linear combination x * alpha + y * beta. *)

PROCEDURE Weigh (READONLY x, y: T): T;
  (* Returns z such that z[i] = x[i] * y[i]. *)

TYPE Function = PROCEDURE (x: REAL): REAL;

PROCEDURE FMap (READONLY x: T; F: Function): T;
  (* Returns z such that z[i] = F(x[i]). *)

PROCEDURE Direction(READONLY x: T): T; 
  (* Divides x by Length(x). An error if x = (0 0 0 0). *)

PROCEDURE Cross(READONLY p1, p2, p3: T): T;
  (* Cross product: Det(p, q, r, ...) = Dot(p, Cross(q, r, ...))  *)

END R4.
 
