(*
   SimpleServer.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: SimpleServer.m3,v 1.4 1992/05/20 22:36:49 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * SimpleServer:
 *   Used with stub files generated from
 *       m3rpcgen [-f] simple.x
 *)

IMPORT RPC, RPCSun, simple, Time;
IMPORT Scan, Wr, Fmt, ParseParams, Thread;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted, RPCSun.Erred *>

TYPE MySimple1 = simple.Vers_1 OBJECT OVERRIDES Incr := Increment; END;


PROCEDURE Increment (<*UNUSED*> o: MySimple1; i: INTEGER): INTEGER
  RAISES {} =
  BEGIN
    Wr.PutText(
      stdout, Fmt.F("Increment(%s) -> %s\n", Fmt.Int(i), Fmt.Int(i + 1)));
    Wr.Flush(stdout);
    RETURN i + 1;
  END Increment;


(*
 * Main
 *)
VAR
  progNum                                         := simple.Simple_prognum;
  hostAddr, progVersion, port: INTEGER;
  protocol                   : RPCSun.Protocol;
  bi                         : RPCSun.BindingInfo;
BEGIN
  TRY
    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-t") THEN
      progNum := RPCSun.TransientProgram;
    END;
    ParseParams.EndParsing();

    Wr.PutText(stdout, "Start of SimpleServer\n");
    Wr.Flush(stdout);

    bi :=
      RPCSun.Export(simple.GetVers_1ServerProc(NEW(MySimple1)), progNum,
                    simple.Vers_1_versnum, RPCSun.Protocol.UDP);
    RPCSun.DecodeBindingInfo(
      bi, hostAddr, progNum, progVersion, port, protocol);

    Wr.PutText(stdout, "Exported simple via UDP, progNum = "
                         & Fmt.Int(progNum) & "\n");
    Wr.Flush(stdout);

    LOOP Time.LongPause(1000); END;
  EXCEPT
    RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  | Scan.BadFormat => Wr.PutText(stderr, "Usage: SimpleServer [-t]\n");
  END;
END Main.
