(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov  2 21:55:27 1989 by muller         *)
(*      modified on Fri Sep 29 15:43:49 1989 by kalsow         *)
(*      modified on Sun May  7 15:46:59 1989 by stolfi         *)

MODULE Integer;

IMPORT Word;

PROCEDURE New (value: T): REF T =
  VAR r: REF T;
  BEGIN
    r := NEW (REF T);
    r^ := value;
    RETURN r;
  END New;

PROCEDURE NewArray (size: CARDINAL;  value: T := 0): REF ARRAY OF T =
  VAR arr: REF ARRAY OF T;
  BEGIN
    arr := NEW (REF ARRAY OF T, size);
    (* Assumes the allocator initializes to 0 automatically: *)
    IF value # 0 THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END NewArray;

PROCEDURE UntracedNew (value: T): UNTRACED REF T =
  VAR r: UNTRACED REF T;
  BEGIN
    r := NEW (UNTRACED REF T);
    r^ := value;
    RETURN r;
  END UntracedNew;

PROCEDURE UntracedNewArray (size: CARDINAL;  value: T := 0):
    UNTRACED REF ARRAY OF T =
  VAR arr: UNTRACED REF ARRAY OF T;
  BEGIN
    arr := NEW (UNTRACED REF ARRAY OF T, size);
    (* Assumes the allocator initializes to 0 automatically: *)
    IF value # 0 THEN
      FOR i := 0 TO size - 1 DO arr[i] := value END
    END;
    RETURN arr
  END UntracedNewArray;

PROCEDURE Compare (a, b: T): INTEGER =
  BEGIN
    RETURN Word.Minus (a, b);
  END Compare;

PROCEDURE Lt (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a < b);
  END Lt;

PROCEDURE Eq (a, b: T): BOOLEAN =
  BEGIN
    RETURN (a = b);
  END Eq;

PROCEDURE Hash (a: T): INTEGER =
  BEGIN
    RETURN a;
  END Hash;

BEGIN
END Integer.

