(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Sep 26 22:36:29 1991 by kalsow         *)
(*      modified on Fri Nov  3 14:08:45 1989 by muller         *)


INTERFACE Cast;

(* This interface provides SAFE loopholes.

   Index: LOOPHOLE *)

PROCEDURE RealToInt (r: REAL): INTEGER  RAISES {};
(* == LOOPHOLE (r, INTEGER) *)

PROCEDURE LongrealToInt (l: LONGREAL): ARRAY [0..1] OF INTEGER  RAISES {};
(* == LOOPHOLE (l, ARRAY OF INTEGER) *)

PROCEDURE ExtendedToInt (e: EXTENDED): ARRAY [0..1] OF INTEGER  RAISES {};
(* == LOOPHOLE (e, ARRAY OF INTEGER) *)

PROCEDURE RefToInt (r: REFANY): INTEGER  RAISES {};
(* == LOOPHOLE (r, INTEGER) *)

PROCEDURE AddressToInt (a: ADDRESS): INTEGER  RAISES {};
(* == LOOPHOLE (a, INTEGER) *)

END Cast.
